/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.ErasureCoding;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClientProtocol
implements ClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterClientProtocol.class.getName());
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final FileSubclusterResolver subclusterResolver;
    private final ActiveNamenodeResolver namenodeResolver;
    private final String superUser;
    private final String superGroup;
    private final ErasureCoding erasureCoding;

    RouterClientProtocol(Configuration conf, RouterRpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.rpcClient = rpcServer.getRPCClient();
        this.subclusterResolver = rpcServer.getSubclusterResolver();
        this.namenodeResolver = rpcServer.getNamenodeResolver();
        this.superUser = System.getProperty("user.name");
        this.superGroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.erasureCoding = new ErasureCoding(rpcServer);
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public Map<FederationNamespaceInfo, Token<DelegationTokenIdentifier>> getDelegationTokens(Text renewer) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return null;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return 0L;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod remoteMethod = new RemoteMethod("getBlockLocations", new Class[]{String.class, Long.TYPE, Long.TYPE}, new RemoteParam(), offset, length);
        return this.rpcClient.invokeSequential(locations, remoteMethod, LocatedBlocks.class, null);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getServerDefaults");
        String ns = this.subclusterResolver.getDefaultNamespace();
        return (FsServerDefaults)this.rpcClient.invokeSingle(ns, method);
    }

    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        if (createParent && this.isPathAll(src)) {
            int index = src.lastIndexOf("/");
            String parent = src.substring(0, index);
            LOG.debug("Creating {} requires creating parent {}", (Object)src, (Object)parent);
            FsPermission parentPermissions = RouterClientProtocol.getParentPermission(masked);
            boolean success = this.mkdirs(parent, parentPermissions, createParent);
            if (!success) {
                LOG.error("Couldn't create parents for {}", (Object)src);
            }
        }
        RemoteLocation createLocation = this.rpcServer.getCreateLocation(src);
        RemoteMethod method = new RemoteMethod("create", new Class[]{String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class}, createLocation.getDest(), masked, clientName, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName);
        return (HdfsFileStatus)this.rpcClient.invokeSingle(createLocation, method);
    }

    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("append", new Class[]{String.class, String.class, EnumSetWritable.class}, new RemoteParam(), clientName, flag);
        return this.rpcClient.invokeSequential(locations, method, LastBlockWithStatus.class, null);
    }

    public boolean recoverLease(String src, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("recoverLease", new Class[]{String.class, String.class}, new RemoteParam(), clientName);
        Boolean result = this.rpcClient.invokeSequential(locations, method, Boolean.class, Boolean.TRUE);
        return result;
    }

    public boolean setReplication(String src, short replication) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setReplication", new Class[]{String.class, Short.TYPE}, new RemoteParam(), replication);
        Boolean result = this.rpcClient.invokeSequential(locations, method, Boolean.class, Boolean.TRUE);
        return result;
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setStoragePolicy", new Class[]{String.class, String.class}, new RemoteParam(), policyName);
        this.rpcClient.invokeSequential(locations, method, null, null);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getStoragePolicies");
        String ns = this.subclusterResolver.getDefaultNamespace();
        return (BlockStoragePolicy[])this.rpcClient.invokeSingle(ns, method);
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setPermission", new Class[]{String.class, FsPermission.class}, new RemoteParam(), permissions);
        if (this.isPathAll(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setOwner", new Class[]{String.class, String.class, String.class}, new RemoteParam(), username, groupname);
        if (this.isPathAll(src)) {
            this.rpcClient.invokeConcurrent(locations, method);
        } else {
            this.rpcClient.invokeSequential(locations, method);
        }
    }

    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("addBlock", new Class[]{String.class, String.class, ExtendedBlock.class, DatanodeInfo[].class, Long.TYPE, String[].class, EnumSet.class}, new RemoteParam(), clientName, previous, excludedNodes, fileId, favoredNodes, addBlockFlags);
        return this.rpcClient.invokeSequential(locations, method, LocatedBlock.class, null);
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getAdditionalDatanode", new Class[]{String.class, Long.TYPE, ExtendedBlock.class, DatanodeInfo[].class, String[].class, DatanodeInfo[].class, Integer.TYPE, String.class}, new RemoteParam(), fileId, blk, existings, existingStorageIDs, excludes, numAdditionalNodes, clientName);
        return this.rpcClient.invokeSequential(locations, method, LocatedBlock.class, null);
    }

    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("abandonBlock", new Class[]{ExtendedBlock.class, Long.TYPE, String.class, String.class}, b, fileId, new RemoteParam(), holder);
        this.rpcClient.invokeSingle(b, method);
    }

    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("complete", new Class[]{String.class, String.class, ExtendedBlock.class, Long.TYPE}, new RemoteParam(), clientName, last, fileId);
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, null);
    }

    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("updateBlockForPipeline", new Class[]{ExtendedBlock.class, String.class}, block, clientName);
        return (LocatedBlock)this.rpcClient.invokeSingle(block, method);
    }

    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("updatePipeline", new Class[]{String.class, ExtendedBlock.class, ExtendedBlock.class, DatanodeID[].class, String[].class}, clientName, oldBlock, newBlock, newNodes, newStorageIDs);
        this.rpcClient.invokeSingle(oldBlock, method);
    }

    public long getPreferredBlockSize(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("getPreferredBlockSize", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, Long.class, null);
    }

    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dst);
        if (locs.isEmpty()) {
            throw new IOException("Rename of " + src + " to " + dst + " is not allowed, no eligible destination in the same namespace was found.");
        }
        RemoteMethod method = new RemoteMethod("rename", new Class[]{String.class, String.class}, new RemoteParam(), dstParam);
        return this.rpcClient.invokeSequential(locs, method, Boolean.class, Boolean.TRUE);
    }

    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dst);
        if (locs.isEmpty()) {
            throw new IOException("Rename of " + src + " to " + dst + " is not allowed, no eligible destination in the same namespace was found.");
        }
        RemoteMethod method = new RemoteMethod("rename2", new Class[]{String.class, String.class, options.getClass()}, new RemoteParam(), dstParam, options);
        this.rpcClient.invokeSequential(locs, method, null, null);
    }

    public void concat(String trg, String[] src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        LocatedBlocks targetBlocks = this.getBlockLocations(trg, 0L, 1L);
        if (targetBlocks == null) {
            throw new IOException("Cannot locate blocks for target file - " + trg);
        }
        LocatedBlock lastLocatedBlock = targetBlocks.getLastLocatedBlock();
        String targetBlockPoolId = lastLocatedBlock.getBlock().getBlockPoolId();
        for (String source : src) {
            LocatedBlocks sourceBlocks = this.getBlockLocations(source, 0L, 1L);
            if (sourceBlocks == null) {
                throw new IOException("Cannot located blocks for source file " + source);
            }
            String sourceBlockPoolId = sourceBlocks.getLastLocatedBlock().getBlock().getBlockPoolId();
            if (sourceBlockPoolId.equals(targetBlockPoolId)) continue;
            throw new IOException("Cannot concatenate source file " + source + " because it is located in a different namespace with block pool id " + sourceBlockPoolId + " from the target file with block pool id " + targetBlockPoolId);
        }
        RemoteLocation targetDestination = this.rpcServer.getLocationForPath(trg, true, targetBlockPoolId);
        String[] sourceDestinations = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            String sourceFile = src[i];
            RemoteLocation location = this.rpcServer.getLocationForPath(sourceFile, true, targetBlockPoolId);
            sourceDestinations[i] = location.getDest();
        }
        RemoteMethod method = new RemoteMethod("concat", new Class[]{String.class, String[].class}, targetDestination.getDest(), sourceDestinations);
        this.rpcClient.invokeSingle(targetDestination, method);
    }

    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("truncate", new Class[]{String.class, Long.TYPE, String.class}, new RemoteParam(), newLength, clientName);
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, Boolean.TRUE);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true, false);
        RemoteMethod method = new RemoteMethod("delete", new Class[]{String.class, Boolean.TYPE}, new RemoteParam(), recursive);
        if (this.isPathAll(src)) {
            return this.rpcClient.invokeAll(locations, method);
        }
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, Boolean.TRUE);
    }

    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("mkdirs", new Class[]{String.class, FsPermission.class, Boolean.TYPE}, new RemoteParam(), masked, createParent);
        if (this.isPathAll(src)) {
            return this.rpcClient.invokeAll(locations, method);
        }
        if (locations.size() > 1) {
            try {
                HdfsFileStatus fileStatus = this.getFileInfo(src);
                if (fileStatus != null) {
                    return true;
                }
            }
            catch (IOException ioe) {
                LOG.error("Error requesting file info for path {} while proxing mkdirs", (Object)src, (Object)ioe);
            }
        }
        RemoteLocation firstLocation = locations.get(0);
        return (Boolean)this.rpcClient.invokeSingle(firstLocation, method);
    }

    public void renewLease(String clientName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("renewLease", new Class[]{String.class}, clientName);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, false, false);
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        List<String> children;
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("getListing", new Class[]{String.class, startAfter.getClass(), Boolean.TYPE}, new RemoteParam(), startAfter, needLocation);
        Map<RemoteLocation, DirectoryListing> listings = this.rpcClient.invokeConcurrent(locations, method, false, false, DirectoryListing.class);
        TreeMap<String, HdfsFileStatus> nnListing = new TreeMap<String, HdfsFileStatus>();
        int totalRemainingEntries = 0;
        int remainingEntries = 0;
        boolean namenodeListingExists = false;
        if (listings != null) {
            String lastName = null;
            for (Map.Entry<RemoteLocation, DirectoryListing> entry : listings.entrySet()) {
                RemoteLocation location = entry.getKey();
                HdfsFileStatus[] listing = entry.getValue();
                if (listing == null) {
                    LOG.debug("Cannot get listing from {}", (Object)location);
                    continue;
                }
                totalRemainingEntries += listing.getRemainingEntries();
                HdfsFileStatus[] partialListing = listing.getPartialListing();
                int length = partialListing.length;
                if (length <= 0) continue;
                HdfsFileStatus lastLocalEntry = partialListing[length - 1];
                String lastLocalName = lastLocalEntry.getLocalName();
                if (lastName != null && lastName.compareTo(lastLocalName) <= 0) continue;
                lastName = lastLocalName;
            }
            for (Map.Entry<RemoteLocation, DirectoryListing> entry : listings.values()) {
                DirectoryListing listing = (DirectoryListing)entry;
                if (listing == null) continue;
                namenodeListingExists = true;
                for (HdfsFileStatus file : listing.getPartialListing()) {
                    String filename = file.getLocalName();
                    if (totalRemainingEntries > 0 && filename.compareTo(lastName) > 0) {
                        ++remainingEntries;
                        continue;
                    }
                    nnListing.put(filename, file);
                }
                remainingEntries += listing.getRemainingEntries();
            }
        }
        if ((children = this.subclusterResolver.getMountPoints(src)) != null) {
            Map<String, Long> dates = this.getMountPointDates(src);
            for (String child : children) {
                long date = 0L;
                if (dates != null && dates.containsKey(child)) {
                    date = dates.get(child);
                }
                HdfsFileStatus dirStatus = this.getMountPointStatus(child, 0, date);
                nnListing.put(child, dirStatus);
            }
        }
        if (!namenodeListingExists && nnListing.size() == 0) {
            return null;
        }
        HdfsFileStatus[] combinedData = new HdfsFileStatus[nnListing.size()];
        combinedData = nnListing.values().toArray(combinedData);
        return new DirectoryListing(combinedData, remainingEntries);
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        List<String> children;
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
        HdfsFileStatus ret = null;
        ret = this.isPathAll(src) ? this.getFileInfoAll(locations, method) : this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
        if (ret == null && (children = this.subclusterResolver.getMountPoints(src)) != null && !children.isEmpty()) {
            Map<String, Long> dates = this.getMountPointDates(src);
            long date = 0L;
            if (dates != null && dates.containsKey(src)) {
                date = dates.get(src);
            }
            ret = this.getMountPointStatus(src, children.size(), date);
        }
        return ret;
    }

    public boolean isFileClosed(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("isFileClosed", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, Boolean.class, Boolean.TRUE);
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getFileLinkInfo", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
    }

    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getLocatedFileInfo", new Class[]{String.class, Boolean.TYPE}, new RemoteParam(), needBlockToken);
        return (HdfsLocatedFileStatus)this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
    }

    public long[] getStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("getStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, long[]> results = this.rpcClient.invokeConcurrent(nss, method, true, false, long[].class);
        long[] combinedData = new long[9];
        for (long[] data : results.values()) {
            for (int i = 0; i < combinedData.length && i < data.length; ++i) {
                if (data[i] < 0L) continue;
                int n = i;
                combinedData[n] = combinedData[n] + data[i];
            }
        }
        return combinedData;
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.rpcServer.getDatanodeReport(type, true, 0L);
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        Map<String, DatanodeStorageReport[]> dnSubcluster = this.rpcServer.getDatanodeStorageReportMap(type);
        LinkedHashMap<String, DatanodeStorageReport> datanodesMap = new LinkedHashMap<String, DatanodeStorageReport>();
        for (DatanodeStorageReport[] dns : dnSubcluster.values()) {
            for (DatanodeStorageReport dn : dns) {
                DatanodeInfo dnInfo = dn.getDatanodeInfo();
                String nodeId = dnInfo.getXferAddr();
                if (datanodesMap.containsKey(nodeId)) continue;
                datanodesMap.put(nodeId, dn);
            }
        }
        Collection datanodes = datanodesMap.values();
        DatanodeStorageReport[] combinedData = new DatanodeStorageReport[datanodes.size()];
        combinedData = datanodes.toArray(combinedData);
        return combinedData;
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("setSafeMode", new Class[]{HdfsConstants.SafeModeAction.class, Boolean.TYPE}, action, isChecked);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> results = this.rpcClient.invokeConcurrent(nss, method, true, !isChecked, Boolean.class);
        int numSafemode = 0;
        for (boolean safemode : results.values()) {
            if (!safemode) continue;
            ++numSafemode;
        }
        return numSafemode == results.size();
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("restoreFailedStorage", new Class[]{String.class}, arg);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.class);
        boolean success = true;
        for (boolean s : ret.values()) {
            if (s) continue;
            success = false;
            break;
        }
        return success;
    }

    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("saveNamespace", new Class[]{Long.class, Long.class}, timeWindow, txGap);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Boolean> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.TYPE);
        boolean success = true;
        for (boolean s : ret.values()) {
            if (s) continue;
            success = false;
            break;
        }
        return success;
    }

    public long rollEdits() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("rollEdits", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Long> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        long txid = 0L;
        for (long t : ret.values()) {
            if (t <= txid) continue;
            txid = t;
        }
        return txid;
    }

    public void refreshNodes() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("refreshNodes", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, true);
    }

    public void finalizeUpgrade() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("finalizeUpgrade", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public boolean upgradeStatus() throws IOException {
        String methodName = RouterRpcServer.getMethodName();
        throw new UnsupportedOperationException("Operation \"" + methodName + "\" is not supported");
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("rollingUpgrade", new Class[]{HdfsConstants.RollingUpgradeAction.class}, action);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, RollingUpgradeInfo> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, RollingUpgradeInfo.class);
        RollingUpgradeInfo info = null;
        for (RollingUpgradeInfo infoNs : ret.values()) {
            if (info != null || infoNs == null) continue;
            info = infoNs;
        }
        return info;
    }

    public void metaSave(String filename) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("metaSave", new Class[]{String.class}, filename);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false);
        RemoteMethod method = new RemoteMethod("listCorruptFileBlocks", new Class[]{String.class, String.class}, new RemoteParam(), cookie);
        return this.rpcClient.invokeSequential(locations, method, CorruptFileBlocks.class, null);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("setBalancerBandwidth", new Class[]{Long.class}, bandwidth);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        LinkedList<ContentSummary> summaries = new LinkedList<ContentSummary>();
        FileNotFoundException notFoundException = null;
        try {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false);
            RemoteMethod method = new RemoteMethod("getContentSummary", new Class[]{String.class}, new RemoteParam());
            Map<RemoteLocation, ContentSummary> results = this.rpcClient.invokeConcurrent(locations, method, false, false, ContentSummary.class);
            summaries.addAll(results.values());
        }
        catch (FileNotFoundException e) {
            notFoundException = e;
        }
        List<String> children = this.subclusterResolver.getMountPoints(path);
        if (children != null) {
            for (String child : children) {
                Path childPath = new Path(path, child);
                try {
                    ContentSummary mountSummary = this.getContentSummary(childPath.toString());
                    if (mountSummary == null) continue;
                    summaries.add(mountSummary);
                }
                catch (Exception e) {
                    LOG.error("Cannot get content summary for mount {}: {}", (Object)childPath, (Object)e.getMessage());
                }
            }
        }
        if (summaries.isEmpty() && notFoundException != null) {
            throw notFoundException;
        }
        return this.aggregateContentSummary(summaries);
    }

    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("fsync", new Class[]{String.class, Long.TYPE, String.class, Long.TYPE}, new RemoteParam(), fileId, clientName, lastBlockLength);
        this.rpcClient.invokeSequential(locations, method);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setTimes", new Class[]{String.class, Long.TYPE, Long.TYPE}, new RemoteParam(), mtime, atime);
        this.rpcClient.invokeSequential(locations, method);
    }

    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> targetLocations = this.rpcServer.getLocationsForPath(target, true);
        List<RemoteLocation> linkLocations = this.rpcServer.getLocationsForPath(link, true);
        RemoteLocation linkLocation = linkLocations.get(0);
        RemoteMethod method = new RemoteMethod("createSymlink", new Class[]{String.class, String.class, FsPermission.class, Boolean.TYPE}, new RemoteParam(), linkLocation.getDest(), dirPerms, createParent);
        this.rpcClient.invokeSequential(targetLocations, method);
    }

    public String getLinkTarget(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, true);
        RemoteMethod method = new RemoteMethod("getLinkTarget", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, String.class, null);
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void disallowSnapshot(String snapshot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName, byte[] startPath, int index) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
        return 0L;
    }

    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void removeCachePool(String cachePoolName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("modifyAclEntries", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        this.rpcClient.invokeSequential(locations, method, null, null);
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("removeAclEntries", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        this.rpcClient.invokeSequential(locations, method, null, null);
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("removeDefaultAcl", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, method);
    }

    public void removeAcl(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("removeAcl", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, method);
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setAcl", new Class[]{String.class, List.class}, new RemoteParam(), aclSpec);
        this.rpcClient.invokeSequential(locations, method);
    }

    public AclStatus getAclStatus(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getAclStatus", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, AclStatus.class, null);
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("createEncryptionZone", new Class[]{String.class, String.class}, new RemoteParam(), keyName);
        this.rpcClient.invokeSequential(locations, method);
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getEZForPath", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, EncryptionZone.class, null);
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long prevId) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setXAttr", new Class[]{String.class, XAttr.class, EnumSet.class}, new RemoteParam(), xAttr, flag);
        this.rpcClient.invokeSequential(locations, method);
    }

    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("getXAttrs", new Class[]{String.class, List.class}, new RemoteParam(), xAttrs);
        return this.rpcClient.invokeSequential(locations, method, List.class, null);
    }

    public List<XAttr> listXAttrs(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("listXAttrs", new Class[]{String.class}, new RemoteParam());
        return this.rpcClient.invokeSequential(locations, method, List.class, null);
    }

    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("removeXAttr", new Class[]{String.class, XAttr.class}, new RemoteParam(), xAttr);
        this.rpcClient.invokeSequential(locations, method);
    }

    public void checkAccess(String path, FsAction mode) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, true);
        RemoteMethod method = new RemoteMethod("checkAccess", new Class[]{String.class, FsAction.class}, new RemoteParam(), mode);
        this.rpcClient.invokeSequential(locations, method);
    }

    public long getCurrentEditLogTxid() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getCurrentEditLogTxid", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        Map<FederationNamespaceInfo, Long> ret = this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        long txid = 0L;
        for (long t : ret.values()) {
            if (t <= txid) continue;
            txid = t;
        }
        return txid;
    }

    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        return null;
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.rpcServer.getQuotaModule().setQuota(path, namespaceQuota, storagespaceQuota, type);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        return this.rpcServer.getQuotaModule().getQuotaUsage(path);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        HashMap<String, LinkedList<LocatedBlock>> blockLocations = new HashMap<String, LinkedList<LocatedBlock>>();
        for (LocatedBlock block : blocks) {
            String bpId = block.getBlock().getBlockPoolId();
            LinkedList<LocatedBlock> bpBlocks = (LinkedList<LocatedBlock>)blockLocations.get(bpId);
            if (bpBlocks == null) {
                bpBlocks = new LinkedList<LocatedBlock>();
                blockLocations.put(bpId, bpBlocks);
            }
            bpBlocks.add(block);
        }
        for (Map.Entry entry : blockLocations.entrySet()) {
            String bpId = (String)entry.getKey();
            List bpBlocks = (List)entry.getValue();
            LocatedBlock[] bpBlocksArray = bpBlocks.toArray(new LocatedBlock[bpBlocks.size()]);
            RemoteMethod method = new RemoteMethod("reportBadBlocks", new Class[]{LocatedBlock[].class}, new Object[]{bpBlocksArray});
            this.rpcClient.invokeSingleBlockPool(bpId, method);
        }
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, false);
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        return this.erasureCoding.getErasureCodingPolicies();
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        return this.erasureCoding.getErasureCodingCodecs();
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        return this.erasureCoding.addErasureCodingPolicies(policies);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.removeErasureCodingPolicy(ecPolicyName);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.disableErasureCodingPolicy(ecPolicyName);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.erasureCoding.enableErasureCodingPolicy(ecPolicyName);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        return this.erasureCoding.getErasureCodingPolicy(src);
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        this.erasureCoding.setErasureCodingPolicy(src, ecPolicyName);
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        this.erasureCoding.unsetErasureCodingPolicy(src);
    }

    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        return this.erasureCoding.getECBlockGroupStats();
    }

    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    @Deprecated
    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        return this.listOpenFiles(prevId, EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    public void msync() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, false);
        return null;
    }

    private RemoteParam getRenameDestinations(List<RemoteLocation> srcLocations, String dst) throws IOException {
        List<RemoteLocation> dstLocations = this.rpcServer.getLocationsForPath(dst, true);
        HashMap<RemoteLocation, String> dstMap = new HashMap<RemoteLocation, String>();
        Iterator<RemoteLocation> iterator = srcLocations.iterator();
        while (iterator.hasNext()) {
            RemoteLocation srcLocation = iterator.next();
            RemoteLocation eligibleDst = this.getFirstMatchingLocation(srcLocation, dstLocations);
            if (eligibleDst != null) {
                dstMap.put(srcLocation, eligibleDst.getDest());
                continue;
            }
            iterator.remove();
        }
        return new RemoteParam(dstMap);
    }

    private RemoteLocation getFirstMatchingLocation(RemoteLocation location, List<RemoteLocation> locations) {
        for (RemoteLocation loc : locations) {
            if (!loc.getNameserviceId().equals(location.getNameserviceId())) continue;
            return loc;
        }
        return null;
    }

    private ContentSummary aggregateContentSummary(Collection<ContentSummary> summaries) {
        if (summaries.size() == 1) {
            return summaries.iterator().next();
        }
        long length = 0L;
        long fileCount = 0L;
        long directoryCount = 0L;
        long quota = 0L;
        long spaceConsumed = 0L;
        long spaceQuota = 0L;
        for (ContentSummary summary : summaries) {
            length += summary.getLength();
            fileCount += summary.getFileCount();
            directoryCount += summary.getDirectoryCount();
            quota += summary.getQuota();
            spaceConsumed += summary.getSpaceConsumed();
            spaceQuota += summary.getSpaceQuota();
        }
        ContentSummary ret = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount).quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota).build();
        return ret;
    }

    private HdfsFileStatus getFileInfoAll(List<RemoteLocation> locations, RemoteMethod method) throws IOException {
        Map<RemoteLocation, HdfsFileStatus> results = this.rpcClient.invokeConcurrent(locations, method, HdfsFileStatus.class);
        HdfsFileStatus dirStatus = null;
        for (RemoteLocation loc : locations) {
            HdfsFileStatus fileStatus = results.get(loc);
            if (fileStatus == null) continue;
            if (!fileStatus.isDirectory()) {
                return fileStatus;
            }
            if (dirStatus != null) continue;
            dirStatus = fileStatus;
        }
        return dirStatus;
    }

    private static FsPermission getParentPermission(FsPermission mask) {
        FsPermission ret = new FsPermission(mask.getUserAction().or(FsAction.WRITE_EXECUTE), mask.getGroupAction(), mask.getOtherAction());
        return ret;
    }

    private boolean isPathAll(String path) {
        if (this.subclusterResolver instanceof MountTableResolver) {
            try {
                MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
                MountTable entry = mountTable.getMountPoint(path);
                if (entry != null) {
                    return entry.isAll();
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get mount point", (Throwable)e);
            }
        }
        return false;
    }

    private HdfsFileStatus getMountPointStatus(String name, int childrenNum, long date) {
        long modTime = date;
        long accessTime = date;
        FsPermission permission = FsPermission.getDirDefault();
        String owner = this.superUser;
        String group = this.superGroup;
        try {
            UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
            owner = ugi.getUserName();
            group = ugi.getPrimaryGroupName();
        }
        catch (IOException e) {
            LOG.error("Cannot get the remote user: {}", (Object)e.getMessage());
        }
        long inodeId = 0L;
        return new HdfsFileStatus.Builder().isdir(true).mtime(modTime).atime(accessTime).perm(permission).owner(owner).group(group).symlink(new byte[0]).path(DFSUtil.string2Bytes((String)name)).fileId(inodeId).children(childrenNum).build();
    }

    private Map<String, Long> getMountPointDates(String path) {
        TreeMap<String, Long> ret = new TreeMap<String, Long>();
        if (this.subclusterResolver instanceof MountTableResolver) {
            try {
                List<String> children = this.subclusterResolver.getMountPoints(path);
                for (String child : children) {
                    Long modTime = this.getModifiedTime(ret, path, child);
                    ret.put(child, modTime);
                }
            }
            catch (IOException e) {
                LOG.error("Cannot get mount point", (Throwable)e);
            }
        }
        return ret;
    }

    private long getModifiedTime(Map<String, Long> ret, String path, String child) {
        MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
        String srcPath = path.equals("/") ? "/" + child : path + "/" + child;
        Long modTime = 0L;
        try {
            MountTable entry = mountTable.getMountPoint(srcPath);
            if (entry == null) {
                List<MountTable> entries = mountTable.getMounts(srcPath);
                for (MountTable eachEntry : entries) {
                    if (ret.get(child) != null && ret.get(child) >= eachEntry.getDateModified()) continue;
                    modTime = eachEntry.getDateModified();
                }
            } else {
                modTime = entry.getDateModified();
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get mount point", (Throwable)e);
        }
        return modTime;
    }
}

