/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(TokenCache.class);
    @InterfaceAudience.Private
    public static final String JOB_TOKEN_HDFS_FILE = "jobToken";
    @InterfaceAudience.Private
    public static final String JOB_TOKENS_FILENAME = "mapreduce.job.jobTokenFile";
    private static final Text JOB_TOKEN = new Text("JobToken");
    private static final Text SHUFFLE_TOKEN = new Text("MapReduceShuffleToken");
    private static final Text ENC_SPILL_KEY = new Text("MapReduceEncryptedSpillKey");

    public static byte[] getSecretKey(Credentials credentials, Text alias) {
        if (credentials == null) {
            return null;
        }
        return credentials.getSecretKey(alias);
    }

    public static void obtainTokensForNamenodes(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        TokenCache.obtainTokensForNamenodesInternal(credentials, ps, conf);
    }

    public static void cleanUpTokenReferral(Configuration conf) {
        conf.unset("mapreduce.job.credentials.binary");
    }

    static void obtainTokensForNamenodesInternal(Credentials credentials, Path[] ps, Configuration conf) throws IOException {
        HashSet<FileSystem> fsSet = new HashSet<FileSystem>();
        for (Path p : ps) {
            fsSet.add(p.getFileSystem(conf));
        }
        String masterPrincipal = Master.getMasterPrincipal(conf);
        for (FileSystem fs : fsSet) {
            TokenCache.obtainTokensForNamenodesInternal(fs, credentials, conf, masterPrincipal);
        }
    }

    static boolean isTokenRenewalExcluded(FileSystem fs, Configuration conf) {
        String[] nns = conf.getStrings("mapreduce.job.hdfs-servers.token-renewal.exclude");
        if (nns != null) {
            String host = fs.getUri().getHost();
            for (int i = 0; i < nns.length; ++i) {
                if (!nns[i].equals(host)) continue;
                return true;
            }
        }
        return false;
    }

    static void obtainTokensForNamenodesInternal(FileSystem fs, Credentials credentials, Configuration conf, String renewer) throws IOException {
        String delegTokenRenewer = "";
        if (!TokenCache.isTokenRenewalExcluded(fs, conf)) {
            if (StringUtils.isEmpty((String)renewer)) {
                throw new IOException("Can't get Master Kerberos principal for use as renewer");
            }
            delegTokenRenewer = renewer;
        }
        TokenCache.mergeBinaryTokens(credentials, conf);
        Token[] tokens = fs.addDelegationTokens(delegTokenRenewer, credentials);
        if (tokens != null) {
            for (Token token : tokens) {
                LOG.info("Got dt for " + fs.getUri() + "; " + token);
            }
        }
    }

    private static void mergeBinaryTokens(Credentials creds, Configuration conf) {
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary;
            try {
                binary = Credentials.readTokenStorageFile((Path)FileSystem.getLocal((Configuration)conf).makeQualified(new Path(binaryTokenFilename)), (Configuration)conf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            creds.mergeAll(binary);
        }
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Credentials loadTokens(String jobTokenFile, JobConf conf) throws IOException {
        Path localJobTokenFile = new Path("file:///" + jobTokenFile);
        Credentials ts = Credentials.readTokenStorageFile((Path)localJobTokenFile, (Configuration)conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Task: Loaded jobTokenFile from: " + localJobTokenFile.toUri().getPath() + "; num of sec keys  = " + ts.numberOfSecretKeys() + " Number of tokens " + ts.numberOfTokens());
        }
        return ts;
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Credentials loadTokens(String jobTokenFile, Configuration conf) throws IOException {
        return TokenCache.loadTokens(jobTokenFile, new JobConf(conf));
    }

    @InterfaceAudience.Private
    public static void setJobToken(Token<? extends TokenIdentifier> t, Credentials credentials) {
        credentials.addToken(JOB_TOKEN, t);
    }

    @InterfaceAudience.Private
    public static Token<JobTokenIdentifier> getJobToken(Credentials credentials) {
        return credentials.getToken(JOB_TOKEN);
    }

    @InterfaceAudience.Private
    public static void setShuffleSecretKey(byte[] key, Credentials credentials) {
        credentials.addSecretKey(SHUFFLE_TOKEN, key);
    }

    @InterfaceAudience.Private
    public static byte[] getShuffleSecretKey(Credentials credentials) {
        return TokenCache.getSecretKey(credentials, SHUFFLE_TOKEN);
    }

    @InterfaceAudience.Private
    public static void setEncryptedSpillKey(byte[] key, Credentials credentials) {
        credentials.addSecretKey(ENC_SPILL_KEY, key);
    }

    @InterfaceAudience.Private
    public static byte[] getEncryptedSpillKey(Credentials credentials) {
        return TokenCache.getSecretKey(credentials, ENC_SPILL_KEY);
    }

    @InterfaceAudience.Private
    @Deprecated
    public static Token<?> getDelegationToken(Credentials credentials, String namenode) {
        return credentials.getToken(new Text(namenode));
    }
}

