/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.web.TokenAspect;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.verification.VerificationMode;

public class TestTokenAspect {
    private static DelegationTokenRenewer.RenewAction<?> getActionFromTokenAspect(TokenAspect<DummyFs> tokenAspect) {
        return (DelegationTokenRenewer.RenewAction)Whitebox.getInternalState(tokenAspect, (String)"action");
    }

    @Test
    public void testCachedInitialization() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        Token token = new Token(new byte[0], new byte[0], DummyFs.TOKEN_KIND, new Text("127.0.0.1:1234"));
        ((DummyFs)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getDelegationToken(Matchers.anyString());
        ((DummyFs)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getRenewToken();
        fs.emulateSecurityEnabled = true;
        fs.initialize(new URI("dummyfs://127.0.0.1:1234"), conf);
        fs.tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.times((int)1)))).getDelegationToken(null);
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.times((int)1)))).setDelegationToken(token);
        fs.tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.times((int)1)))).getDelegationToken(null);
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.times((int)1)))).setDelegationToken(token);
    }

    @Test
    public void testGetRemoteToken() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        Token token = new Token(new byte[0], new byte[0], DummyFs.TOKEN_KIND, new Text("127.0.0.1:1234"));
        ((DummyFs)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getDelegationToken(Matchers.anyString());
        ((DummyFs)((Object)Mockito.doReturn((Object)token).when((Object)fs))).getRenewToken();
        fs.initialize(new URI("dummyfs://127.0.0.1:1234"), conf);
        fs.tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs)))).setDelegationToken(token);
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)fs.tokenAspect, (String)"dtRenewer"));
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)fs.tokenAspect, (String)"action"));
    }

    @Test
    public void testGetRemoteTokenFailure() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        IOException e = new IOException();
        ((DummyFs)((Object)Mockito.doThrow((Throwable)e).when((Object)fs))).getDelegationToken(Matchers.anyString());
        fs.emulateSecurityEnabled = true;
        fs.initialize(new URI("dummyfs://127.0.0.1:1234"), conf);
        try {
            fs.tokenAspect.ensureTokenInitialized();
        }
        catch (IOException exc) {
            Assert.assertEquals((Object)e, (Object)exc);
        }
    }

    @Test
    public void testInitWithNoTokens() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        ((DummyFs)((Object)Mockito.doReturn(null).when((Object)fs))).getDelegationToken(Matchers.anyString());
        fs.initialize(new URI("dummyfs://127.0.0.1:1234"), conf);
        fs.tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.never()))).setDelegationToken((Token)Mockito.any());
    }

    @Test
    public void testInitWithUGIToken() throws IOException, URISyntaxException {
        Configuration conf = new Configuration();
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        ((DummyFs)((Object)Mockito.doReturn(null).when((Object)fs))).getDelegationToken(Matchers.anyString());
        Token token = new Token(new byte[0], new byte[0], DummyFs.TOKEN_KIND, new Text("127.0.0.1:1234"));
        fs.ugi.addToken(token);
        fs.ugi.addToken(new Token(new byte[0], new byte[0], new Text("Other token"), new Text("127.0.0.1:8021")));
        Assert.assertEquals((String)"wrong tokens in user", (long)2L, (long)fs.ugi.getTokens().size());
        fs.emulateSecurityEnabled = true;
        fs.initialize(new URI("dummyfs://127.0.0.1:1234"), conf);
        fs.tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs)))).setDelegationToken(token);
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.never()))).getDelegationToken(Matchers.anyString());
        Assert.assertNull((Object)Whitebox.getInternalState((Object)fs.tokenAspect, (String)"dtRenewer"));
        Assert.assertNull((Object)Whitebox.getInternalState((Object)fs.tokenAspect, (String)"action"));
    }

    @Test
    public void testRenewal() throws Exception {
        Configuration conf = new Configuration();
        Token token1 = (Token)Mockito.mock(Token.class);
        Token token2 = (Token)Mockito.mock(Token.class);
        long renewCycle = 100L;
        DelegationTokenRenewer.renewCycle = 100L;
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"bar"});
        DummyFs fs = (DummyFs)((Object)Mockito.spy((Object)((Object)new DummyFs())));
        ((DummyFs)((Object)Mockito.doReturn((Object)token1).doReturn((Object)token2).when((Object)fs))).getDelegationToken(null);
        ((DummyFs)((Object)Mockito.doReturn((Object)token1).when((Object)fs))).getRenewToken();
        ((Token)Mockito.doThrow((Throwable)new IOException("renew failed")).when((Object)token1)).renew(conf);
        ((DummyFs)((Object)Mockito.doThrow((Throwable)new IOException("get failed")).when((Object)fs))).addDelegationTokens(null, null);
        URI uri = new URI("dummyfs://127.0.0.1:1234");
        TokenAspect tokenAspect = new TokenAspect((FileSystem)fs, SecurityUtil.buildTokenService((URI)uri), DummyFs.TOKEN_KIND);
        fs.initialize(uri, conf);
        tokenAspect.initDelegationToken(ugi);
        tokenAspect.ensureTokenInitialized();
        DelegationTokenRenewer.RenewAction<?> action = TestTokenAspect.getActionFromTokenAspect((TokenAspect<DummyFs>)tokenAspect);
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs)))).setDelegationToken(token1);
        Assert.assertTrue((boolean)action.isValid());
        Thread.sleep(200L);
        Assert.assertSame(action, TestTokenAspect.getActionFromTokenAspect((TokenAspect<DummyFs>)tokenAspect));
        Assert.assertFalse((boolean)action.isValid());
        tokenAspect.ensureTokenInitialized();
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs), (VerificationMode)Mockito.times((int)2)))).getDelegationToken(Matchers.anyString());
        ((DummyFs)((Object)Mockito.verify((Object)((Object)fs)))).setDelegationToken(token2);
        Assert.assertNotSame(action, TestTokenAspect.getActionFromTokenAspect((TokenAspect<DummyFs>)tokenAspect));
        action = TestTokenAspect.getActionFromTokenAspect((TokenAspect<DummyFs>)tokenAspect);
        Assert.assertTrue((boolean)action.isValid());
    }

    private static class DummyFs
    extends FileSystem
    implements DelegationTokenRenewer.Renewable,
    TokenAspect.TokenManagementDelegator {
        private static final Text TOKEN_KIND = new Text("DummyFS Token");
        private boolean emulateSecurityEnabled;
        private TokenAspect<DummyFs> tokenAspect;
        private final UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"bar"});
        private URI uri;

        private DummyFs() {
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public void cancelDelegationToken(Token<?> token) throws IOException {
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public URI getCanonicalUri() {
            return super.getCanonicalUri();
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }

        public Token<?> getRenewToken() {
            return null;
        }

        public URI getUri() {
            return this.uri;
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public void initialize(URI name, Configuration conf) throws IOException {
            super.initialize(name, conf);
            this.setConf(conf);
            this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
            this.tokenAspect = new TokenAspect((FileSystem)this, SecurityUtil.buildTokenService((URI)this.uri), TOKEN_KIND);
            if (this.emulateSecurityEnabled || UserGroupInformation.isSecurityEnabled()) {
                this.tokenAspect.initDelegationToken(this.ugi);
            }
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return new FileStatus[0];
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public long renewDelegationToken(Token<?> token) throws IOException {
            return 0L;
        }

        public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        }

        public void setWorkingDirectory(Path new_dir) {
        }
    }
}

