/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import org.apache.hadoop.hdfs.server.namenode.ha.RequestHedgingProxyProvider;
import org.apache.hadoop.io.retry.MultiException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestRequestHedgingProxyProvider {
    private Configuration conf;
    private URI nnUri;
    private String ns;

    @BeforeClass
    public static void setupClass() throws Exception {
        GenericTestUtils.setLogLevel((Logger)RequestHedgingProxyProvider.LOG, (Level)Level.TRACE);
    }

    @Before
    public void setup() throws URISyntaxException {
        this.ns = "mycluster-" + Time.monotonicNow();
        this.nnUri = new URI("hdfs://" + this.ns);
        this.conf = new Configuration();
        this.conf.set("dfs.nameservices", this.ns);
        this.conf.set("dfs.ha.namenodes." + this.ns, "nn1,nn2");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn1", "machine1.foo.bar:8020");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn2", "machine2.foo.bar:8020");
    }

    @Test
    public void testHedgingWhenOneFails() throws Exception {
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(1000L);
                return new long[]{1L};
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(badMock, goodMock));
        long[] stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        ((ClientProtocol)Mockito.verify((Object)badMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)goodMock)).getStats();
    }

    @Test
    public void testRequestNNAfterOneSuccess() throws Exception {
        final AtomicInteger goodCount = new AtomicInteger(0);
        final AtomicInteger badCount = new AtomicInteger(0);
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                goodCount.incrementAndGet();
                Thread.sleep(1000L);
                return new long[]{1L};
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                badCount.incrementAndGet();
                throw new IOException("Bad mock !!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(badMock, goodMock));
        ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
        proxy.getStats();
        Assert.assertEquals((long)1L, (long)goodCount.get());
        Assert.assertEquals((long)1L, (long)badCount.get());
        proxy.getStats();
        Assert.assertEquals((long)2L, (long)goodCount.get());
        Assert.assertEquals((long)1L, (long)badCount.get());
    }

    @Test
    public void testExceptionInfo() throws Exception {
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){
            private boolean first = true;

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                if (this.first) {
                    Thread.sleep(1000L);
                    this.first = false;
                    return new long[]{1L};
                }
                throw new IOException("Expected Exception Info");
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                throw new IOException("Bad Mock! This is Standby!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(badMock, goodMock));
        ClientProtocol proxy = (ClientProtocol)provider.getProxy().proxy;
        proxy.getStats();
        try {
            proxy.getStats();
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Expected Exception Info", (Throwable)e);
        }
    }

    @Test
    public void testHedgingWhenOneIsSlow() throws Exception {
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                Thread.sleep(1000L);
                return new long[]{1L};
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(goodMock, badMock));
        long[] stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        ((ClientProtocol)Mockito.verify((Object)badMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)goodMock)).getStats();
    }

    @Test
    public void testHedgingWhenBothFail() throws Exception {
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenThrow(new Throwable[]{new IOException("Bad mock !!")});
        ClientProtocol worseMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)worseMock.getStats()).thenThrow(new Throwable[]{new IOException("Worse mock !!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(badMock, worseMock));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since both namenodes throw IOException !!");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MultiException));
        }
        ((ClientProtocol)Mockito.verify((Object)badMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)worseMock)).getStats();
    }

    @Test
    public void testPerformFailover() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final int[] isGood = new int[]{1};
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 1) {
                    Thread.sleep(1000L);
                    return new long[]{1L};
                }
                throw new IOException("Was Good mock !!");
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 2) {
                    Thread.sleep(1000L);
                    return new long[]{2L};
                }
                throw new IOException("Bad mock !!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(goodMock, badMock));
        long[] stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Assert.assertEquals((long)2L, (long)counter.get());
        ((ClientProtocol)Mockito.verify((Object)badMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)goodMock)).getStats();
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{badMock});
        Assert.assertEquals((long)3L, (long)counter.get());
        isGood[0] = 2;
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)4L, (long)counter.get());
        provider.performFailover(provider.getProxy().proxy);
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)5L, (long)counter.get());
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)6L, (long)counter.get());
        isGood[0] = 1;
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)7L, (long)counter.get());
        provider.performFailover(provider.getProxy().proxy);
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
    }

    @Test
    public void testFileNotFoundExceptionWithSingleProxy() throws Exception {
        ClientProtocol active = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)active.getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong())).thenThrow(new Throwable[]{new RemoteException("java.io.FileNotFoundException", "File does not exist!")});
        ClientProtocol standby = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)standby.getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong())).thenThrow(new Throwable[]{new RemoteException("org.apache.hadoop.ipc.StandbyException", "Standby NameNode")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(standby, active));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getBlockLocations("/tmp/test.file", 0L, 20L);
            Assert.fail((String)"Should fail since the active namenode throws FileNotFoundException!");
        }
        catch (MultiException me) {
            for (Exception ex : me.getExceptions().values()) {
                IOException rEx = ((RemoteException)((Object)ex)).unwrapRemoteException();
                if (rEx instanceof StandbyException) continue;
                Assert.assertTrue((boolean)(rEx instanceof FileNotFoundException));
            }
        }
        provider.performFailover((Object)active);
        try {
            ((ClientProtocol)provider.getProxy().proxy).getBlockLocations("/tmp/test.file", 0L, 20L);
            Assert.fail((String)"Should fail since the active namenode throws FileNotFoundException!");
        }
        catch (RemoteException ex) {
            IOException rEx = ex.unwrapRemoteException();
            if (rEx instanceof StandbyException) {
                ((ClientProtocol)Mockito.verify((Object)active)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
                ((ClientProtocol)Mockito.verify((Object)standby, (VerificationMode)Mockito.times((int)2))).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            }
            Assert.assertTrue((boolean)(rEx instanceof FileNotFoundException));
            ((ClientProtocol)Mockito.verify((Object)active, (VerificationMode)Mockito.times((int)2))).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
            ((ClientProtocol)Mockito.verify((Object)standby)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
        }
    }

    @Test
    public void testSingleProxyFailover() throws Exception {
        IOException rEx;
        String singleNS = "mycluster-" + Time.monotonicNow();
        URI singleNNUri = new URI("hdfs://" + singleNS);
        Configuration singleConf = new Configuration();
        singleConf.set("dfs.nameservices", singleNS);
        singleConf.set("dfs.ha.namenodes." + singleNS, "nn1");
        singleConf.set("dfs.namenode.rpc-address." + singleNS + ".nn1", RandomStringUtils.randomAlphabetic((int)8) + ".foo.bar:9820");
        ClientProtocol active = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)active.getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong())).thenThrow(new Throwable[]{new RemoteException("java.io.FileNotFoundException", "File does not exist!")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(singleConf, singleNNUri, ClientProtocol.class, this.createFactory(active));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getBlockLocations("/tmp/test.file", 0L, 20L);
            Assert.fail((String)"Should fail since the active namenode throws FileNotFoundException!");
        }
        catch (RemoteException ex) {
            rEx = ex.unwrapRemoteException();
            Assert.assertTrue((boolean)(rEx instanceof FileNotFoundException));
        }
        provider.performFailover((Object)active);
        try {
            ((ClientProtocol)provider.getProxy().proxy).getBlockLocations("/tmp/test.file", 0L, 20L);
            Assert.fail((String)"Should fail since the active namenode throws FileNotFoundException!");
        }
        catch (RemoteException ex) {
            rEx = ex.unwrapRemoteException();
            Assert.assertTrue((boolean)(rEx instanceof IOException));
            Assert.assertTrue((boolean)rEx.getMessage().equals("No valid proxies left. All NameNode proxies have failed over."));
        }
    }

    @Test
    public void testPerformFailoverWith3Proxies() throws Exception {
        this.conf.set("dfs.ha.namenodes." + this.ns, "nn1,nn2,nn3");
        this.conf.set("dfs.namenode.rpc-address." + this.ns + ".nn3", "machine3.foo.bar:8020");
        final AtomicInteger counter = new AtomicInteger(0);
        final int[] isGood = new int[]{1};
        ClientProtocol goodMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)goodMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 1) {
                    Thread.sleep(1000L);
                    return new long[]{1L};
                }
                throw new IOException("Was Good mock !!");
            }
        });
        ClientProtocol badMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)badMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 2) {
                    Thread.sleep(1000L);
                    return new long[]{2L};
                }
                throw new IOException("Bad mock !!");
            }
        });
        ClientProtocol worseMock = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)worseMock.getStats()).thenAnswer((Answer)new Answer<long[]>(){

            public long[] answer(InvocationOnMock invocation) throws Throwable {
                counter.incrementAndGet();
                if (isGood[0] == 3) {
                    Thread.sleep(1000L);
                    return new long[]{3L};
                }
                throw new IOException("Worse mock !!");
            }
        });
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(goodMock, badMock, worseMock));
        long[] stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Assert.assertEquals((long)3L, (long)counter.get());
        ((ClientProtocol)Mockito.verify((Object)badMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)goodMock)).getStats();
        ((ClientProtocol)Mockito.verify((Object)worseMock)).getStats();
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)stats[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{badMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{worseMock});
        Assert.assertEquals((long)4L, (long)counter.get());
        isGood[0] = 2;
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)5L, (long)counter.get());
        provider.performFailover(provider.getProxy().proxy);
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)7L, (long)counter.get());
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)stats[0]);
        Assert.assertEquals((long)8L, (long)counter.get());
        isGood[0] = 3;
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since previously successful proxy now fails ");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof IOException));
        }
        Assert.assertEquals((long)9L, (long)counter.get());
        provider.performFailover(provider.getProxy().proxy);
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)stats[0]);
        Assert.assertEquals((long)11L, (long)counter.get());
        stats = ((ClientProtocol)provider.getProxy().proxy).getStats();
        Assert.assertTrue((stats.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)stats[0]);
        Assert.assertEquals((long)12L, (long)counter.get());
    }

    @Test
    public void testHedgingWhenFileNotFoundException() throws Exception {
        ClientProtocol active = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)active.getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong())).thenThrow(new Throwable[]{new RemoteException("java.io.FileNotFoundException", "File does not exist!")});
        ClientProtocol standby = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)standby.getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong())).thenThrow(new Throwable[]{new RemoteException("org.apache.hadoop.ipc.StandbyException", "Standby NameNode")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(active, standby));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getBlockLocations("/tmp/test.file", 0L, 20L);
            Assert.fail((String)"Should fail since the active namenode throws FileNotFoundException!");
        }
        catch (MultiException me) {
            for (Exception ex : me.getExceptions().values()) {
                IOException rEx = ((RemoteException)((Object)ex)).unwrapRemoteException();
                if (rEx instanceof StandbyException) continue;
                Assert.assertTrue((boolean)(rEx instanceof FileNotFoundException));
            }
        }
        ((ClientProtocol)Mockito.verify((Object)active)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
        ((ClientProtocol)Mockito.verify((Object)standby)).getBlockLocations(Matchers.anyString(), Matchers.anyLong(), Matchers.anyLong());
    }

    @Test
    public void testHedgingWhenConnectException() throws Exception {
        ClientProtocol active = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)active.getStats()).thenThrow(new Throwable[]{new ConnectException()});
        ClientProtocol standby = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)standby.getStats()).thenThrow(new Throwable[]{new RemoteException("org.apache.hadoop.ipc.StandbyException", "Standby NameNode")});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(active, standby));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since the active namenode throws ConnectException!");
        }
        catch (MultiException me) {
            for (Exception ex : me.getExceptions().values()) {
                if (ex instanceof RemoteException) {
                    IOException rEx = ((RemoteException)((Object)ex)).unwrapRemoteException();
                    Assert.assertTrue((String)("Unexpected RemoteException: " + rEx.getMessage()), (boolean)(rEx instanceof StandbyException));
                    continue;
                }
                Assert.assertTrue((boolean)(ex instanceof ConnectException));
            }
        }
        ((ClientProtocol)Mockito.verify((Object)active)).getStats();
        ((ClientProtocol)Mockito.verify((Object)standby)).getStats();
    }

    @Test
    public void testHedgingWhenConnectAndEOFException() throws Exception {
        ClientProtocol active = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)active.getStats()).thenThrow(new Throwable[]{new EOFException()});
        ClientProtocol standby = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)standby.getStats()).thenThrow(new Throwable[]{new ConnectException()});
        RequestHedgingProxyProvider provider = new RequestHedgingProxyProvider(this.conf, this.nnUri, ClientProtocol.class, this.createFactory(active, standby));
        try {
            ((ClientProtocol)provider.getProxy().proxy).getStats();
            Assert.fail((String)"Should fail since both active and standby namenodes throw Exceptions!");
        }
        catch (MultiException me) {
            for (Exception ex : me.getExceptions().values()) {
                if (ex instanceof ConnectException || ex instanceof EOFException) continue;
                Assert.fail((String)("Unexpected Exception " + ex.getMessage()));
            }
        }
        ((ClientProtocol)Mockito.verify((Object)active)).getStats();
        ((ClientProtocol)Mockito.verify((Object)standby)).getStats();
    }

    private HAProxyFactory<ClientProtocol> createFactory(ClientProtocol ... protos) {
        final Iterator iterator = Lists.newArrayList((Object[])protos).iterator();
        return new HAProxyFactory<ClientProtocol>(){

            public ClientProtocol createProxy(Configuration conf, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries, AtomicBoolean fallbackToSimpleAuth) throws IOException {
                return (ClientProtocol)iterator.next();
            }

            public ClientProtocol createProxy(Configuration conf, InetSocketAddress nnAddr, Class<ClientProtocol> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
                return (ClientProtocol)iterator.next();
            }
        };
    }
}

