/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.EnumMap;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class EnumMapDeserializer
extends ContainerDeserializerBase<EnumMap<?, ?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _mapType;
    protected final Class<?> _enumClass;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public EnumMapDeserializer(JavaType mapType, KeyDeserializer keyDeserializer, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser) {
        super(mapType);
        this._mapType = mapType;
        this._enumClass = mapType.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public EnumMapDeserializer withResolved(KeyDeserializer keyDeserializer, JsonDeserializer<?> valueDeserializer, TypeDeserializer valueTypeDeser) {
        if (keyDeserializer == this._keyDeserializer && valueDeserializer == this._valueDeserializer && valueTypeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this._mapType, keyDeserializer, valueDeserializer, this._valueTypeDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this._mapType.getKeyType(), property);
        }
        JsonDeserializer<Object> vd = this._valueDeserializer;
        JavaType vt = this._mapType.getContentType();
        vd = vd == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(vd, property, vt);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property);
        }
        return this.withResolved(kd, vd, vtd);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null;
    }

    @Override
    public JavaType getContentType() {
        return this._mapType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            return (EnumMap)this._deserializeFromEmpty(jp, ctxt);
        }
        EnumMap<?, ?> result = this.constructMap();
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while (jp.nextToken() == JsonToken.FIELD_NAME) {
            Object value;
            String keyName = jp.getCurrentName();
            Enum key = (Enum)this._keyDeserializer.deserializeKey(keyName, ctxt);
            if (key == null) {
                if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    throw ctxt.weirdStringException(keyName, this._enumClass, "value not one of declared Enum instance names for " + this._mapType.getKeyType());
                }
                jp.nextToken();
                jp.skipChildren();
                continue;
            }
            JsonToken t = jp.nextToken();
            try {
                value = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(jp, ctxt) : valueDes.deserializeWithType(jp, ctxt, typeDeser));
            }
            catch (Exception e) {
                this.wrapAndThrow(e, result, keyName);
                return null;
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    protected EnumMap<?, ?> constructMap() {
        return new EnumMap(this._enumClass);
    }
}

