/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaDiscoverer;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class FpgaResourceHandlerImpl
implements ResourceHandler {
    static final Log LOG = LogFactory.getLog(FpgaResourceHandlerImpl.class);
    private final String REQUEST_FPGA_IP_ID_KEY = "REQUESTED_FPGA_IP_ID";
    private final AbstractFpgaVendorPlugin vendorPlugin;
    private final FpgaResourceAllocator allocator;
    private final CGroupsHandler cGroupsHandler;
    public static final String EXCLUDED_FPGAS_CLI_OPTION = "--excluded_fpgas";
    public static final String CONTAINER_ID_CLI_OPTION = "--container_id";
    private PrivilegedOperationExecutor privilegedOperationExecutor;

    @VisibleForTesting
    public FpgaResourceHandlerImpl(Context nmContext, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor, AbstractFpgaVendorPlugin plugin) {
        this.allocator = new FpgaResourceAllocator(nmContext);
        this.vendorPlugin = plugin;
        FpgaDiscoverer.getInstance().setResourceHanderPlugin(this.vendorPlugin);
        this.cGroupsHandler = cGroupsHandler;
        this.privilegedOperationExecutor = privilegedOperationExecutor;
    }

    @VisibleForTesting
    public FpgaResourceAllocator getFpgaAllocator() {
        return this.allocator;
    }

    public String getRequestedIPID(Container container) {
        String r = (String)container.getLaunchContext().getEnvironment().get("REQUESTED_FPGA_IP_ID");
        return r == null ? "" : r;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration configuration) throws ResourceHandlerException {
        if (!this.vendorPlugin.initPlugin(configuration)) {
            throw new ResourceHandlerException("FPGA plugin initialization failed", null);
        }
        LOG.info((Object)"FPGA Plugin bootstrap success.");
        List<FpgaResourceAllocator.FpgaDevice> fpgaDeviceList = FpgaDiscoverer.getInstance().discover();
        this.allocator.addFpga(this.vendorPlugin.getFpgaType(), fpgaDeviceList);
        this.cGroupsHandler.initializeCGroupController(CGroupsHandler.CGroupController.DEVICES);
        return null;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        String containerIdStr = container.getContainerId().toString();
        Resource requestedResource = container.getResource();
        this.cGroupsHandler.createCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
        long deviceCount = requestedResource.getResourceValue("yarn.io/fpga");
        LOG.info((Object)(containerIdStr + " requested " + deviceCount + " Intel FPGA(s)"));
        String ipFilePath = null;
        try {
            FpgaResourceAllocator.FpgaAllocation allocation = this.allocator.assignFpga(this.vendorPlugin.getFpgaType(), deviceCount, container, this.getRequestedIPID(container));
            LOG.info((Object)("FpgaAllocation:" + allocation));
            PrivilegedOperation privilegedOperation = new PrivilegedOperation(PrivilegedOperation.OperationType.FPGA, Arrays.asList(CONTAINER_ID_CLI_OPTION, containerIdStr));
            if (!allocation.getDenied().isEmpty()) {
                ArrayList denied = new ArrayList();
                allocation.getDenied().forEach(device -> denied.add(device.getMinor()));
                privilegedOperation.appendArgs(Arrays.asList(EXCLUDED_FPGAS_CLI_OPTION, StringUtils.join((CharSequence)",", denied)));
            }
            this.privilegedOperationExecutor.executePrivilegedOperation(privilegedOperation, true);
            if (deviceCount > 0L) {
                ipFilePath = this.vendorPlugin.downloadIP(this.getRequestedIPID(container), container.getWorkDir(), container.getResourceSet().getLocalizedResources());
                if (ipFilePath.isEmpty()) {
                    LOG.warn((Object)"FPGA plugin failed to download IP but continue, please check the value of environment viable: REQUESTED_FPGA_IP_ID if you want yarn to help");
                } else {
                    LOG.info((Object)("IP file path:" + ipFilePath));
                    List<FpgaResourceAllocator.FpgaDevice> allowed = allocation.getAllowed();
                    for (int i = 0; i < allowed.size(); ++i) {
                        String majorMinorNumber = allowed.get(i).getMajor() + ":" + allowed.get(i).getMinor();
                        String currentIPID = allowed.get(i).getIPID();
                        if (null != currentIPID && currentIPID.equalsIgnoreCase(this.getRequestedIPID(container))) {
                            LOG.info((Object)("IP already in device \"" + allowed.get(i).getAliasDevName() + "," + majorMinorNumber + "\", skip reprogramming"));
                            continue;
                        }
                        if (!this.vendorPlugin.configureIP(ipFilePath, majorMinorNumber)) continue;
                        this.allocator.updateFpga(containerIdStr, allowed.get(i), this.getRequestedIPID(container));
                    }
                }
            }
        }
        catch (ResourceHandlerException re) {
            this.allocator.cleanupAssignFpgas(containerIdStr);
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
            throw re;
        }
        catch (PrivilegedOperationException e) {
            this.allocator.cleanupAssignFpgas(containerIdStr);
            this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerIdStr);
            LOG.warn((Object)"Could not update cgroup for container", (Throwable)((Object)e));
            throw new ResourceHandlerException((Throwable)((Object)e));
        }
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CGroupsHandler.CGroupController.DEVICES, containerIdStr)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        this.allocator.recoverAssignedFpgas(containerId);
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.allocator.cleanupAssignFpgas(containerId.toString());
        this.cGroupsHandler.deleteCGroup(CGroupsHandler.CGroupController.DEVICES, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    public String toString() {
        return FpgaResourceHandlerImpl.class.getName() + "{vendorPlugin=" + this.vendorPlugin + ", allocator=" + this.allocator + '}';
    }
}

