/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMultiObserverNode {
    private static Configuration conf;
    private static MiniQJMHACluster qjmhaCluster;
    private static MiniDFSCluster dfsCluster;
    private static DistributedFileSystem dfs;
    private final Path testPath = new Path("/TestMultiObserverNode");

    @BeforeClass
    public static void startUpCluster() throws Exception {
        conf = new Configuration();
        qjmhaCluster = HATestUtil.setUpObserverCluster(conf, 2, 0, true);
        dfsCluster = qjmhaCluster.getDfsCluster();
        dfs = HATestUtil.configureObserverReadFs(dfsCluster, conf, ObserverReadProxyProvider.class, true);
    }

    @After
    public void cleanUp() throws IOException {
        dfs.delete(this.testPath, true);
    }

    @AfterClass
    public static void shutDownCluster() throws IOException {
        if (qjmhaCluster != null) {
            qjmhaCluster.shutdown();
        }
    }

    @Test
    public void testObserverFailover() throws Exception {
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2, 3);
        dfsCluster.transitionToStandby(2);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(3);
        dfsCluster.transitionToStandby(3);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(0);
        dfsCluster.transitionToObserver(2);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfsCluster.transitionToObserver(3);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2, 3);
    }

    @Test
    public void testMultiObserver() throws Exception {
        Path testPath2 = new Path(this.testPath, "test2");
        Path testPath3 = new Path(this.testPath, "test3");
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        this.assertSentTo(0);
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2, 3);
        dfs.mkdir(testPath2, FsPermission.getDefault());
        dfsCluster.rollEditLogAndTail(0);
        dfsCluster.shutdownNameNode(2);
        dfs.listStatus(testPath2);
        this.assertSentTo(3);
        dfsCluster.restartNameNode(2);
        dfs.listStatus(this.testPath);
        this.assertSentTo(3);
        dfsCluster.transitionToObserver(2);
        dfs.listStatus(this.testPath);
        this.assertSentTo(2, 3);
        dfs.mkdir(testPath3, FsPermission.getDefault());
        dfsCluster.rollEditLogAndTail(0);
        dfsCluster.shutdownNameNode(3);
        dfs.listStatus(testPath3);
        this.assertSentTo(2);
        dfsCluster.shutdownNameNode(2);
        dfs.listStatus(testPath3);
        this.assertSentTo(0);
        dfsCluster.restartNameNode(2);
        dfsCluster.transitionToObserver(2);
        dfsCluster.restartNameNode(3);
        dfsCluster.transitionToObserver(3);
    }

    @Test
    public void testObserverFallBehind() throws Exception {
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        this.assertSentTo(0);
        long realStateId = HATestUtil.setACStateId(dfs, 500000L);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(0);
        HATestUtil.setACStateId(dfs, realStateId);
    }

    private void assertSentTo(int ... nnIndices) throws IOException {
        Assert.assertTrue((String)"Request was not sent to any of the expected namenodes.", (boolean)HATestUtil.isSentToAnyOfNameNodes(dfs, dfsCluster, nnIndices));
    }
}

