/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.LogsPurgeable;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestNNStorageRetentionManager {
    final Configuration conf = new Configuration();

    @Before
    public void setNoExtraEditRetention() {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 0L);
    }

    @Test
    public void testPurgeEasyCase() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        tc.addLog("/foo1/current/VERSION", false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeMultipleDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo2/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testPurgeLessThanRetention() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), false);
        tc.addLog("/foo1/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testNoLogs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        this.runTest(tc);
    }

    @Test
    public void testEmptyDir() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        this.runTest(tc);
    }

    @Test
    public void testOldInProgress() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo1/current/" + NNStorage.getInProgressEditsFileName((long)101L), true);
        this.runTest(tc);
    }

    @Test
    public void testSeparateEditDirs() throws IOException {
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testRetainExtraLogs() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 50L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)300L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testRetainExtraLogsLimitedSegments() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 150L);
        this.conf.setLong("dfs.namenode.max.extra.edits.segments.retained", 2L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo1", NNStorage.NameNodeDirType.IMAGE);
        tc.addRoot("/foo2", NNStorage.NameNodeDirType.EDITS);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)100L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo1/current/" + NNStorage.getImageFileName((long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)1L, (long)100L), true);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)101L) + ".trash", true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)101L, (long)175L), true);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)176L) + ".empty", true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)176L, (long)200L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)201L, (long)225L), true);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)226L) + ".corrupt", true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)226L, (long)240L), true);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)241L, (long)275L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)276L) + ".trash", false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)276L, (long)300L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)301L) + ".empty", false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)301L, (long)350L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)351L) + ".corrupt", false);
        tc.addLog("/foo2/current/" + NNStorage.getFinalizedEditsFileName((long)351L, (long)400L), false);
        tc.addLog("/foo2/current/" + NNStorage.getInProgressEditsFileName((long)401L), false);
        this.runTest(tc);
    }

    @Test
    public void testExtraInprogressFilesAreRemovedOrMarkedStale() throws IOException {
        this.conf.setLong("dfs.namenode.num.extra.edits.retained", 150L);
        TestCaseDescription tc = new TestCaseDescription();
        tc.addRoot("/foo", NNStorage.NameNodeDirType.IMAGE_AND_EDITS);
        String PATH = "/foo/current/";
        tc.addImage("/foo/current/" + NNStorage.getImageFileName((long)200L), true);
        tc.addImage("/foo/current/" + NNStorage.getImageFileName((long)300L), false);
        tc.addImage("/foo/current/" + NNStorage.getImageFileName((long)400L), false);
        File file = (File)Mockito.spy((Object)new File("/foo/current/paxos"));
        Mockito.when((Object)file.isDirectory()).thenReturn((Object)true);
        tc.addFile(file);
        tc.addLog("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)1L, (long)75L), true);
        tc.addLog("/foo/current/" + NNStorage.getInProgressEditsFileName((long)76L), true);
        tc.addLog("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)76L, (long)120L), true);
        tc.addLog("/foo/current/" + NNStorage.getInProgressEditsFileName((long)121L) + ".stale", true);
        tc.addLog("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)121L, (long)150L), true);
        tc.addLog("/foo/current/" + NNStorage.getInProgressEditsFileName((long)151L), false, true);
        tc.addLog("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)151L, (long)320L), false);
        tc.addLog("/foo/current/" + NNStorage.getInProgressEditsFileName((long)321L), false, true);
        tc.addLog("/foo/current/" + NNStorage.getFinalizedEditsFileName((long)321L, (long)430L), false);
        tc.addLog("/foo/current/" + NNStorage.getInProgressEditsFileName((long)431L), false);
        this.runTest(tc);
    }

    private void runTest(TestCaseDescription tc) throws IOException {
        NNStorageRetentionManager.StoragePurger mockPurger = (NNStorageRetentionManager.StoragePurger)Mockito.mock(NNStorageRetentionManager.StoragePurger.class);
        ArgumentCaptor imagesPurgedCaptor = ArgumentCaptor.forClass(FSImageStorageInspector.FSImageFile.class);
        ArgumentCaptor logsPurgedCaptor = ArgumentCaptor.forClass(FileJournalManager.EditLogFile.class);
        ArgumentCaptor staleLogsCaptor = ArgumentCaptor.forClass(FileJournalManager.EditLogFile.class);
        new NNStorageRetentionManager(this.conf, tc.mockStorage(), (LogsPurgeable)tc.mockEditLog(mockPurger), mockPurger).purgeOldStorage(NNStorage.NameNodeFile.IMAGE);
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeImage((FSImageStorageInspector.FSImageFile)imagesPurgedCaptor.capture());
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).purgeLog((FileJournalManager.EditLogFile)logsPurgedCaptor.capture());
        ((NNStorageRetentionManager.StoragePurger)Mockito.verify((Object)mockPurger, (VerificationMode)Mockito.atLeast((int)0))).markStale((FileJournalManager.EditLogFile)staleLogsCaptor.capture());
        LinkedHashSet capturedPaths = Sets.newLinkedHashSet();
        for (FSImageStorageInspector.FSImageFile captured : imagesPurgedCaptor.getAllValues()) {
            capturedPaths.add(TestNNStorageRetentionManager.fileToPath(captured.getFile()));
        }
        Assert.assertEquals((String)"Image file check.", (Object)Joiner.on((String)",").join(TestNNStorageRetentionManager.filesToPaths(tc.expectedPurgedImages)), (Object)Joiner.on((String)",").join((Iterable)capturedPaths));
        capturedPaths.clear();
        for (FSImageStorageInspector.FSImageFile captured : logsPurgedCaptor.getAllValues()) {
            capturedPaths.add(TestNNStorageRetentionManager.fileToPath(captured.getFile()));
        }
        Assert.assertEquals((String)"Check old edits are removed.", (Object)Joiner.on((String)",").join(TestNNStorageRetentionManager.filesToPaths(tc.expectedPurgedLogs)), (Object)Joiner.on((String)",").join((Iterable)capturedPaths));
        capturedPaths.clear();
        for (FSImageStorageInspector.FSImageFile captured : staleLogsCaptor.getAllValues()) {
            capturedPaths.add(TestNNStorageRetentionManager.fileToPath(captured.getFile()));
        }
        Assert.assertEquals((String)"Check unnecessary but kept edits are marked stale", (Object)Joiner.on((String)",").join(TestNNStorageRetentionManager.filesToPaths(tc.expectedStaleLogs)), (Object)Joiner.on((String)",").join((Iterable)capturedPaths));
    }

    private static String fileToPath(File file) {
        return file.toURI().getPath();
    }

    private static Collection<String> filesToPaths(Collection<File> files) {
        ArrayList paths = Lists.newArrayList();
        for (File file : files) {
            paths.add(TestNNStorageRetentionManager.fileToPath(file));
        }
        return paths;
    }

    private static NNStorage mockStorageForDirs(Storage.StorageDirectory ... mockDirs) throws IOException {
        NNStorage mockStorage = (NNStorage)Mockito.mock(NNStorage.class);
        ((NNStorage)Mockito.doAnswer(invocation -> {
            FSImageStorageInspector inspector = (FSImageStorageInspector)invocation.getArguments()[0];
            for (Storage.StorageDirectory sd : mockDirs) {
                inspector.inspectDirectory(sd);
            }
            return null;
        }).when((Object)mockStorage)).inspectStorageDirs((FSImageStorageInspector)Mockito.any());
        return mockStorage;
    }

    private class TestCaseDescription {
        private final Map<File, FakeRoot> dirRoots = Maps.newLinkedHashMap();
        private final Set<File> expectedPurgedLogs = Sets.newLinkedHashSet();
        private final Set<File> expectedPurgedImages = Sets.newLinkedHashSet();
        private final Set<File> expectedStaleLogs = Sets.newLinkedHashSet();

        private TestCaseDescription() {
        }

        void addRoot(String root, NNStorage.NameNodeDirType dir) {
            this.dirRoots.put(new File(root), new FakeRoot(dir));
        }

        private void addFile(File file) {
            for (Map.Entry<File, FakeRoot> entry : this.dirRoots.entrySet()) {
                if (!TestNNStorageRetentionManager.fileToPath(file).startsWith(TestNNStorageRetentionManager.fileToPath(entry.getKey()))) continue;
                entry.getValue().files.add(file);
            }
        }

        void addLog(String path, boolean expectPurge) {
            this.addLog(path, expectPurge, false);
        }

        void addLog(String path, boolean expectPurge, boolean expectStale) {
            File file = new File(path);
            this.addFile(file);
            if (expectPurge) {
                this.expectedPurgedLogs.add(file);
            }
            if (expectStale) {
                this.expectedStaleLogs.add(file);
            }
        }

        void addImage(String path, boolean expectPurge) {
            File file = new File(path);
            this.addFile(file);
            if (expectPurge) {
                this.expectedPurgedImages.add(file);
            }
        }

        NNStorage mockStorage() throws IOException {
            ArrayList sds = Lists.newArrayList();
            for (FakeRoot root : this.dirRoots.values()) {
                sds.add(root.mockStorageDir());
            }
            return TestNNStorageRetentionManager.mockStorageForDirs(sds.toArray(new Storage.StorageDirectory[0]));
        }

        private File findLastInProgressEdit(FakeRoot root) {
            Pattern p = Pattern.compile(NNStorage.NameNodeFile.EDITS_INPROGRESS.getName() + "_(\\d+)");
            ToLongFunction<File> fileNameToTxId = f -> {
                Matcher m = p.matcher(f.getName());
                return m.matches() ? Long.parseLong(m.group(1)) : -12345L;
            };
            return root.files.stream().sorted(Comparator.comparingLong(fileNameToTxId).reversed()).findFirst().orElse(null);
        }

        public FSEditLog mockEditLog(NNStorageRetentionManager.StoragePurger purger) throws IOException {
            ArrayList jms = Lists.newArrayList();
            JournalSet journalSet = new JournalSet(0);
            for (FakeRoot root : this.dirRoots.values()) {
                if (!root.type.isOfType((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS)) continue;
                FileJournalManager fjm = new FileJournalManager(TestNNStorageRetentionManager.this.conf, root.mockStorageDir(), null);
                fjm.currentInProgress = this.findLastInProgressEdit(root);
                fjm.purger = purger;
                jms.add(fjm);
                journalSet.add((JournalManager)fjm, false);
            }
            FSEditLog mockLog = (FSEditLog)Mockito.mock(FSEditLog.class);
            ((FSEditLog)Mockito.doAnswer(invocation -> {
                Object[] args = invocation.getArguments();
                assert (args.length == 1);
                long txId = (Long)args[0];
                for (JournalManager jm : jms) {
                    jm.purgeLogsOlderThan(txId);
                }
                return null;
            }).when((Object)mockLog)).purgeLogsOlderThan(Mockito.anyLong());
            ((FSEditLog)Mockito.doAnswer(invocation -> {
                Object[] args = invocation.getArguments();
                journalSet.selectInputStreams((Collection)args[0], ((Long)args[1]).longValue(), ((Boolean)args[2]).booleanValue(), ((Boolean)args[3]).booleanValue());
                return null;
            }).when((Object)mockLog)).selectInputStreams(Mockito.anyCollection(), Mockito.anyLong(), Mockito.anyBoolean(), Mockito.anyBoolean());
            return mockLog;
        }

        private class FakeRoot {
            final NNStorage.NameNodeDirType type;
            final List<File> files;

            FakeRoot(NNStorage.NameNodeDirType type) {
                this.type = type;
                this.files = Lists.newArrayList();
            }

            Storage.StorageDirectory mockStorageDir() {
                return FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)this.type, false, TestNNStorageRetentionManager.filesToPaths(this.files).toArray(new String[0]));
            }
        }
    }
}

