/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hdfs.server.namenode.EditsDoubleBuffer;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestEditsDoubleBuffer {
    @Test
    public void testDoubleBuffer() throws IOException {
        EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
        Assert.assertTrue((boolean)buf.isFlushed());
        byte[] data = new byte[100];
        buf.writeRaw(data, 0, data.length);
        Assert.assertEquals((String)"Should count new data correctly", (long)data.length, (long)buf.countBufferedBytes());
        Assert.assertTrue((String)"Writing to current buffer should not affect flush state", (boolean)buf.isFlushed());
        buf.setReadyToFlush();
        Assert.assertEquals((String)"Swapping buffers should still count buffered bytes", (long)data.length, (long)buf.countBufferedBytes());
        Assert.assertFalse((boolean)buf.isFlushed());
        DataOutputBuffer outBuf = new DataOutputBuffer();
        buf.flushTo((OutputStream)outBuf);
        Assert.assertEquals((long)data.length, (long)outBuf.getLength());
        Assert.assertTrue((boolean)buf.isFlushed());
        Assert.assertEquals((long)0L, (long)buf.countBufferedBytes());
        buf.writeRaw(data, 0, data.length);
        Assert.assertEquals((String)"Should count new data correctly", (long)data.length, (long)buf.countBufferedBytes());
        buf.setReadyToFlush();
        buf.flushTo((OutputStream)outBuf);
        Assert.assertEquals((long)(data.length * 2), (long)outBuf.getLength());
        Assert.assertEquals((long)0L, (long)buf.countBufferedBytes());
        outBuf.close();
    }

    @Test
    public void shouldFailToCloseWhenUnflushed() throws IOException {
        block2: {
            EditsDoubleBuffer buf = new EditsDoubleBuffer(1024);
            buf.writeRaw(new byte[1], 0, 1);
            try {
                buf.close();
                Assert.fail((String)"Did not fail to close with unflushed data");
            }
            catch (IOException ioe) {
                if (ioe.toString().contains("still to be flushed")) break block2;
                throw ioe;
            }
        }
    }

    @Test
    public void testDumpEdits() throws IOException {
        int defaultBufferSize = 256;
        int fakeLogVersion = NameNodeLayoutVersion.Feature.ROLLING_UPGRADE.getInfo().getLayoutVersion();
        EditsDoubleBuffer buffer = new EditsDoubleBuffer(256);
        FSEditLogOp.OpInstanceCache cache = new FSEditLogOp.OpInstanceCache();
        String src = "/testdumpedits";
        short replication = 1;
        FSEditLogOp.SetReplicationOp op = FSEditLogOp.SetReplicationOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setPath(src).setReplication(replication);
        op.setTransactionId(1L);
        buffer.writeOp((FSEditLogOp)op, fakeLogVersion);
        src = "/testdumpedits2";
        FSEditLogOp.DeleteOp op2 = FSEditLogOp.DeleteOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setPath(src).setTimestamp(0L);
        op2.setTransactionId(2L);
        buffer.writeOp((FSEditLogOp)op2, fakeLogVersion);
        FSEditLogOp.AllocateBlockIdOp op3 = FSEditLogOp.AllocateBlockIdOp.getInstance((FSEditLogOp.OpInstanceCache)cache.get()).setBlockId(0L);
        op3.setTransactionId(3L);
        buffer.writeOp((FSEditLogOp)op3, fakeLogVersion);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Log)EditsDoubleBuffer.LOG);
        try {
            buffer.close();
            Assert.fail();
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"bytes still to be flushed and cannot be closed.", (Throwable)ioe);
            EditsDoubleBuffer.LOG.info((Object)"Exception expected: ", (Throwable)ioe);
        }
        logs.stopCapturing();
        Assert.assertTrue((String)("expected " + op.toString() + " in the log"), (boolean)logs.getOutput().contains(op.toString()));
        Assert.assertTrue((String)("expected " + op2.toString() + " in the log"), (boolean)logs.getOutput().contains(op2.toString()));
        Assert.assertTrue((String)("expected " + op3.toString() + " in the log"), (boolean)logs.getOutput().contains(op3.toString()));
    }
}

