/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.util;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class BytesUtil {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public static long toLong(byte[] bytes, int offset) {
        return Longs.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3], (byte)bytes[offset + 4], (byte)bytes[offset + 5], (byte)bytes[offset + 6], (byte)bytes[offset + 7]);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Ints.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3]);
    }

    public static float toFloat(byte[] bytes) {
        return BytesUtil.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(BytesUtil.toInt(bytes, offset));
    }

    public static double toDouble(byte[] bytes) {
        return BytesUtil.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(BytesUtil.toLong(bytes, offset));
    }

    public static String toStringBinary(byte[] b) {
        if (b == null) {
            return "null";
        }
        return BytesUtil.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (off >= b.length) {
            return result.toString();
        }
        if (off + len > b.length) {
            len = b.length - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b[i] & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
                result.append((char)ch);
                continue;
            }
            result.append("\\x");
            result.append(HEX_CHARS[ch >> 4 & 0xF]);
            result.append(HEX_CHARS[ch & 0xF]);
        }
        return result.toString();
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static byte[] toBytes(float f) {
        return Ints.toByteArray((int)Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(double d) {
        return Longs.toByteArray((long)Double.doubleToRawLongBits(d));
    }
}

