/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMAppAttemptMetrics {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptMetrics.class);
    private ApplicationAttemptId attemptId = null;
    private Resource resourcePreempted = Resource.newInstance((int)0, (int)0);
    private volatile Resource applicationHeadroom = Resource.newInstance((int)0, (int)0);
    private AtomicInteger numNonAMContainersPreempted = new AtomicInteger(0);
    private AtomicBoolean isPreempted = new AtomicBoolean(false);
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private Map<String, AtomicLong> resourceUsageMap = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> preemptedResourceMap = new ConcurrentHashMap<String, AtomicLong>();
    private RMContext rmContext;
    private int[][] localityStatistics = new int[NodeType.values().length][NodeType.values().length];
    private volatile int totalAllocatedContainers;

    public RMAppAttemptMetrics(ApplicationAttemptId attemptId, RMContext rmContext) {
        this.attemptId = attemptId;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.rmContext = rmContext;
    }

    public void updatePreemptionInfo(Resource resource, RMContainer container) {
        try {
            this.writeLock.lock();
            this.resourcePreempted = Resources.addTo((Resource)this.resourcePreempted, (Resource)resource);
        }
        finally {
            this.writeLock.unlock();
        }
        if (!container.isAMContainer()) {
            LOG.info((Object)String.format("Non-AM container preempted, current appAttemptId=%s, containerId=%s, resource=%s", this.attemptId, container.getContainerId(), resource));
            this.numNonAMContainersPreempted.incrementAndGet();
        } else {
            LOG.info((Object)String.format("AM container preempted, current appAttemptId=%s, containerId=%s, resource=%s", this.attemptId, container.getContainerId(), resource));
            this.isPreempted.set(true);
        }
    }

    public Resource getResourcePreempted() {
        try {
            this.readLock.lock();
            Resource resource = Resource.newInstance((Resource)this.resourcePreempted);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getPreemptedMemory() {
        return this.preemptedResourceMap.get(ResourceInformation.MEMORY_MB.getName()).get();
    }

    public long getPreemptedVcore() {
        return this.preemptedResourceMap.get(ResourceInformation.VCORES.getName()).get();
    }

    public Map<String, Long> getPreemptedResourceSecondsMap() {
        return this.convertAtomicLongMaptoLongMap(this.preemptedResourceMap);
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainersPreempted.get();
    }

    public void setIsPreempted() {
        this.isPreempted.set(true);
    }

    public boolean getIsPreempted() {
        return this.isPreempted.get();
    }

    public AggregateAppResourceUsage getAggregateAppResourceUsage() {
        ApplicationResourceUsageReport appResUsageReport;
        RMAppAttempt currentAttempt;
        Map<String, Long> resourcesUsed = this.convertAtomicLongMaptoLongMap(this.resourceUsageMap);
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId());
        if (rmApp != null && (currentAttempt = rmApp.getCurrentAppAttempt()) != null && currentAttempt.getAppAttemptId().equals((Object)this.attemptId) && (appResUsageReport = this.rmContext.getScheduler().getAppResourceUsageReport(this.attemptId)) != null) {
            Map tmp = appResUsageReport.getResourceSecondsMap();
            for (Map.Entry entry : tmp.entrySet()) {
                Long value = resourcesUsed.get(entry.getKey());
                value = value != null ? Long.valueOf(value + (Long)entry.getValue()) : (Long)entry.getValue();
                resourcesUsed.put((String)entry.getKey(), value);
            }
        }
        return new AggregateAppResourceUsage(resourcesUsed);
    }

    public void updateAggregateAppResourceUsage(Resource allocated, long deltaUsedMillis) {
        this.updateUsageMap(allocated, deltaUsedMillis, this.resourceUsageMap);
    }

    public void updateAggregatePreemptedAppResourceUsage(Resource allocated, long deltaUsedMillis) {
        this.updateUsageMap(allocated, deltaUsedMillis, this.preemptedResourceMap);
    }

    public void updateAggregateAppResourceUsage(Map<String, Long> resourceSecondsMap) {
        this.updateUsageMap(resourceSecondsMap, this.resourceUsageMap);
    }

    public void updateAggregatePreemptedAppResourceUsage(Map<String, Long> preemptedResourceSecondsMap) {
        this.updateUsageMap(preemptedResourceSecondsMap, this.preemptedResourceMap);
    }

    private void updateUsageMap(Resource allocated, long deltaUsedMillis, Map<String, AtomicLong> targetMap) {
        for (ResourceInformation entry : allocated.getResources()) {
            AtomicLong resourceUsed;
            if (!targetMap.containsKey(entry.getName())) {
                resourceUsed = new AtomicLong(0L);
                targetMap.put(entry.getName(), resourceUsed);
            }
            resourceUsed = targetMap.get(entry.getName());
            resourceUsed.addAndGet(entry.getValue() * deltaUsedMillis / 1000L);
        }
    }

    private void updateUsageMap(Map<String, Long> sourceMap, Map<String, AtomicLong> targetMap) {
        for (Map.Entry<String, Long> entry : sourceMap.entrySet()) {
            AtomicLong resourceUsed;
            if (!targetMap.containsKey(entry.getKey())) {
                resourceUsed = new AtomicLong(0L);
                targetMap.put(entry.getKey(), resourceUsed);
            }
            resourceUsed = targetMap.get(entry.getKey());
            resourceUsed.set(entry.getValue());
        }
    }

    private Map<String, Long> convertAtomicLongMaptoLongMap(Map<String, AtomicLong> source) {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> entry : source.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().get());
        }
        return ret;
    }

    public void incNumAllocatedContainers(NodeType containerType, NodeType requestType) {
        int[] nArray = this.localityStatistics[containerType.getIndex()];
        int n = requestType.getIndex();
        nArray[n] = nArray[n] + 1;
        ++this.totalAllocatedContainers;
    }

    public int[][] getLocalityStatistics() {
        return this.localityStatistics;
    }

    public int getTotalAllocatedContainers() {
        return this.totalAllocatedContainers;
    }

    public Resource getApplicationAttemptHeadroom() {
        return Resource.newInstance((Resource)this.applicationHeadroom);
    }

    public void setApplicationAttemptHeadRoom(Resource headRoom) {
        this.applicationHeadroom = headRoom;
    }
}

