/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAMRMTokenEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRMDTMasterKeyEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreStoreReservationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreLimitException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    @VisibleForTesting
    public static final String RM_APP_ROOT = "RMAppRoot";
    protected static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    protected static final String RM_DELEGATION_TOKENS_ROOT_ZNODE_NAME = "RMDelegationTokensRoot";
    protected static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    protected static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    protected static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected static final String AMRMTOKEN_SECRET_MANAGER_ROOT = "AMRMTokenSecretManagerRoot";
    protected static final String RESERVATION_SYSTEM_ROOT = "ReservationSystemRoot";
    protected static final String VERSION_NODE = "RMVersionNode";
    protected static final String EPOCH_NODE = "EpochNode";
    protected long baseEpoch;
    protected ResourceManager resourceManager;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private static final StateMachineFactory<RMStateStore, RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachineFactory = new StateMachineFactory((Enum)RMStateStoreState.ACTIVE).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.STORE_APP, (MultipleArcTransition)new StoreAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.UPDATE_APP, (MultipleArcTransition)new UpdateAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.REMOVE_APP, (MultipleArcTransition)new RemoveAppTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.STORE_APP_ATTEMPT, (MultipleArcTransition)new StoreAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.UPDATE_APP_ATTEMPT, (MultipleArcTransition)new UpdateAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.REMOVE_APP_ATTEMPT, (MultipleArcTransition)new RemoveAppAttemptTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.STORE_MASTERKEY, (MultipleArcTransition)new StoreRMDTMasterKeyTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.REMOVE_MASTERKEY, (MultipleArcTransition)new RemoveRMDTMasterKeyTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.STORE_DELEGATION_TOKEN, (MultipleArcTransition)new StoreRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.REMOVE_DELEGATION_TOKEN, (MultipleArcTransition)new RemoveRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.UPDATE_DELEGATION_TOKEN, (MultipleArcTransition)new UpdateRMDTTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.UPDATE_AMRM_TOKEN, (MultipleArcTransition)new StoreOrUpdateAMRMTokenTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.STORE_RESERVATION, (MultipleArcTransition)new StoreReservationAllocationTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, EnumSet.of(RMStateStoreState.ACTIVE, RMStateStoreState.FENCED), (Enum)RMStateStoreEventType.REMOVE_RESERVATION, (MultipleArcTransition)new RemoveReservationAllocationTransition()).addTransition((Enum)RMStateStoreState.ACTIVE, (Enum)RMStateStoreState.FENCED, (Enum)RMStateStoreEventType.FENCED).addTransition((Enum)RMStateStoreState.FENCED, (Enum)RMStateStoreState.FENCED, EnumSet.of(RMStateStoreEventType.STORE_APP, new RMStateStoreEventType[]{RMStateStoreEventType.UPDATE_APP, RMStateStoreEventType.REMOVE_APP, RMStateStoreEventType.STORE_APP_ATTEMPT, RMStateStoreEventType.UPDATE_APP_ATTEMPT, RMStateStoreEventType.FENCED, RMStateStoreEventType.STORE_MASTERKEY, RMStateStoreEventType.REMOVE_MASTERKEY, RMStateStoreEventType.STORE_DELEGATION_TOKEN, RMStateStoreEventType.REMOVE_DELEGATION_TOKEN, RMStateStoreEventType.UPDATE_DELEGATION_TOKEN, RMStateStoreEventType.UPDATE_AMRM_TOKEN, RMStateStoreEventType.STORE_RESERVATION, RMStateStoreEventType.REMOVE_RESERVATION}));
    private final StateMachine<RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachine;
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    @VisibleForTesting
    protected EventHandler rmStateStoreEventHandler;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    private static RMStateStoreState finalState(boolean isFenced) {
        return isFenced ? RMStateStoreState.FENCED : RMStateStoreState.ACTIVE;
    }

    public RMStateStore() {
        super(RMStateStore.class.getName());
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher("RM StateStore dispatcher");
        this.dispatcher.init(conf);
        this.rmStateStoreEventHandler = new ForwardingEventHandler();
        this.dispatcher.register(RMStateStoreEventType.class, this.rmStateStoreEventHandler);
        this.dispatcher.setDrainEventsOnStop();
        this.baseEpoch = conf.getLong("yarn.resourcemanager.epoch", 0L);
        this.initInternal(conf);
    }

    protected void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    protected void serviceStop() throws Exception {
        this.dispatcher.stop();
        this.closeInternal();
    }

    protected abstract void closeInternal() throws Exception;

    public void checkVersion() throws Exception {
        Version loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded RM state version info " + loadedVersion));
        if (loadedVersion != null && loadedVersion.equals(this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = this.getCurrentVersion();
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting RM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing RM state version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    protected abstract Version loadVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract Version getCurrentVersion();

    public abstract long getAndIncrementEpoch() throws Exception;

    public abstract RMState loadState() throws Exception;

    public void storeNewApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), context, app.getUser(), app.getCallerContext());
        appState.setApplicationTimeouts(app.getApplicationTimeouts());
        this.getRMStateStoreEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    public void updateApplicationState(ApplicationStateData appState) {
        this.getRMStateStoreEventHandler().handle((Event)new RMStateUpdateAppEvent(appState));
    }

    public void updateApplicationStateSynchronously(ApplicationStateData appState, boolean notifyApp, SettableFuture<Object> resultFuture) {
        this.handleStoreEvent(new RMStateUpdateAppEvent(appState, notifyApp, resultFuture));
    }

    public void updateFencedState() {
        this.handleStoreEvent(new RMStateStoreEvent(RMStateStoreEventType.FENCED));
    }

    protected abstract void storeApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    protected abstract void updateApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    public void storeNewApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        RMAppAttemptMetrics attempMetrics = appAttempt.getRMAppAttemptMetrics();
        AggregateAppResourceUsage resUsage = attempMetrics.getAggregateAppResourceUsage();
        ApplicationAttemptStateData attemptState = ApplicationAttemptStateData.newInstance(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime(), resUsage.getResourceUsageSecondsMap(), attempMetrics.getPreemptedResourceSecondsMap());
        this.getRMStateStoreEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    public void updateApplicationAttemptState(ApplicationAttemptStateData attemptState) {
        this.getRMStateStoreEventHandler().handle((Event)new RMStateUpdateAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    protected abstract void updateApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    public void storeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, renewDate, RMStateStoreEventType.STORE_DELEGATION_TOKEN));
    }

    protected abstract void storeRMDelegationTokenState(RMDelegationTokenIdentifier var1, Long var2) throws Exception;

    public void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, null, RMStateStoreEventType.REMOVE_DELEGATION_TOKEN));
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public void updateRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) {
        this.handleStoreEvent(new RMStateStoreRMDTEvent(rmDTIdentifier, renewDate, RMStateStoreEventType.UPDATE_DELEGATION_TOKEN));
    }

    protected abstract void updateRMDelegationTokenState(RMDelegationTokenIdentifier var1, Long var2) throws Exception;

    public void storeRMDTMasterKey(DelegationKey delegationKey) {
        this.handleStoreEvent(new RMStateStoreRMDTMasterKeyEvent(delegationKey, RMStateStoreEventType.STORE_MASTERKEY));
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public void removeRMDTMasterKey(DelegationKey delegationKey) {
        this.handleStoreEvent(new RMStateStoreRMDTMasterKeyEvent(delegationKey, RMStateStoreEventType.REMOVE_MASTERKEY));
    }

    public void storeNewReservation(YarnProtos.ReservationAllocationStateProto reservationAllocation, String planName, String reservationIdName) {
        this.handleStoreEvent(new RMStateStoreStoreReservationEvent(reservationAllocation, RMStateStoreEventType.STORE_RESERVATION, planName, reservationIdName));
    }

    public void removeReservation(String planName, String reservationIdName) {
        this.handleStoreEvent(new RMStateStoreStoreReservationEvent(null, RMStateStoreEventType.REMOVE_RESERVATION, planName, reservationIdName));
    }

    protected abstract void storeReservationState(YarnProtos.ReservationAllocationStateProto var1, String var2, String var3) throws Exception;

    protected abstract void removeReservationState(String var1, String var2) throws Exception;

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    protected abstract void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState var1, boolean var2) throws Exception;

    public void storeOrUpdateAMRMTokenSecretManager(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) {
        this.handleStoreEvent(new RMStateStoreAMRMTokenEvent(amrmTokenSecretManagerState, isUpdate, RMStateStoreEventType.UPDATE_AMRM_TOKEN));
    }

    public void removeApplication(RMApp app) {
        ApplicationStateData appState = ApplicationStateData.newInstance(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser(), app.getCallerContext());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            appState.attempts.put(appAttempt.getAppAttemptId(), null);
        }
        this.getRMStateStoreEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationStateInternal(ApplicationStateData var1) throws Exception;

    public synchronized void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        this.getRMStateStoreEventHandler().handle((Event)new RMStateStoreRemoveAppAttemptEvent(applicationAttemptId));
    }

    protected abstract void removeApplicationAttemptInternal(ApplicationAttemptId var1) throws Exception;

    public Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = new Credentials();
        SecretKey clientTokenMasterKey = appAttempt.getClientTokenMasterKey();
        if (clientTokenMasterKey != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    @VisibleForTesting
    protected boolean isFencedState() {
        return RMStateStoreState.FENCED == this.getRMStateStoreState();
    }

    protected void handleStoreEvent(RMStateStoreEvent event) {
        this.writeLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing event of type " + event.getType()));
            }
            RMStateStoreState oldState = this.getRMStateStoreState();
            this.stateMachine.doTransition(event.getType(), (Object)event);
            if (oldState != this.getRMStateStoreState()) {
                LOG.info((Object)("RMStateStore state change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getRMStateStoreState())));
            }
        }
        catch (InvalidStateTransitionException e) {
            LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void notifyStoreOperationFailed(Exception failureCause) {
        if (this.isFencedState()) {
            return;
        }
        if (this.notifyStoreOperationFailedInternal(failureCause)) {
            this.updateFencedState();
        }
    }

    private boolean notifyStoreOperationFailedInternal(Exception failureCause) {
        boolean isFenced = false;
        LOG.error((Object)"State store operation failed ", (Throwable)failureCause);
        if (HAUtil.isHAEnabled((Configuration)this.getConfig())) {
            this.rmDispatcher.getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.STATE_STORE_FENCED, failureCause));
            isFenced = true;
        } else {
            this.rmDispatcher.getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.STATE_STORE_OP_FAILED, failureCause));
        }
        return isFenced;
    }

    private void notifyApplication(RMAppEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    private void notifyApplicationAttempt(RMAppAttemptEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    public abstract void deleteStore() throws Exception;

    public abstract void removeApplication(ApplicationId var1) throws Exception;

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    public RMStateStoreState getRMStateStoreState() {
        this.readLock.lock();
        try {
            RMStateStoreState rMStateStoreState = (RMStateStoreState)this.stateMachine.getCurrentState();
            return rMStateStoreState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected EventHandler getRMStateStoreEventHandler() {
        return this.dispatcher.getEventHandler();
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationStateData> appState = new TreeMap<ApplicationId, ApplicationStateData>();
        RMDTSecretManagerState rmSecretManagerState = new RMDTSecretManagerState();
        AMRMTokenSecretManagerState amrmTokenSecretManagerState = null;
        private Map<String, Map<ReservationId, YarnProtos.ReservationAllocationStateProto>> reservationState = new TreeMap<String, Map<ReservationId, YarnProtos.ReservationAllocationStateProto>>();

        public Map<ApplicationId, ApplicationStateData> getApplicationState() {
            return this.appState;
        }

        public RMDTSecretManagerState getRMDTSecretManagerState() {
            return this.rmSecretManagerState;
        }

        public AMRMTokenSecretManagerState getAMRMTokenSecretManagerState() {
            return this.amrmTokenSecretManagerState;
        }

        public Map<String, Map<ReservationId, YarnProtos.ReservationAllocationStateProto>> getReservationState() {
            return this.reservationState;
        }
    }

    public static class RMDTSecretManagerState {
        Map<RMDelegationTokenIdentifier, Long> delegationTokenState = new HashMap<RMDelegationTokenIdentifier, Long>();
        Set<DelegationKey> masterKeyState = new HashSet<DelegationKey>();
        int dtSequenceNumber = 0;

        public Map<RMDelegationTokenIdentifier, Long> getTokenState() {
            return this.delegationTokenState;
        }

        public Set<DelegationKey> getMasterKeyState() {
            return this.masterKeyState;
        }

        public int getDTSequenceNumber() {
            return this.dtSequenceNumber;
        }
    }

    private static class RemoveAppAttemptTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private RemoveAppAttemptTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRemoveAppAttemptEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            ApplicationAttemptId attemptId = ((RMStateStoreRemoveAppAttemptEvent)event).getApplicationAttemptId();
            ApplicationId appId = attemptId.getApplicationId();
            LOG.info((Object)("Removing attempt " + attemptId + " from app: " + appId));
            try {
                store.removeApplicationAttemptInternal(attemptId);
            }
            catch (Exception e) {
                LOG.error((Object)("Error removing attempt: " + attemptId), (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class RemoveReservationAllocationTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private RemoveReservationAllocationTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreStoreReservationEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreStoreReservationEvent reservationEvent = (RMStateStoreStoreReservationEvent)event;
            try {
                LOG.info((Object)("Removing reservation allocation." + reservationEvent.getReservationIdName()));
                store.removeReservationState(reservationEvent.getPlanName(), reservationEvent.getReservationIdName());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing reservation allocation.", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class StoreReservationAllocationTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreReservationAllocationTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreStoreReservationEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreStoreReservationEvent reservationEvent = (RMStateStoreStoreReservationEvent)event;
            try {
                LOG.info((Object)("Storing reservation allocation." + reservationEvent.getReservationIdName()));
                store.storeReservationState(reservationEvent.getReservationAllocation(), reservationEvent.getPlanName(), reservationEvent.getReservationIdName());
            }
            catch (Exception e) {
                LOG.error((Object)"Error while storing reservation allocation.", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class StoreOrUpdateAMRMTokenTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreOrUpdateAMRMTokenTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAMRMTokenEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            RMStateStoreAMRMTokenEvent amrmEvent = (RMStateStoreAMRMTokenEvent)event;
            boolean isFenced = false;
            try {
                LOG.info((Object)"Updating AMRMToken");
                store.storeOrUpdateAMRMTokenSecretManagerState(amrmEvent.getAmrmTokenSecretManagerState(), amrmEvent.isUpdate());
            }
            catch (Exception e) {
                LOG.error((Object)"Error storing info for AMRMTokenSecretManager", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class RemoveRMDTMasterKeyTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private RemoveRMDTMasterKeyTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTMasterKeyEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreRMDTMasterKeyEvent dtEvent = (RMStateStoreRMDTMasterKeyEvent)event;
            try {
                LOG.info((Object)"Removing RMDTMasterKey.");
                store.removeRMDTMasterKeyState(dtEvent.getDelegationKey());
            }
            catch (Exception e) {
                LOG.error((Object)"Error While Removing RMDTMasterKey.", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class StoreRMDTMasterKeyTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreRMDTMasterKeyTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTMasterKeyEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreRMDTMasterKeyEvent dtEvent = (RMStateStoreRMDTMasterKeyEvent)event;
            try {
                LOG.info((Object)"Storing RMDTMasterKey.");
                store.storeRMDTMasterKeyState(dtEvent.getDelegationKey());
            }
            catch (Exception e) {
                LOG.error((Object)"Error While Storing RMDTMasterKey.", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class UpdateRMDTTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private UpdateRMDTTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info((Object)"Updating RMDelegationToken and SequenceNumber");
                store.updateRMDelegationTokenState(dtEvent.getRmDTIdentifier(), dtEvent.getRenewDate());
            }
            catch (Exception e) {
                LOG.error((Object)"Error While Updating RMDelegationToken and SequenceNumber ", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class RemoveRMDTTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private RemoveRMDTTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info((Object)"Removing RMDelegationToken and SequenceNumber");
                store.removeRMDelegationTokenState(dtEvent.getRmDTIdentifier());
            }
            catch (Exception e) {
                LOG.error((Object)"Error While Removing RMDelegationToken and SequenceNumber ", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class StoreRMDTTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreRMDTTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRMDTEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            RMStateStoreRMDTEvent dtEvent = (RMStateStoreRMDTEvent)event;
            try {
                LOG.info((Object)"Storing RMDelegationToken and SequenceNumber");
                store.storeRMDelegationTokenState(dtEvent.getRmDTIdentifier(), dtEvent.getRenewDate());
            }
            catch (Exception e) {
                LOG.error((Object)"Error While Storing RMDelegationToken and SequenceNumber ", (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class UpdateAppAttemptTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private UpdateAppAttemptTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateUpdateAppAttemptEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            ApplicationAttemptStateData attemptState = ((RMStateUpdateAppAttemptEvent)event).getAppAttemptState();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating info for attempt: " + attemptState.getAttemptId()));
                }
                store.updateApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptState);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error updating appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class StoreAppAttemptTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreAppAttemptTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppAttemptEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            ApplicationAttemptStateData attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                }
                store.storeApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptState);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error storing appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class RemoveAppTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private RemoveAppTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRemoveAppEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            ApplicationStateData appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
            LOG.info((Object)("Removing info for app: " + appId));
            try {
                store.removeApplicationStateInternal(appState);
            }
            catch (Exception e) {
                LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    private static class UpdateAppTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private UpdateAppTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            boolean isFenced;
            block6: {
                if (!(event instanceof RMStateUpdateAppEvent)) {
                    LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                    return RMStateStoreState.ACTIVE;
                }
                isFenced = false;
                ApplicationStateData appState = ((RMStateUpdateAppEvent)event).getAppState();
                SettableFuture<Object> result = ((RMStateUpdateAppEvent)event).getResult();
                ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
                LOG.info((Object)("Updating info for app: " + appId));
                try {
                    if (this.isAppStateFinal(appState)) {
                        this.pruneAppState(appState);
                    }
                    store.updateApplicationStateInternal(appId, appState);
                    if (((RMStateUpdateAppEvent)event).isNotifyApplication()) {
                        store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_UPDATE_SAVED));
                    }
                    if (result != null) {
                        result.set(null);
                    }
                }
                catch (Exception e) {
                    String msg = "Error updating app: " + appId;
                    LOG.error((Object)msg, (Throwable)e);
                    isFenced = store.notifyStoreOperationFailedInternal(e);
                    if (result == null) break block6;
                    result.setException((Throwable)new YarnException(msg, (Throwable)e));
                }
            }
            return RMStateStore.finalState(isFenced);
        }

        private boolean isAppStateFinal(ApplicationStateData appState) {
            RMAppState state = appState.getState();
            return state == RMAppState.FINISHED || state == RMAppState.FAILED || state == RMAppState.KILLED;
        }

        private void pruneAppState(ApplicationStateData appState) {
            ApplicationSubmissionContext srcCtx = appState.getApplicationSubmissionContext();
            ApplicationSubmissionContextPBImpl context = new ApplicationSubmissionContextPBImpl();
            context.setApplicationId(srcCtx.getApplicationId());
            context.setResource(srcCtx.getResource());
            context.setQueue(srcCtx.getQueue());
            context.setAMContainerResourceRequests(srcCtx.getAMContainerResourceRequests());
            context.setApplicationName(srcCtx.getApplicationName());
            context.setPriority(srcCtx.getPriority());
            context.setApplicationTags(srcCtx.getApplicationTags());
            context.setApplicationType(srcCtx.getApplicationType());
            context.setUnmanagedAM(srcCtx.getUnmanagedAM());
            context.setNodeLabelExpression(srcCtx.getNodeLabelExpression());
            ContainerLaunchContextPBImpl amContainerSpec = new ContainerLaunchContextPBImpl();
            amContainerSpec.setApplicationACLs(srcCtx.getAMContainerSpec().getApplicationACLs());
            context.setAMContainerSpec((ContainerLaunchContext)amContainerSpec);
            appState.setApplicationSubmissionContext((ApplicationSubmissionContext)context);
        }
    }

    private static class StoreAppTransition
    implements MultipleArcTransition<RMStateStore, RMStateStoreEvent, RMStateStoreState> {
        private StoreAppTransition() {
        }

        public RMStateStoreState transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return RMStateStoreState.ACTIVE;
            }
            boolean isFenced = false;
            ApplicationStateData appState = ((RMStateStoreAppEvent)event).getAppState();
            ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
            LOG.info((Object)("Storing info for app: " + appId));
            try {
                store.storeApplicationStateInternal(appId, appState);
                store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error storing app: " + appId), (Throwable)e);
                if (e instanceof StoreLimitException) {
                    store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_SAVE_FAILED, e.getMessage()));
                }
                isFenced = store.notifyStoreOperationFailedInternal(e);
            }
            return RMStateStore.finalState(isFenced);
        }
    }

    public static enum RMStateStoreState {
        ACTIVE,
        FENCED;

    }
}

