/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.concurrent.HadoopScheduledThreadPoolExecutor;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.api.impl.pb.NMProtoUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.recovery.DeletionTaskRecoveryInfo;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMNullStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.RecoveryIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(DeletionService.class);
    private int debugDelay;
    private final ContainerExecutor containerExecutor;
    private final NMStateStoreService stateStore;
    private ScheduledThreadPoolExecutor sched;
    private AtomicInteger nextTaskId = new AtomicInteger(0);

    public DeletionService(ContainerExecutor exec) {
        this(exec, new NMNullStateStoreService());
    }

    public DeletionService(ContainerExecutor containerExecutor, NMStateStoreService stateStore) {
        super(DeletionService.class.getName());
        this.containerExecutor = containerExecutor;
        this.debugDelay = 0;
        this.stateStore = stateStore;
    }

    public int getDebugDelay() {
        return this.debugDelay;
    }

    public ContainerExecutor getContainerExecutor() {
        return this.containerExecutor;
    }

    public NMStateStoreService getStateStore() {
        return this.stateStore;
    }

    public void delete(DeletionTask deletionTask) {
        if (this.debugDelay != -1) {
            if (LOG.isDebugEnabled()) {
                String msg = String.format("Scheduling DeletionTask (delay %d) : %s", this.debugDelay, deletionTask.toString());
                LOG.debug(msg);
            }
            this.recordDeletionTaskInStateStore(deletionTask);
            this.sched.schedule(deletionTask, (long)this.debugDelay, TimeUnit.SECONDS);
        }
    }

    private void recover(NMStateStoreService.RecoveredDeletionServiceState state) throws IOException {
        HashMap<Integer, DeletionTaskRecoveryInfo> idToInfoMap = new HashMap<Integer, DeletionTaskRecoveryInfo>();
        HashSet<Integer> successorTasks = new HashSet<Integer>();
        try (RecoveryIterator<YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto> it = state.getIterator();){
            while (it.hasNext()) {
                YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto = it.next();
                DeletionTaskRecoveryInfo info = NMProtoUtils.convertProtoToDeletionTaskRecoveryInfo(proto, this);
                idToInfoMap.put(info.getTask().getTaskId(), info);
                this.nextTaskId.set(Math.max(this.nextTaskId.get(), info.getTask().getTaskId()));
                successorTasks.addAll(info.getSuccessorTaskIds());
            }
        }
        long now = System.currentTimeMillis();
        for (DeletionTaskRecoveryInfo info : idToInfoMap.values()) {
            for (Integer successorId : info.getSuccessorTaskIds()) {
                DeletionTaskRecoveryInfo successor = (DeletionTaskRecoveryInfo)idToInfoMap.get(successorId);
                if (successor != null) {
                    info.getTask().addDeletionTaskDependency(successor.getTask());
                    continue;
                }
                LOG.error("Unable to locate dependency task for deletion task " + info.getTask().getTaskId());
            }
            if (successorTasks.contains(info.getTask().getTaskId())) continue;
            long msecTilDeletion = info.getDeletionTimestamp() - now;
            this.sched.schedule(info.getTask(), msecTilDeletion, TimeUnit.MILLISECONDS);
        }
    }

    private int generateTaskId() {
        int taskId = this.nextTaskId.incrementAndGet();
        while (taskId == -1) {
            taskId = this.nextTaskId.incrementAndGet();
        }
        return taskId;
    }

    private void recordDeletionTaskInStateStore(DeletionTask task) {
        DeletionTask[] successors;
        if (!this.stateStore.canRecover()) {
            return;
        }
        if (task.getTaskId() != -1) {
            return;
        }
        task.setTaskId(this.generateTaskId());
        for (DeletionTask successor : successors = task.getSuccessorTasks()) {
            this.recordDeletionTaskInStateStore(successor);
        }
        try {
            this.stateStore.storeDeletionTask(task.getTaskId(), task.convertDeletionTaskToProto());
        }
        catch (IOException e) {
            LOG.error("Unable to store deletion task " + task.getTaskId(), (Throwable)e);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("DeletionService #%d").build();
        if (conf != null) {
            this.sched = new HadoopScheduledThreadPoolExecutor(conf.getInt("yarn.nodemanager.delete.thread-count", 4), tf);
            this.debugDelay = conf.getInt("yarn.nodemanager.delete.debug-delay-sec", 0);
        } else {
            this.sched = new HadoopScheduledThreadPoolExecutor(4, tf);
        }
        this.sched.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sched.setKeepAliveTime(60L, TimeUnit.SECONDS);
        if (this.stateStore.canRecover()) {
            this.recover(this.stateStore.loadDeletionServiceState());
        }
        super.serviceInit(conf);
    }

    public void serviceStop() throws Exception {
        if (this.sched != null) {
            this.sched.shutdown();
            boolean terminated = false;
            try {
                terminated = this.sched.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!terminated) {
                this.sched.shutdownNow();
            }
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public boolean isTerminated() {
        return this.getServiceState() == Service.STATE.STOPPED && this.sched.isTerminated();
    }
}

