/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.AbstractReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Context;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Interceptor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ReadResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.apache.hadoop.shaded.org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOConnection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractNIOAsyncQueueReader
extends AbstractReader<SocketAddress>
implements AsyncQueueReader<SocketAddress> {
    private static final Logger LOGGER = Grizzly.logger(AbstractNIOAsyncQueueReader.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected int defaultBufferSize = 8192;
    protected final NIOTransport transport;
    private EOFException cachedEOFException;

    public AbstractNIOAsyncQueueReader(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public void read(Connection connection, Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, Interceptor<ReadResult> interceptor) {
        if (connection == null) {
            AbstractNIOAsyncQueueReader.failure(new IOException("Connection is null"), completionHandler);
            return;
        }
        if (!connection.isOpen()) {
            AbstractNIOAsyncQueueReader.failure(new IOException("Connection is closed"), completionHandler);
            return;
        }
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncReadQueue();
        ReadResult<Buffer, Object> currentResult = ReadResult.create(connection, buffer, null, 0);
        AsyncReadQueueRecord queueRecord = AsyncReadQueueRecord.create(connection, buffer, currentResult, completionHandler, interceptor);
        boolean isCurrent = connectionQueue.reserveSpace(1) == 1;
        try {
            if (isCurrent) {
                this.doRead(connection, queueRecord);
                int interceptInstructions = this.intercept(1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && queueRecord.isFinished()) {
                    boolean isQueueEmpty = connectionQueue.releaseSpaceAndNotify(1) == 0;
                    queueRecord.notifyComplete();
                    if (!isQueueEmpty) {
                        this.onReadyToRead(connection);
                    }
                    this.intercept(2, queueRecord, null);
                    queueRecord.recycle();
                } else {
                    if ((interceptInstructions & 4) != 0) {
                        currentResult.setMessage(null);
                        currentResult.setReadSize(0);
                        queueRecord.setMessage(null);
                    }
                    connectionQueue.setCurrentElement(queueRecord);
                    queueRecord.notifyIncomplete();
                    this.onReadyToRead(connection);
                    this.intercept(3, queueRecord, null);
                }
            } else {
                connectionQueue.offer(queueRecord);
                if (!connection.isOpen() && connectionQueue.remove(queueRecord)) {
                    this.onReadFailure(connection, queueRecord, new EOFException("Connection is closed"));
                }
            }
        }
        catch (IOException e) {
            this.onReadFailure(connection, queueRecord, e);
        }
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncReadQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncReadQueue();
        return connectionQueue != null && !connectionQueue.isEmpty();
    }

    @Override
    public AsyncQueue.AsyncResult processAsync(Context context) {
        NIOConnection nioConnection = (NIOConnection)context.getConnection();
        if (!nioConnection.isOpen()) {
            return AsyncQueue.AsyncResult.COMPLETE;
        }
        TaskQueue<AsyncReadQueueRecord> connectionQueue = nioConnection.getAsyncReadQueue();
        boolean done = false;
        AsyncReadQueueRecord queueRecord = null;
        try {
            while ((queueRecord = connectionQueue.obtainCurrentElementAndReserve()) != null) {
                ReadResult currentResult = (ReadResult)queueRecord.getCurrentResult();
                this.doRead(nioConnection, queueRecord);
                Interceptor interceptor = queueRecord.getInterceptor();
                int interceptInstructions = this.intercept(1, queueRecord, currentResult);
                if ((interceptInstructions & 1) != 0 || interceptor == null && queueRecord.isFinished()) {
                    if (!context.isManualIOEventControl() && connectionQueue.spaceInBytes() - 1 <= 0) {
                        context.setManualIOEventControl();
                    }
                    done = connectionQueue.releaseSpaceAndNotify(1) == 0;
                    queueRecord.notifyComplete();
                    this.intercept(2, queueRecord, null);
                    queueRecord.recycle();
                    if (!done) continue;
                    break;
                }
                if ((interceptInstructions & 4) != 0) {
                    currentResult.setMessage(null);
                    currentResult.setReadSize(0);
                    queueRecord.setMessage(null);
                }
                connectionQueue.setCurrentElement(queueRecord);
                queueRecord.notifyIncomplete();
                this.intercept(3, queueRecord, null);
                return AsyncQueue.AsyncResult.INCOMPLETE;
            }
            if (!done) {
                return AsyncQueue.AsyncResult.EXPECTING_MORE;
            }
        }
        catch (IOException e) {
            this.onReadFailure(nioConnection, queueRecord, e);
        }
        catch (Exception e) {
            String message = "Unexpected exception occurred in AsyncQueueReader";
            LOGGER.log(Level.SEVERE, message, e);
            IOException ioe = new IOException(e.getClass() + ": " + message);
            this.onReadFailure(nioConnection, queueRecord, ioe);
        }
        return AsyncQueue.AsyncResult.COMPLETE;
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncReadQueueRecord> readQueue = nioConnection.getAsyncReadQueue();
        if (!readQueue.isEmpty()) {
            AsyncReadQueueRecord record;
            EOFException error = this.cachedEOFException;
            if (error == null) {
                this.cachedEOFException = error = new EOFException("Connection closed");
            }
            while ((record = readQueue.obtainCurrentElementAndReserve()) != null) {
                record.notifyFailure(error);
            }
        }
    }

    @Override
    public final void close() {
    }

    protected final int doRead(Connection connection, AsyncReadQueueRecord queueRecord) throws IOException {
        ReadResult currentResult;
        Object message = queueRecord.getMessage();
        Buffer buffer = (Buffer)message;
        int readBytes = this.read0(connection, buffer, currentResult = (ReadResult)queueRecord.getCurrentResult());
        if (readBytes == -1) {
            throw new EOFException();
        }
        return readBytes;
    }

    protected final void onReadFailure(Connection connection, AsyncReadQueueRecord failedRecord, IOException e) {
        if (failedRecord != null) {
            failedRecord.notifyFailure(e);
        }
        connection.closeSilently();
    }

    private static void failure(Throwable failure, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler) {
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }

    private int intercept(int event, AsyncReadQueueRecord asyncQueueRecord, ReadResult currentResult) {
        Interceptor interceptor = asyncQueueRecord.getInterceptor();
        if (interceptor != null) {
            return interceptor.intercept(event, asyncQueueRecord, currentResult);
        }
        return 0;
    }

    protected abstract int read0(Connection var1, Buffer var2, ReadResult<Buffer, SocketAddress> var3) throws IOException;

    protected abstract void onReadyToRead(Connection var1) throws IOException;
}

