/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.servlet;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.com.google.inject.AbstractModule;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.servlet.FiltersModuleBuilder;
import org.apache.hadoop.shaded.com.google.inject.servlet.GuiceFilter;
import org.apache.hadoop.shaded.com.google.inject.servlet.InternalServletModule;
import org.apache.hadoop.shaded.com.google.inject.servlet.ServletsModuleBuilder;
import org.apache.hadoop.shaded.javax.servlet.Filter;
import org.apache.hadoop.shaded.javax.servlet.ServletContext;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServlet;

public class ServletModule
extends AbstractModule {
    private FiltersModuleBuilder filtersModuleBuilder;
    private ServletsModuleBuilder servletsModuleBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void configure() {
        Preconditions.checkState((this.filtersModuleBuilder == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        Preconditions.checkState((this.servletsModuleBuilder == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        this.filtersModuleBuilder = new FiltersModuleBuilder(this.binder());
        this.servletsModuleBuilder = new ServletsModuleBuilder(this.binder());
        try {
            this.install(new InternalServletModule());
            this.configureServlets();
        }
        finally {
            this.filtersModuleBuilder = null;
            this.servletsModuleBuilder = null;
        }
    }

    protected void configureServlets() {
    }

    private FiltersModuleBuilder getFiltersModuleBuilder() {
        Preconditions.checkState((this.filtersModuleBuilder != null ? 1 : 0) != 0, (Object)"This method can only be used inside configureServlets()");
        return this.filtersModuleBuilder;
    }

    private ServletsModuleBuilder getServletModuleBuilder() {
        Preconditions.checkState((this.servletsModuleBuilder != null ? 1 : 0) != 0, (Object)"This method can only be used inside configureServlets()");
        return this.servletsModuleBuilder;
    }

    protected final FilterKeyBindingBuilder filter(String urlPattern, String ... morePatterns) {
        return this.getFiltersModuleBuilder().filter((List<String>)ImmutableList.builder().add((Object)urlPattern).add((Object[])morePatterns).build());
    }

    protected final FilterKeyBindingBuilder filterRegex(String regex, String ... regexes) {
        return this.getFiltersModuleBuilder().filterRegex((List<String>)ImmutableList.builder().add((Object)regex).add((Object[])regexes).build());
    }

    protected final ServletKeyBindingBuilder serve(String urlPattern, String ... morePatterns) {
        return this.getServletModuleBuilder().serve((List<String>)ImmutableList.builder().add((Object)urlPattern).add((Object[])morePatterns).build());
    }

    protected final ServletKeyBindingBuilder serveRegex(String regex, String ... regexes) {
        return this.getServletModuleBuilder().serveRegex((List<String>)ImmutableList.builder().add((Object)regex).add((Object[])regexes).build());
    }

    protected final ServletContext getServletContext() {
        return GuiceFilter.getServletContext();
    }

    public static interface ServletKeyBindingBuilder {
        public void with(Class<? extends HttpServlet> var1);

        public void with(Key<? extends HttpServlet> var1);

        public void with(HttpServlet var1);

        public void with(Class<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(Key<? extends HttpServlet> var1, Map<String, String> var2);

        public void with(HttpServlet var1, Map<String, String> var2);
    }

    public static interface FilterKeyBindingBuilder {
        public void through(Class<? extends Filter> var1);

        public void through(Key<? extends Filter> var1);

        public void through(Filter var1);

        public void through(Class<? extends Filter> var1, Map<String, String> var2);

        public void through(Key<? extends Filter> var1, Map<String, String> var2);

        public void through(Filter var1, Map<String, String> var2);
    }
}

