/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsJobsBlock
extends HtmlBlock {
    final AppContext appContext;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
    private UserGroupInformation ugi;
    private boolean isFilterAppListByUserEnabled;
    private boolean areAclsEnabled;
    private AccessControlList adminAclList;

    @Inject
    HsJobsBlock(Configuration conf, AppContext appCtx, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appCtx;
        this.isFilterAppListByUserEnabled = conf.getBoolean("yarn.webapp.filter-entity-list-by-user", false);
        this.areAclsEnabled = conf.getBoolean("mapreduce.cluster.acls.enabled", false);
        this.adminAclList = new AccessControlList(conf.get("mapreduce.cluster.administrators", " "));
    }

    protected void render(HtmlBlock.Block html) {
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.h2("Retired Jobs").table("#jobs").thead().tr().th("Submit Time").th("Start Time").th("Finish Time").th(".id", "Job ID").th(".name", "Name").th("User").th("Queue").th(".state", "State").th("Maps Total").th("Maps Completed").th("Reduces Total").th("Reduces Completed").th("Elapsed Time").__()).__()).tbody();
        LOG.info("Getting list of all Jobs.");
        StringBuilder jobsTableData = new StringBuilder("[\n");
        for (Job j : this.appContext.getAllJobs().values()) {
            JobInfo job = new JobInfo(j);
            this.ugi = this.getCallerUGI();
            if (this.isFilterAppListByUserEnabled && this.ugi != null && !this.checkAccess(job.getUserName())) continue;
            jobsTableData.append("[\"").append(this.dateFormat.format(new Date(job.getSubmitTime()))).append("\",\"").append(job.getFormattedStartTimeStr(this.dateFormat)).append("\",\"").append(this.dateFormat.format(new Date(job.getFinishTime()))).append("\",\"").append("<a href='").append(this.url(new String[]{"job", job.getId()})).append("'>").append(job.getId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)job.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)job.getUserName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)job.getQueueName()))).append("\",\"").append(job.getState()).append("\",\"").append(String.valueOf(job.getMapsTotal())).append("\",\"").append(String.valueOf(job.getMapsCompleted())).append("\",\"").append(String.valueOf(job.getReducesTotal())).append("\",\"").append(String.valueOf(job.getReducesCompleted())).append("\",\"").append(StringUtils.formatTimeSortable((long)Times.elapsed((long)job.getStartTime(), (long)job.getFinishTime(), (boolean)false))).append("\"],\n");
        }
        if (jobsTableData.charAt(jobsTableData.length() - 2) == ',') {
            jobsTableData.delete(jobsTableData.length() - 2, jobsTableData.length() - 1);
        }
        jobsTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var jobsTableData=" + jobsTableData}).__();
        ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TABLE)tbody.__()).tfoot().tr().th().input("search_init").$type(HamletSpec.InputType.text).$name("submit_time").$value("Submit Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Start Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("finish_time").$value("Finish Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("job_id").$value("Job ID").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("name").$value("Name").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("user").$value("User").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("queue").$value("Queue").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("state").$value("State").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("maps_total").$value("Maps Total").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("maps_completed").$value("Maps Completed").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("reduces_total").$value("Reduces Total").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("reduces_completed").$value("Reduces Completed").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_time").$value("Elapsed Time").__()).__()).__()).__()).__();
    }

    private boolean checkAccess(String userName) {
        if (!this.areAclsEnabled) {
            return true;
        }
        if (this.ugi.getShortUserName().equals(userName)) {
            return true;
        }
        return this.adminAclList != null && this.adminAclList.isUserAllowed(this.ugi);
    }
}

