/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class GlobalStateIdContext
implements AlignmentContext {
    private static final long ESTIMATED_TRANSACTIONS_PER_SECOND = 10000L;
    private static final float ESTIMATED_SERVER_TIME_MULTIPLIER = 0.8f;
    private final FSNamesystem namesystem;
    private final HashSet<String> coordinatedMethods;

    GlobalStateIdContext(FSNamesystem namesystem) {
        this.namesystem = namesystem;
        this.coordinatedMethods = new HashSet();
        for (Method method : ClientProtocol.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ReadOnly.class) || !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].isCoordinated()) continue;
            this.coordinatedMethods.add(method.getName());
        }
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
        header.setStateId(this.getLastSeenStateId());
    }

    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
    }

    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long clientWaitTime) throws RetriableException {
        long serverStateId = this.namesystem.getFSImage().getCorrectLastAppliedOrWrittenTxId();
        long clientStateId = header.getStateId();
        if (clientStateId > serverStateId && HAServiceProtocol.HAServiceState.ACTIVE.equals((Object)this.namesystem.getState())) {
            FSNamesystem.LOG.warn("A client sent stateId: " + clientStateId + ", but server state is: " + serverStateId);
            return serverStateId;
        }
        if (HAServiceProtocol.HAServiceState.OBSERVER.equals((Object)this.namesystem.getState()) && (float)(clientStateId - serverStateId) > (float)(10000L * TimeUnit.MILLISECONDS.toSeconds(clientWaitTime)) * 0.8f) {
            throw new RetriableException("Observer Node is too far behind: serverStateId = " + serverStateId + " clientStateId = " + clientStateId);
        }
        return clientStateId;
    }

    public long getLastSeenStateId() {
        return this.namesystem.getFSImage().getCorrectLastAppliedOrWrittenTxId();
    }

    public boolean isCoordinatedCall(String protocolName, String methodName) {
        return protocolName.equals(ClientProtocol.class.getCanonicalName()) && this.coordinatedMethods.contains(methodName);
    }
}

