/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.base.Throwables;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang.text.StrBuilder;

public class PlanCommand
extends Command {
    private double thresholdPercentage = 1.0;
    private int bandwidth = 0;
    private int maxError = 0;

    public PlanCommand(Configuration conf) {
        this(conf, System.out);
    }

    public PlanCommand(Configuration conf, PrintStream ps) {
        super(conf, ps);
        this.addValidCommandParameters("out", "Output directory in HDFS. The generated plan will be written to a file in this directory.");
        this.addValidCommandParameters("bandwidth", "Maximum Bandwidth to be used while copying.");
        this.addValidCommandParameters("thresholdPercentage", "Percentage skew that we tolerate before diskbalancer starts working.");
        this.addValidCommandParameters("maxerror", "Max errors to tolerate between 2 disks");
        this.addValidCommandParameters("v", "Run plan command in verbose mode.");
        this.addValidCommandParameters("plan", "Plan Command");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        StrBuilder result = new StrBuilder();
        String outputLine = "";
        LOG.debug("Processing Plan Command.");
        Preconditions.checkState((boolean)cmd.hasOption("plan"));
        this.verifyCommandOptions("plan", cmd);
        if (cmd.getOptionValue("plan") == null) {
            throw new IllegalArgumentException("A node name is required to create a plan.");
        }
        if (cmd.hasOption("bandwidth")) {
            this.bandwidth = Integer.parseInt(cmd.getOptionValue("bandwidth"));
        }
        if (cmd.hasOption("maxerror")) {
            this.maxError = Integer.parseInt(cmd.getOptionValue("maxerror"));
        }
        this.readClusterInfo(cmd);
        String output = null;
        if (cmd.hasOption("out")) {
            output = cmd.getOptionValue("out");
        }
        this.setOutputPath(output);
        DiskBalancerDataNode node = this.getNode(cmd.getOptionValue("plan"));
        if (node == null) {
            throw new IllegalArgumentException("Unable to find the specified node. " + cmd.getOptionValue("plan"));
        }
        try (FSDataOutputStream beforeStream = this.create(String.format("%s.before.json", cmd.getOptionValue("plan")));){
            beforeStream.write(this.getCluster().toJson().getBytes(StandardCharsets.UTF_8));
        }
        this.thresholdPercentage = this.getThresholdPercentage(cmd);
        LOG.debug("threshold Percentage is {}", (Object)this.thresholdPercentage);
        this.setNodesToProcess(node);
        this.populatePathNames(node);
        NodePlan plan = null;
        List<NodePlan> plans = this.getCluster().computePlan(this.thresholdPercentage);
        this.setPlanParams(plans);
        if (plans.size() > 0) {
            plan = plans.get(0);
        }
        try {
            if (plan != null && plan.getVolumeSetPlans().size() > 0) {
                outputLine = String.format("Writing plan to:", new Object[0]);
                this.recordOutput(result, outputLine);
                String planFileName = String.format("%s.plan.json", cmd.getOptionValue("plan"));
                String planFileFullName = new Path(this.getOutputPath(), planFileName).toString();
                this.recordOutput(result, planFileFullName);
                try (FSDataOutputStream planStream = this.create(planFileName);){
                    planStream.write(plan.toJson().getBytes(StandardCharsets.UTF_8));
                }
            } else {
                outputLine = String.format("No plan generated. DiskBalancing not needed for node: %s threshold used: %s", cmd.getOptionValue("plan"), this.thresholdPercentage);
                this.recordOutput(result, outputLine);
            }
            if (cmd.hasOption("v") && plans.size() > 0) {
                PlanCommand.printToScreen(plans);
            }
        }
        catch (Exception e) {
            String errMsg = "Errors while recording the output of plan command.";
            LOG.error("Errors while recording the output of plan command.", (Throwable)e);
            result.appendln("Errors while recording the output of plan command.");
            result.appendln(Throwables.getStackTraceAsString((Throwable)e));
        }
        this.getPrintStream().print(result.toString());
    }

    @Override
    public void printHelp() {
        String header = "Creates a plan that describes how much data should be moved between disks.\n\n";
        String footer = "\nPlan command creates a set of steps that represent a planned data move. A plan file can be executed on a data node, which will balance the data.";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -plan <hostname> [options]", header, DiskBalancerCLI.getPlanOptions(), footer);
    }

    private double getThresholdPercentage(CommandLine cmd) {
        Double value = 0.0;
        if (cmd.hasOption("thresholdPercentage")) {
            value = Double.parseDouble(cmd.getOptionValue("thresholdPercentage"));
        }
        if (value <= 0.0 || value > 100.0) {
            value = this.getConf().getDouble("dfs.disk.balancer.plan.threshold.percent", 10.0);
        }
        return value;
    }

    private static void printToScreen(List<NodePlan> plans) {
        System.out.println("\nPlan :\n");
        System.out.println(StringUtils.repeat((String)"=", (int)80));
        System.out.println(StringUtils.center((String)"Source Disk", (int)30) + StringUtils.center((String)"Dest.Disk", (int)30) + StringUtils.center((String)"Size", (int)10) + StringUtils.center((String)"Type", (int)10));
        for (NodePlan plan : plans) {
            for (Step step : plan.getVolumeSetPlans()) {
                System.out.println(String.format("%s %s %s %s", StringUtils.center((String)step.getSourceVolume().getPath(), (int)30), StringUtils.center((String)step.getDestinationVolume().getPath(), (int)30), StringUtils.center((String)step.getSizeString(step.getBytesToMove()), (int)10), StringUtils.center((String)step.getDestinationVolume().getStorageType(), (int)10)));
            }
        }
        System.out.println(StringUtils.repeat((String)"=", (int)80));
    }

    private void setPlanParams(List<NodePlan> plans) {
        for (NodePlan plan : plans) {
            for (Step step : plan.getVolumeSetPlans()) {
                if (this.bandwidth > 0) {
                    LOG.debug("Setting bandwidth to {}", (Object)this.bandwidth);
                    step.setBandwidth(this.bandwidth);
                }
                if (this.maxError <= 0) continue;
                LOG.debug("Setting max error to {}", (Object)this.maxError);
                step.setMaxDiskErrors(this.maxError);
            }
        }
    }
}

