/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.base.Supplier;
import org.apache.hadoop.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.shaded.com.google.common.collect.Multimap;
import org.apache.hadoop.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig"})
@InterfaceStability.Unstable
public class MiniDFSCluster
implements AutoCloseable {
    private static final String NAMESERVICE_ID_PREFIX = "nameserviceId";
    private static final Log LOG = LogFactory.getLog(MiniDFSCluster.class);
    public static final String PROP_TEST_BUILD_DATA = "test.build.data";
    public static final String HDFS_MINIDFS_BASEDIR = "hdfs.minidfs.basedir";
    public static final String HDFS_MINIDFS_BASEDIR_PROVIDED = "hdfs.minidfs.basedir.provided";
    public static final String DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY = "dfs.namenode.safemode.extension.testing";
    public static final String DFS_NAMENODE_DECOMMISSION_INTERVAL_TESTING_KEY = "dfs.namenode.decommission.interval.testing";
    private static final int DEFAULT_STORAGES_PER_DATANODE = 2;
    private Configuration conf;
    private Multimap<String, NameNodeInfo> namenodes = ArrayListMultimap.create();
    protected int numDataNodes;
    protected final List<DataNodeProperties> dataNodes = new ArrayList<DataNodeProperties>();
    private File base_dir;
    private File data_dir;
    private boolean waitSafeMode = true;
    private boolean federation;
    private boolean checkExitOnShutdown = true;
    protected final int storagesPerDatanode;
    private Set<FileSystem> fileSystems = Sets.newHashSet();
    private List<long[]> storageCap = Lists.newLinkedList();
    private int instanceId;
    private static int instanceCount;

    public int getStoragesPerDatanode() {
        return this.storagesPerDatanode;
    }

    protected MiniDFSCluster(Builder builder) throws IOException {
        int i;
        if (builder.nnTopology == null) {
            builder.nnTopology = MiniDFSNNTopology.simpleSingleNN(builder.nameNodePort, builder.nameNodeHttpPort);
        }
        assert (builder.storageTypes == null || builder.storageTypes.length == builder.numDataNodes);
        int numNameNodes = builder.nnTopology.countNameNodes();
        LOG.info((Object)("starting cluster: numNameNodes=" + numNameNodes + ", numDataNodes=" + builder.numDataNodes));
        this.storagesPerDatanode = builder.storagesPerDatanode;
        if (builder.storageTypes == null && builder.storageTypes1D != null) {
            assert (builder.storageTypes1D.length == this.storagesPerDatanode);
            Builder.access$302(builder, new StorageType[builder.numDataNodes][this.storagesPerDatanode]);
            for (i = 0; i < builder.numDataNodes; ++i) {
                ((Builder)builder).storageTypes[i] = builder.storageTypes1D;
            }
        }
        if (builder.storageCapacities == null && builder.storageCapacities1D != null) {
            assert (builder.storageCapacities1D.length == this.storagesPerDatanode);
            Builder.access$702(builder, new long[builder.numDataNodes][this.storagesPerDatanode]);
            for (i = 0; i < builder.numDataNodes; ++i) {
                ((Builder)builder).storageCapacities[i] = builder.storageCapacities1D;
            }
        }
        this.initMiniDFSCluster(builder.conf, builder.numDataNodes, builder.storageTypes, builder.format, builder.manageNameDfsDirs, builder.manageNameDfsSharedDirs, builder.enableManagedDfsDirsRedundancy, builder.manageDataDfsDirs, builder.option, builder.dnOption, builder.racks, builder.hosts, builder.storageCapacities, builder.simulatedCapacities, builder.clusterId, builder.waitSafeMode, builder.setupHostsFile, builder.nnTopology, builder.checkExitOnShutdown, builder.checkDataNodeAddrConfig, builder.checkDataNodeHostConfig, builder.dnConfOverlays, builder.skipFsyncForTesting, builder.useConfiguredTopologyMappingClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniDFSCluster() {
        this.storagesPerDatanode = 2;
        Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
        synchronized (MiniDFSCluster.class) {
            this.instanceId = instanceCount++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, HdfsServerConstants.StartupOption nameNodeOperation) throws IOException {
        this(0, conf, numDataNodes, false, false, false, nameNodeOperation, null, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(Configuration conf, int numDataNodes, boolean format, String[] racks, String[] hosts) throws IOException {
        this(0, conf, numDataNodes, format, true, true, null, racks, hosts, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, null);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this(nameNodePort, conf, numDataNodes, format, manageDfsDirs, manageDfsDirs, operation, racks, null, simulatedCapacities);
    }

    @Deprecated
    public MiniDFSCluster(int nameNodePort, Configuration conf, int numDataNodes, boolean format, boolean manageNameDfsDirs, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.storagesPerDatanode = 2;
        this.initMiniDFSCluster(conf, numDataNodes, null, format, manageNameDfsDirs, true, manageDataDfsDirs, manageDataDfsDirs, operation, null, racks, hosts, null, simulatedCapacities, null, true, false, MiniDFSNNTopology.simpleSingleNN(nameNodePort, 0), true, false, false, null, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMiniDFSCluster(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean format, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean manageDataDfsDirs, HdfsServerConstants.StartupOption startOpt, HdfsServerConstants.StartupOption dnStartOpt, String[] racks, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, String clusterId, boolean waitSafeMode, boolean setupHostsFile, MiniDFSNNTopology nnTopology, boolean checkExitOnShutdown, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays, boolean skipFsyncForTesting, boolean useConfiguredTopologyMappingClass) throws IOException {
        boolean success = false;
        try {
            ExitUtil.disableSystemExit();
            FileSystem.enableSymlinks();
            Class<MiniDFSCluster> clazz = MiniDFSCluster.class;
            synchronized (MiniDFSCluster.class) {
                this.instanceId = instanceCount++;
                // ** MonitorExit[var26_26] (shouldn't be in output)
                this.conf = conf;
                this.base_dir = new File(this.determineDfsBaseDir());
                this.data_dir = new File(this.base_dir, "data");
                this.waitSafeMode = waitSafeMode;
                this.checkExitOnShutdown = checkExitOnShutdown;
                int replication = conf.getInt("dfs.replication", 3);
                conf.setInt("dfs.replication", Math.min(replication, numDataNodes));
                int maintenanceMinReplication = conf.getInt("dfs.namenode.maintenance.replication.min", 1);
                if (maintenanceMinReplication == 1) {
                    conf.setInt("dfs.namenode.maintenance.replication.min", Math.min(maintenanceMinReplication, numDataNodes));
                }
                int safemodeExtension = conf.getInt(DFS_NAMENODE_SAFEMODE_EXTENSION_TESTING_KEY, 0);
                conf.setInt("dfs.namenode.safemode.extension", safemodeExtension);
                long decommissionInterval = conf.getTimeDuration(DFS_NAMENODE_DECOMMISSION_INTERVAL_TESTING_KEY, 3L, TimeUnit.SECONDS);
                conf.setTimeDuration("dfs.namenode.decommission.interval", decommissionInterval, TimeUnit.SECONDS);
                if (!useConfiguredTopologyMappingClass) {
                    conf.setClass("net.topology.node.switch.mapping.impl", StaticMapping.class, DNSToSwitchMapping.class);
                }
                if (!nnTopology.allHttpPortsSpecified() && nnTopology.isHA()) {
                    LOG.info((Object)"MiniDFSCluster disabling checkpointing in the Standby node since no HTTP ports have been specified.");
                    conf.setBoolean("dfs.ha.standby.checkpoints", false);
                }
                if (!nnTopology.allIpcPortsSpecified() && nnTopology.isHA()) {
                    LOG.info((Object)"MiniDFSCluster disabling log-roll triggering in the Standby node since no IPC ports have been specified.");
                    conf.setInt("dfs.ha.log-roll.period", -1);
                }
                EditLogFileOutputStream.setShouldSkipFsyncForTesting(skipFsyncForTesting);
                this.federation = nnTopology.isFederated();
                try {
                    this.createNameNodesAndSetConf(nnTopology, manageNameDfsDirs, manageNameDfsSharedDirs, enableManagedDfsDirsRedundancy, format, startOpt, clusterId);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOE creating namenodes. Permissions dump:\n" + this.createPermissionsDiagnosisString(this.data_dir)), (Throwable)ioe);
                    throw ioe;
                }
                if (format && this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
                    throw new IOException("Cannot remove data directory: " + this.data_dir + this.createPermissionsDiagnosisString(this.data_dir));
                }
                if (startOpt == HdfsServerConstants.StartupOption.RECOVER) {
                    return;
                }
                this.startDataNodes(conf, numDataNodes, storageTypes, manageDataDfsDirs, dnStartOpt != null ? dnStartOpt : startOpt, racks, hosts, storageCapacities, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, checkDataNodeHostConfig, dnConfOverlays);
                this.waitClusterUp();
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
                success = true;
            }
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
        {
            return;
        }
    }

    private String createPermissionsDiagnosisString(File path) {
        StringBuilder sb = new StringBuilder();
        while (path != null) {
            sb.append("path '" + path + "': ").append("\n");
            sb.append("\tabsolute:").append(path.getAbsolutePath()).append("\n");
            sb.append("\tpermissions: ");
            sb.append(path.isDirectory() ? "d" : "-");
            sb.append(FileUtil.canRead((File)path) ? "r" : "-");
            sb.append(FileUtil.canWrite((File)path) ? "w" : "-");
            sb.append(FileUtil.canExecute((File)path) ? "x" : "-");
            sb.append("\n");
            path = path.getParentFile();
        }
        return sb.toString();
    }

    private void createNameNodesAndSetConf(MiniDFSNNTopology nnTopology, boolean manageNameDfsDirs, boolean manageNameDfsSharedDirs, boolean enableManagedDfsDirsRedundancy, boolean format, HdfsServerConstants.StartupOption operation, String clusterId) throws IOException {
        MiniDFSCluster.configureNameNodes(nnTopology, this.federation, this.conf);
        int nnCounter = 0;
        int nsCounter = 0;
        for (MiniDFSNNTopology.NSConf nameservice : nnTopology.getNameservices()) {
            this.configureNameService(nameservice, nsCounter++, manageNameDfsSharedDirs, manageNameDfsDirs, enableManagedDfsDirsRedundancy, format, operation, clusterId, nnCounter);
            nnCounter += nameservice.getNNs().size();
        }
        for (NameNodeInfo nn : this.namenodes.values()) {
            Configuration nnConf = nn.conf;
            for (NameNodeInfo nnInfo : this.namenodes.values()) {
                if (nn.equals(nnInfo)) continue;
                MiniDFSCluster.copyKeys(this.conf, nnConf, nnInfo.nameserviceId, nnInfo.nnId);
            }
        }
    }

    private static void copyKeys(Configuration srcConf, Configuration destConf, String nameserviceId, String nnId) {
        String key = DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", nameserviceId, nnId);
        destConf.set(key, srcConf.get(key));
        MiniDFSCluster.copyKey(srcConf, destConf, nameserviceId, nnId, "dfs.namenode.http-address");
        MiniDFSCluster.copyKey(srcConf, destConf, nameserviceId, nnId, "dfs.namenode.https-address");
        MiniDFSCluster.copyKey(srcConf, destConf, nameserviceId, nnId, "dfs.namenode.lifeline.rpc-address");
        MiniDFSCluster.copyKey(srcConf, destConf, nameserviceId, nnId, "dfs.namenode.servicerpc-address");
    }

    private static void copyKey(Configuration srcConf, Configuration destConf, String nameserviceId, String nnId, String baseKey) {
        String key = DFSUtil.addKeySuffixes(baseKey, nameserviceId, nnId);
        String val = srcConf.get(key);
        if (val != null) {
            destConf.set(key, srcConf.get(key));
        }
    }

    private void configureNameService(MiniDFSNNTopology.NSConf nameservice, int nsCounter, boolean manageNameDfsSharedDirs, boolean manageNameDfsDirs, boolean enableManagedDfsDirsRedundancy, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, int nnCounter) throws IOException {
        String nsId = nameservice.getId();
        String lastDefaultFileSystem = null;
        int numNNs = nameservice.getNNs().size();
        if (numNNs > 1 && manageNameDfsSharedDirs) {
            URI sharedEditsUri = this.getSharedEditsDir(nnCounter, nnCounter + numNNs - 1);
            this.conf.set("dfs.namenode.shared.edits.dir", sharedEditsUri.toString());
            FileUtil.fullyDelete((File)new File(sharedEditsUri));
        }
        int nnIndex = nnCounter;
        Collection<URI> prevNNDirs = null;
        for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
            this.initNameNodeConf(this.conf, nsId, nsCounter, nn.getNnId(), manageNameDfsDirs, manageNameDfsDirs, nnIndex);
            Collection<URI> namespaceDirs = FSNamesystem.getNamespaceDirs(this.conf);
            if (format) {
                for (URI nameDirUri : namespaceDirs) {
                    File nameDir = new File(nameDirUri);
                    if (!nameDir.exists() || FileUtil.fullyDelete((File)nameDir)) continue;
                    throw new IOException("Could not fully delete " + nameDir);
                }
                List<URI> checkpointDirs = Util.stringCollectionAsURIs(this.conf.getTrimmedStringCollection("dfs.namenode.checkpoint.dir"));
                for (URI checkpointDirUri : checkpointDirs) {
                    File checkpointDir = new File(checkpointDirUri);
                    if (!checkpointDir.exists() || FileUtil.fullyDelete((File)checkpointDir)) continue;
                    throw new IOException("Could not fully delete " + checkpointDir);
                }
            }
            boolean formatThisOne = format;
            if (nnIndex++ > nnCounter && format) {
                formatThisOne = false;
                assert (null != prevNNDirs);
                MiniDFSCluster.copyNameDirs(prevNNDirs, namespaceDirs, this.conf);
            }
            if (formatThisOne) {
                if (nn.getClusterId() == null) {
                    HdfsServerConstants.StartupOption.FORMAT.setClusterId(clusterId);
                } else {
                    HdfsServerConstants.StartupOption.FORMAT.setClusterId(nn.getClusterId());
                }
                DFSTestUtil.formatNameNode(this.conf);
            }
            prevNNDirs = namespaceDirs;
        }
        nnIndex = nnCounter;
        for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
            Configuration hdfsConf = new Configuration(this.conf);
            this.initNameNodeConf(hdfsConf, nsId, nsCounter, nn.getNnId(), manageNameDfsDirs, enableManagedDfsDirsRedundancy, nnIndex++);
            this.createNameNode(hdfsConf, false, operation, clusterId, nsId, nn.getNnId());
            lastDefaultFileSystem = hdfsConf.get("fs.defaultFS");
        }
        if (!this.federation && lastDefaultFileSystem != null) {
            this.conf.set("fs.defaultFS", lastDefaultFileSystem);
        }
    }

    public static void configureNameNodes(MiniDFSNNTopology nnTopology, boolean federation, Configuration conf) throws IOException {
        Preconditions.checkArgument((nnTopology.countNameNodes() > 0 ? 1 : 0) != 0, (Object)"empty NN topology: no namenodes specified!");
        if (!federation && nnTopology.countNameNodes() == 1) {
            MiniDFSNNTopology.NNConf onlyNN = nnTopology.getOnlyNameNode();
            conf.set("fs.defaultFS", "hdfs://127.0.0.1:" + onlyNN.getIpcPort());
        }
        ArrayList allNsIds = Lists.newArrayList();
        for (MiniDFSNNTopology.NSConf nameservice : nnTopology.getNameservices()) {
            if (nameservice.getId() == null) continue;
            allNsIds.add(nameservice.getId());
        }
        if (!allNsIds.isEmpty()) {
            conf.set("dfs.nameservices", Joiner.on((String)",").join((Iterable)allNsIds));
        }
        for (MiniDFSNNTopology.NSConf nameservice : nnTopology.getNameservices()) {
            String nsId = nameservice.getId();
            Preconditions.checkArgument((!federation || nsId != null ? 1 : 0) != 0, (Object)"if there is more than one NS, they must have names");
            ArrayList nnIds = Lists.newArrayList();
            for (MiniDFSNNTopology.NNConf nn : nameservice.getNNs()) {
                nnIds.add(nn.getNnId());
                MiniDFSCluster.initNameNodeAddress(conf, nameservice.getId(), nn);
            }
            if (nnIds.size() <= 1) continue;
            conf.set(DFSUtil.addKeySuffixes("dfs.ha.namenodes", nameservice.getId()), Joiner.on((String)",").join((Iterable)nnIds));
        }
    }

    public URI getSharedEditsDir(int minNN, int maxNN) throws IOException {
        return MiniDFSCluster.formatSharedEditsDir(this.base_dir, minNN, maxNN);
    }

    public static URI formatSharedEditsDir(File baseDir, int minNN, int maxNN) throws IOException {
        return Util.fileAsURI(new File(baseDir, "shared-edits-" + minNN + "-through-" + maxNN));
    }

    public NameNodeInfo[] getNameNodeInfos() {
        return this.namenodes.values().toArray(new NameNodeInfo[0]);
    }

    public NameNodeInfo[] getNameNodeInfos(int nsIndex) {
        int i = 0;
        for (String ns : this.namenodes.keys()) {
            if (i++ != nsIndex) continue;
            return this.namenodes.get((Object)ns).toArray(new NameNodeInfo[0]);
        }
        return null;
    }

    public NameNodeInfo[] getNameNodeInfos(String nameservice) {
        for (String ns : this.namenodes.keys()) {
            if (!nameservice.equals(ns)) continue;
            return this.namenodes.get((Object)ns).toArray(new NameNodeInfo[0]);
        }
        return null;
    }

    private void initNameNodeConf(Configuration conf, String nameserviceId, int nsIndex, String nnId, boolean manageNameDfsDirs, boolean enableManagedDfsDirsRedundancy, int nnIndex) throws IOException {
        if (nameserviceId != null) {
            conf.set("dfs.nameservice.id", nameserviceId);
        }
        if (nnId != null) {
            conf.set("dfs.ha.namenode.id", nnId);
        }
        if (manageNameDfsDirs) {
            if (enableManagedDfsDirsRedundancy) {
                File[] files = this.getNameNodeDirectory(nsIndex, nnIndex);
                conf.set("dfs.namenode.name.dir", Util.fileAsURI(files[0]) + "," + Util.fileAsURI(files[1]));
                files = this.getCheckpointDirectory(nsIndex, nnIndex);
                conf.set("dfs.namenode.checkpoint.dir", Util.fileAsURI(files[0]) + "," + Util.fileAsURI(files[1]));
            } else {
                File[] files = this.getNameNodeDirectory(nsIndex, nnIndex);
                conf.set("dfs.namenode.name.dir", Util.fileAsURI(files[0]).toString());
                files = this.getCheckpointDirectory(nsIndex, nnIndex);
                conf.set("dfs.namenode.checkpoint.dir", Util.fileAsURI(files[0]).toString());
            }
        }
    }

    private File[] getNameNodeDirectory(int nameserviceIndex, int nnIndex) {
        return MiniDFSCluster.getNameNodeDirectory(this.base_dir, nameserviceIndex, nnIndex);
    }

    public static File[] getNameNodeDirectory(String base_dir, int nsIndex, int nnIndex) {
        return MiniDFSCluster.getNameNodeDirectory(new File(base_dir), nsIndex, nnIndex);
    }

    public static File[] getNameNodeDirectory(File base_dir, int nsIndex, int nnIndex) {
        File[] files = new File[]{new File(base_dir, "name-" + nsIndex + "-" + (2 * nnIndex + 1)), new File(base_dir, "name-" + nsIndex + "-" + (2 * nnIndex + 2))};
        return files;
    }

    public File[] getCheckpointDirectory(int nsIndex, int nnIndex) {
        return MiniDFSCluster.getCheckpointDirectory(this.base_dir, nsIndex, nnIndex);
    }

    public static File[] getCheckpointDirectory(String base_dir, int nsIndex, int nnIndex) {
        return MiniDFSCluster.getCheckpointDirectory(new File(base_dir), nsIndex, nnIndex);
    }

    public static File[] getCheckpointDirectory(File base_dir, int nsIndex, int nnIndex) {
        File[] files = new File[]{new File(base_dir, "namesecondary-" + nsIndex + "-" + (2 * nnIndex + 1)), new File(base_dir, "namesecondary-" + nsIndex + "-" + (2 * nnIndex + 2))};
        return files;
    }

    public static void copyNameDirs(Collection<URI> srcDirs, Collection<URI> dstDirs, Configuration dstConf) throws IOException {
        URI srcDir = (URI)Lists.newArrayList(srcDirs).get(0);
        FileSystem dstFS = FileSystem.getLocal((Configuration)dstConf).getRaw();
        for (URI dstDir : dstDirs) {
            Preconditions.checkArgument((!dstDir.equals(srcDir) ? 1 : 0) != 0, (Object)("src and dst are the same: " + dstDir));
            File dstDirF = new File(dstDir);
            if (dstDirF.exists() && !FileUtil.fullyDelete((File)dstDirF)) {
                throw new IOException("Unable to delete: " + dstDirF);
            }
            LOG.info((Object)("Copying namedir from primary node dir " + srcDir + " to " + dstDir));
            FileUtil.copy((File)new File(srcDir), (FileSystem)dstFS, (Path)new Path(dstDir), (boolean)false, (Configuration)dstConf);
        }
    }

    private static void initNameNodeAddress(Configuration conf, String nameserviceId, MiniDFSNNTopology.NNConf nnConf) {
        String key = DFSUtil.addKeySuffixes("dfs.namenode.http-address", nameserviceId, nnConf.getNnId());
        conf.set(key, "127.0.0.1:" + nnConf.getHttpPort());
        key = DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", nameserviceId, nnConf.getNnId());
        conf.set(key, "127.0.0.1:" + nnConf.getIpcPort());
    }

    private static String[] createArgs(HdfsServerConstants.StartupOption operation) {
        String[] stringArray;
        if (operation == HdfsServerConstants.StartupOption.ROLLINGUPGRADE) {
            return new String[]{operation.getName(), operation.getRollingUpgradeStartupOption().name()};
        }
        if (operation == null || operation == HdfsServerConstants.StartupOption.FORMAT || operation == HdfsServerConstants.StartupOption.REGULAR) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] args = stringArray;
        return args;
    }

    private void createNameNode(Configuration hdfsConf, boolean format, HdfsServerConstants.StartupOption operation, String clusterId, String nameserviceId, String nnId) throws IOException {
        if (format) {
            DFSTestUtil.formatNameNode(hdfsConf);
        }
        if (operation == HdfsServerConstants.StartupOption.UPGRADE) {
            operation.setClusterId(clusterId);
        }
        String[] args = MiniDFSCluster.createArgs(operation);
        NameNode nn = NameNode.createNameNode(args, hdfsConf);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        hdfsConf.set(DFSUtil.addKeySuffixes("dfs.namenode.rpc-address", nameserviceId, nnId), nn.getNameNodeAddressHostPortString());
        if (nn.getHttpAddress() != null) {
            hdfsConf.set(DFSUtil.addKeySuffixes("dfs.namenode.http-address", nameserviceId, nnId), NetUtils.getHostPortString((InetSocketAddress)nn.getHttpAddress()));
        }
        if (nn.getHttpsAddress() != null) {
            hdfsConf.set(DFSUtil.addKeySuffixes("dfs.namenode.https-address", nameserviceId, nnId), NetUtils.getHostPortString((InetSocketAddress)nn.getHttpsAddress()));
        }
        if (hdfsConf.get("dfs.namenode.lifeline.rpc-address") != null) {
            hdfsConf.set(DFSUtil.addKeySuffixes("dfs.namenode.lifeline.rpc-address", nameserviceId, nnId), hdfsConf.get("dfs.namenode.lifeline.rpc-address"));
        }
        MiniDFSCluster.copyKeys(hdfsConf, this.conf, nameserviceId, nnId);
        DFSUtil.setGenericConf(hdfsConf, nameserviceId, nnId, "dfs.namenode.http-address");
        NameNodeInfo info = new NameNodeInfo(nn, nameserviceId, nnId, operation, hdfsConf);
        this.namenodes.put((Object)nameserviceId, (Object)info);
    }

    public URI getURI() {
        this.checkSingleNameNode();
        return this.getURI(0);
    }

    public URI getURI(int nnIndex) {
        String hostPort = this.getNN((int)nnIndex).nameNode.getNameNodeAddressHostPortString();
        URI uri = null;
        try {
            uri = new URI("hdfs://" + hostPort);
        }
        catch (URISyntaxException e) {
            NameNode.LOG.warn("unexpected URISyntaxException", (Throwable)e);
        }
        return uri;
    }

    URI getURIForAuxiliaryPort(int nnIndex) {
        String hostPort = this.getNN((int)nnIndex).nameNode.getNNAuxiliaryRpcAddress();
        if (hostPort == null) {
            throw new RuntimeException("No auxiliary port found");
        }
        URI uri = null;
        try {
            uri = new URI("hdfs://" + hostPort);
        }
        catch (URISyntaxException e) {
            NameNode.LOG.warn("unexpected URISyntaxException", (Throwable)e);
        }
        return uri;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public Configuration getConfiguration(int nnIndex) {
        return this.getNN((int)nnIndex).conf;
    }

    private NameNodeInfo getNN(int nnIndex) {
        int count = 0;
        for (NameNodeInfo nn : this.namenodes.values()) {
            if (count == nnIndex) {
                return nn;
            }
            ++count;
        }
        return null;
    }

    public void waitNameNodeUp(int nnIndex) {
        while (!this.isNameNodeUp(nnIndex)) {
            try {
                LOG.warn((Object)("Waiting for namenode at " + nnIndex + " to start..."));
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void waitClusterUp() throws IOException {
        int i = 0;
        if (this.numDataNodes > 0) {
            while (!this.isClusterUp()) {
                try {
                    LOG.warn((Object)"Waiting for the Mini HDFS Cluster to start...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (++i <= 10) continue;
                String msg = "Timed out waiting for Mini HDFS Cluster to start";
                LOG.error((Object)"Timed out waiting for Mini HDFS Cluster to start");
                throw new IOException("Timed out waiting for Mini HDFS Cluster to start");
            }
        }
    }

    String makeDataNodeDirs(int dnIndex, StorageType[] storageTypes) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this.storagesPerDatanode && (storageTypes == null || j < storageTypes.length); ++j) {
            File dir = storageTypes != null && storageTypes[j] == StorageType.PROVIDED ? this.getProvidedStorageDir(dnIndex, j) : this.getInstanceStorageDir(dnIndex, j);
            dir.mkdirs();
            if (!dir.isDirectory()) {
                throw new IOException("Mkdirs failed to create directory for DataNode " + dir);
            }
            sb.append((j > 0 ? "," : "") + "[" + (storageTypes == null ? StorageType.DEFAULT : storageTypes[j]) + "]" + Util.fileAsURI(dir));
        }
        return sb.toString();
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, hosts, simulatedCapacities, false);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, null, manageDfsDirs, operation, racks, hosts, null, simulatedCapacities, setupHostsFile, false, false, null);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        this.startDataNodes(conf, numDataNodes, null, manageDfsDirs, operation, racks, hosts, null, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, false, null);
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, StorageType[][] storageTypes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[][] storageCapacities, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig, Configuration[] dnConfOverlays) throws IOException {
        String[] stringArray;
        assert (storageCapacities == null || simulatedCapacities == null);
        assert (storageTypes == null || storageTypes.length == numDataNodes);
        assert (storageCapacities == null || storageCapacities.length == numDataNodes);
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        if (checkDataNodeHostConfig) {
            conf.setIfUnset("dfs.datanode.hostname", "127.0.0.1");
        } else {
            conf.set("dfs.datanode.hostname", "127.0.0.1");
        }
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                hosts[i - curDatanodesNum] = "host" + i + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (dnConfOverlays != null && numDataNodes > dnConfOverlays.length) {
            throw new IllegalArgumentException("The length of dnConfOverlays [" + dnConfOverlays.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (operation == null || operation != HdfsServerConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        DataNode[] dns = new DataNode[numDataNodes];
        for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            HdfsConfiguration dnConf = new HdfsConfiguration(conf);
            if (dnConfOverlays != null) {
                dnConf.addResource(dnConfOverlays[i]);
            }
            this.setupDatanodeAddress((Configuration)dnConf, setupHostsFile, checkDataNodeAddrConfig);
            if (manageDfsDirs) {
                String dirs = this.makeDataNodeDirs(i, storageTypes == null ? null : storageTypes[i - curDatanodesNum]);
                dnConf.set("dfs.datanode.data.dir", dirs);
                conf.set("dfs.datanode.data.dir", dirs);
            }
            if (simulatedCapacities != null) {
                SimulatedFSDataset.setFactory((Configuration)dnConf);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("dfs.datanode.hostname", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("dfs.datanode.hostname")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack(name, racks[i - curDatanodesNum]);
            }
            HdfsConfiguration newconf = new HdfsConfiguration((Configuration)dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            SecureDataNodeStarter.SecureResources secureResources = null;
            if (UserGroupInformation.isSecurityEnabled() && conf.get("dfs.data.transfer.protection") == null) {
                try {
                    secureResources = SecureDataNodeStarter.getSecureResources((Configuration)dnConf);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            int maxRetriesOnSasl = conf.getInt("ipc.client.connect.max.retries.on.sasl", 5);
            int numRetries = 0;
            DataNode dn = null;
            while (true) {
                try {
                    dn = DataNode.instantiateDataNode(dnArgs, (Configuration)dnConf, secureResources);
                }
                catch (IOException e) {
                    if (UserGroupInformation.isSecurityEnabled() && numRetries < maxRetriesOnSasl) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        ++numRetries;
                        continue;
                    }
                    throw e;
                }
                break;
            }
            if (dn == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String service = SecurityUtil.buildTokenService((InetSocketAddress)dn.getXferAddress()).toString();
            if (racks != null) {
                LOG.info((Object)("Adding node with service : " + service + " to rack " + racks[i - curDatanodesNum]));
                StaticMapping.addNodeToRack(service, racks[i - curDatanodesNum]);
            }
            dn.runDatanodeDaemon();
            this.dataNodes.add(new DataNodeProperties(dn, (Configuration)newconf, dnArgs, secureResources, dn.getIpcPort()));
            dns[i - curDatanodesNum] = dn;
        }
        this.numDataNodes += numDataNodes;
        this.waitActive();
        this.setDataNodeStorageCapacities(curDatanodesNum, numDataNodes, dns, storageCapacities);
        if (storageCapacities != null) {
            this.storageCap.addAll(Arrays.asList(storageCapacities));
        }
    }

    private synchronized void setDataNodeStorageCapacities(int curDatanodesNum, int numDNs, DataNode[] dns, long[][] storageCapacities) throws IOException {
        if (storageCapacities != null) {
            for (int i = curDatanodesNum; i < curDatanodesNum + numDNs; ++i) {
                int index = i - curDatanodesNum;
                this.setDataNodeStorageCapacities(index, dns[index], storageCapacities);
            }
        }
    }

    private synchronized void setDataNodeStorageCapacities(int curDnIdx, DataNode curDn, long[][] storageCapacities) throws IOException {
        if (storageCapacities == null || storageCapacities.length == 0) {
            return;
        }
        try {
            this.waitDataNodeFullyStarted(curDn);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(e);
        }
        try (FsDatasetSpi.FsVolumeReferences volumes = curDn.getFSDataset().getFsVolumeReferences();){
            assert (storageCapacities[curDnIdx].length == this.storagesPerDatanode);
            assert (volumes.size() == this.storagesPerDatanode);
            int j = 0;
            for (FsVolumeSpi fvs : volumes) {
                FsVolumeImpl volume = (FsVolumeImpl)fvs;
                LOG.info((Object)("setCapacityForTesting " + storageCapacities[curDnIdx][j] + " for [" + volume.getStorageType() + "]" + volume.getStorageID()));
                volume.setCapacityForTesting(storageCapacities[curDnIdx][j]);
                ++j;
            }
        }
        DataNodeTestUtils.triggerHeartbeat(curDn);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, null, false);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, null, simulatedCapacities, false);
    }

    private void finalizeNamenode(NameNode nn, Configuration conf) throws Exception {
        if (nn == null) {
            throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
        }
        ToolRunner.run((Tool)new DFSAdmin(conf), (String[])new String[]{"-finalizeUpgrade"});
    }

    public void finalizeCluster(int nnIndex, Configuration conf) throws Exception {
        this.finalizeNamenode(this.getNN((int)nnIndex).nameNode, this.getNN((int)nnIndex).conf);
    }

    public void finalizeCluster(Configuration conf) throws Exception {
        for (NameNodeInfo nnInfo : this.namenodes.values()) {
            if (nnInfo == null) {
                throw new IllegalStateException("Attempting to finalize Namenode but it is not running");
            }
            this.finalizeNamenode(nnInfo.nameNode, nnInfo.conf);
        }
    }

    public int getNumNameNodes() {
        return this.namenodes.size();
    }

    public NameNode getNameNode() {
        this.checkSingleNameNode();
        return this.getNameNode(0);
    }

    public NamenodeProtocols getNameNodeRpc() {
        this.checkSingleNameNode();
        return this.getNameNodeRpc(0);
    }

    public NamenodeProtocols getNameNodeRpc(int nnIndex) {
        return this.getNameNode(nnIndex).getRpcServer();
    }

    public NameNode getNameNode(int nnIndex) {
        return this.getNN((int)nnIndex).nameNode;
    }

    public FSNamesystem getNamesystem() {
        this.checkSingleNameNode();
        return NameNodeAdapter.getNamesystem(this.getNN((int)0).nameNode);
    }

    public FSNamesystem getNamesystem(int nnIndex) {
        return NameNodeAdapter.getNamesystem(this.getNN((int)nnIndex).nameNode);
    }

    public ArrayList<DataNode> getDataNodes() {
        ArrayList<DataNode> list = new ArrayList<DataNode>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode node = this.dataNodes.get((int)i).datanode;
            list.add(node);
        }
        return list;
    }

    public DataNode getDataNode(int ipcPort) {
        for (DataNode dn : this.getDataNodes()) {
            if (dn.ipcServer.getListenerAddress().getPort() != ipcPort) continue;
            return dn;
        }
        return null;
    }

    public FsDatasetTestUtils getFsDatasetTestUtils(int dnIdx) {
        Preconditions.checkArgument((dnIdx < this.dataNodes.size() ? 1 : 0) != 0);
        return FsDatasetTestUtils.Factory.getFactory(this.conf).newInstance(this.dataNodes.get((int)dnIdx).datanode);
    }

    public FsDatasetTestUtils getFsDatasetTestUtils(DataNode dn) {
        Preconditions.checkArgument((dn != null ? 1 : 0) != 0);
        return FsDatasetTestUtils.Factory.getFactory(this.conf).newInstance(dn);
    }

    public int getNameNodePort() {
        this.checkSingleNameNode();
        return this.getNameNodePort(0);
    }

    public int getNameNodeAuxiliaryPort() {
        this.checkSingleNameNode();
        return this.getNameNodeAuxiliaryPort(0);
    }

    public int getNameNodePort(int nnIndex) {
        return this.getNN((int)nnIndex).nameNode.getNameNodeAddress().getPort();
    }

    public int getNameNodeAuxiliaryPort(int nnIndex) {
        Set<InetSocketAddress> allAuxiliaryAddresses = this.getNN((int)nnIndex).nameNode.getAuxiliaryNameNodeAddresses();
        if (allAuxiliaryAddresses.isEmpty()) {
            return -1;
        }
        InetSocketAddress addr = allAuxiliaryAddresses.iterator().next();
        return addr.getPort();
    }

    public int getNameNodeServicePort(int nnIndex) {
        return this.getNN((int)nnIndex).nameNode.getServiceRpcAddress().getPort();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean deleteDfsDir) {
        this.shutdown(deleteDfsDir, true);
    }

    public void shutdown(boolean deleteDfsDir, boolean closeFileSystem) {
        LOG.info((Object)"Shutting down the Mini HDFS Cluster");
        if (this.checkExitOnShutdown && ExitUtil.terminateCalled()) {
            LOG.fatal((Object)"Test resulted in an unexpected exit", (Throwable)ExitUtil.getFirstExitException());
            ExitUtil.resetFirstExitException();
            throw new AssertionError((Object)"Test resulted in an unexpected exit");
        }
        if (closeFileSystem) {
            for (FileSystem fs : this.fileSystems) {
                try {
                    fs.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Exception while closing file system", (Throwable)ioe);
                }
            }
            this.fileSystems.clear();
        }
        this.shutdownDataNodes();
        for (NameNodeInfo nnInfo : this.namenodes.values()) {
            if (nnInfo == null) continue;
            this.stopAndJoinNameNode(nnInfo.nameNode);
        }
        ShutdownHookManager.get().clearShutdownHooks();
        if (this.base_dir != null) {
            if (deleteDfsDir) {
                FileUtil.fullyDelete((File)this.base_dir);
            } else {
                FileUtil.fullyDeleteOnExit((File)this.base_dir);
            }
        }
    }

    public void shutdownDataNodes() {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            this.shutdownDataNode(i);
        }
    }

    public void shutdownDataNode(int dnIndex) {
        LOG.info((Object)("Shutting down DataNode " + dnIndex));
        DataNode dn = this.dataNodes.remove((int)dnIndex).datanode;
        dn.shutdown();
        --this.numDataNodes;
    }

    public synchronized void shutdownNameNodes() {
        for (int i = 0; i < this.namenodes.size(); ++i) {
            this.shutdownNameNode(i);
        }
    }

    public synchronized void shutdownNameNode(int nnIndex) {
        NameNodeInfo info = this.getNN(nnIndex);
        this.stopAndJoinNameNode(info.nameNode);
        info.nnId = null;
        info.nameNode = null;
        info.nameserviceId = null;
    }

    private void stopAndJoinNameNode(NameNode nn) {
        if (nn == null) {
            return;
        }
        LOG.info((Object)"Shutting down the namenode");
        nn.stop();
        nn.join();
        nn.joinHttpServer();
    }

    public synchronized void restartNameNodes() throws IOException {
        for (int i = 0; i < this.namenodes.size(); ++i) {
            this.restartNameNode(i, false, new String[0]);
        }
        this.waitActive();
    }

    public synchronized void restartNameNode(String ... args) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, true, args);
    }

    public synchronized void restartNameNode(boolean waitActive) throws IOException {
        this.checkSingleNameNode();
        this.restartNameNode(0, waitActive, new String[0]);
    }

    public synchronized void restartNameNode(int nnIndex) throws IOException {
        this.restartNameNode(nnIndex, true, new String[0]);
    }

    public synchronized void restartNameNode(int nnIndex, boolean waitActive, String ... args) throws IOException {
        NameNode nn;
        NameNodeInfo info = this.getNN(nnIndex);
        HdfsServerConstants.StartupOption startOpt = info.startOpt;
        this.shutdownNameNode(nnIndex);
        if (args.length != 0) {
            startOpt = null;
        } else {
            args = MiniDFSCluster.createArgs(startOpt);
        }
        info.nameNode = nn = NameNode.createNameNode(args, info.conf);
        info.setStartOpt(startOpt);
        if (waitActive) {
            this.waitClusterUp();
            LOG.info((Object)"Restarted the namenode");
            this.waitActive();
        }
    }

    private int corruptBlockOnDataNodesHelper(ExtendedBlock block, boolean deleteBlockFile) throws IOException {
        int blocksCorrupted = 0;
        for (DataNode dn : this.getDataNodes()) {
            try {
                FsDatasetTestUtils.MaterializedReplica replica = this.getFsDatasetTestUtils(dn).getMaterializedReplica(block);
                if (deleteBlockFile) {
                    replica.deleteData();
                } else {
                    replica.corruptData();
                }
                ++blocksCorrupted;
            }
            catch (ReplicaNotFoundException replicaNotFoundException) {}
        }
        return blocksCorrupted;
    }

    public int corruptBlockOnDataNodes(ExtendedBlock block) throws IOException {
        return this.corruptBlockOnDataNodesHelper(block, false);
    }

    public int corruptBlockOnDataNodesByDeletingBlockFile(ExtendedBlock block) throws IOException {
        return this.corruptBlockOnDataNodesHelper(block, true);
    }

    public String readBlockOnDataNode(int i, ExtendedBlock block) throws IOException {
        assert (i >= 0 && i < this.dataNodes.size()) : "Invalid datanode " + i;
        File blockFile = this.getBlockFile(i, block);
        if (blockFile != null && blockFile.exists()) {
            return DFSTestUtil.readFile(blockFile);
        }
        return null;
    }

    public byte[] readBlockOnDataNodeAsBytes(int i, ExtendedBlock block) throws IOException {
        assert (i >= 0 && i < this.dataNodes.size()) : "Invalid datanode " + i;
        File blockFile = this.getBlockFile(i, block);
        if (blockFile != null && blockFile.exists()) {
            return DFSTestUtil.readFileAsBytes(blockFile);
        }
        return null;
    }

    public void corruptReplica(int i, ExtendedBlock blk) throws IOException {
        this.getMaterializedReplica(i, blk).corruptData();
    }

    public void corruptReplica(DataNode dn, ExtendedBlock blk) throws IOException {
        this.getMaterializedReplica(dn, blk).corruptData();
    }

    public void corruptMeta(int i, ExtendedBlock blk) throws IOException {
        this.getMaterializedReplica(i, blk).corruptMeta();
    }

    public void deleteMeta(int i, ExtendedBlock blk) throws IOException {
        this.getMaterializedReplica(i, blk).deleteMeta();
    }

    public void truncateMeta(int i, ExtendedBlock blk, int newSize) throws IOException {
        this.getMaterializedReplica(i, blk).truncateMeta(newSize);
    }

    public void changeGenStampOfBlock(int dnIndex, ExtendedBlock blk, long newGenStamp) throws IOException {
        this.getFsDatasetTestUtils(dnIndex).changeStoredGenerationStamp(blk, newGenStamp);
    }

    public synchronized DataNodeProperties stopDataNode(int i) {
        if (i < 0 || i >= this.dataNodes.size()) {
            return null;
        }
        DataNodeProperties dnprop = this.dataNodes.remove(i);
        DataNode dn = dnprop.datanode;
        LOG.info((Object)("MiniDFSCluster Stopping DataNode " + dn.getDisplayName() + " from a total of " + (this.dataNodes.size() + 1) + " datanodes."));
        dn.shutdown();
        --this.numDataNodes;
        return dnprop;
    }

    public synchronized DataNodeProperties stopDataNode(String dnName) {
        int node = -1;
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode dn = this.dataNodes.get((int)i).datanode;
            if (!dnName.equals(dn.getDatanodeId().getXferAddr())) continue;
            node = i;
            break;
        }
        return this.stopDataNode(node);
    }

    public synchronized boolean restartDataNode(String dnName) throws IOException {
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            DataNode dn = this.dataNodes.get((int)i).datanode;
            if (!dnName.equals(dn.getDatanodeId().getXferAddr())) continue;
            return this.restartDataNode(i);
        }
        return false;
    }

    public synchronized DataNodeProperties stopDataNodeForUpgrade(int i) throws IOException {
        if (i < 0 || i >= this.dataNodes.size()) {
            return null;
        }
        DataNodeProperties dnprop = this.dataNodes.remove(i);
        DataNode dn = dnprop.datanode;
        LOG.info((Object)("MiniDFSCluster Stopping DataNode " + dn.getDisplayName() + " from a total of " + (this.dataNodes.size() + 1) + " datanodes."));
        dn.shutdownDatanode(true);
        --this.numDataNodes;
        return dnprop;
    }

    public boolean restartDataNode(DataNodeProperties dnprop) throws IOException {
        return this.restartDataNode(dnprop, false);
    }

    public void waitDatanodeFullyStarted(final DataNode dn, int timeout) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                return dn.isDatanodeFullyStarted();
            }
        }, 100, timeout);
    }

    private void waitDataNodeFullyStarted(DataNode dn) throws TimeoutException, InterruptedException {
        this.waitDatanodeFullyStarted(dn, 60000);
    }

    public synchronized boolean restartDataNode(DataNodeProperties dnprop, boolean keepPort) throws IOException {
        Configuration conf = dnprop.conf;
        String[] args = dnprop.dnArgs;
        SecureDataNodeStarter.SecureResources secureResources = dnprop.secureResources;
        HdfsConfiguration newconf = new HdfsConfiguration(conf);
        if (keepPort) {
            InetSocketAddress addr = dnprop.datanode.getXferAddress();
            conf.set("dfs.datanode.address", addr.getAddress().getHostAddress() + ":" + addr.getPort());
            conf.set("dfs.datanode.ipc.address", addr.getAddress().getHostAddress() + ":" + dnprop.ipcPort);
        }
        DataNode newDn = DataNode.createDataNode(args, conf, secureResources);
        DataNodeProperties dnp = new DataNodeProperties(newDn, (Configuration)newconf, args, secureResources, newDn.getIpcPort());
        this.dataNodes.add(dnp);
        ++this.numDataNodes;
        this.setDataNodeStorageCapacities(this.dataNodes.lastIndexOf(dnp), newDn, (long[][])this.storageCap.toArray((T[])new long[0][]));
        return true;
    }

    public boolean restartDataNode(int i) throws IOException {
        return this.restartDataNode(i, false);
    }

    public synchronized boolean restartDataNode(int i, boolean keepPort) throws IOException {
        return this.restartDataNode(i, keepPort, false);
    }

    public synchronized boolean restartDataNode(int idn, boolean keepPort, boolean expireOnNN) throws IOException {
        DataNodeProperties dnprop = this.stopDataNode(idn);
        if (expireOnNN) {
            this.setDataNodeDead(dnprop.datanode.getDatanodeId());
        }
        if (dnprop == null) {
            return false;
        }
        return this.restartDataNode(dnprop, keepPort);
    }

    public void setDataNodeDead(DatanodeID dnId) throws IOException {
        DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(this.getNamesystem(), dnId);
        DFSTestUtil.setDatanodeDead(dnd);
        BlockManagerTestUtil.checkHeartbeat(this.getNamesystem().getBlockManager());
    }

    public void setDataNodesDead() throws IOException {
        for (DataNodeProperties dnp : this.dataNodes) {
            this.setDataNodeDead(dnp.datanode.getDatanodeId());
        }
    }

    public synchronized boolean restartDataNodes(boolean keepPort) throws IOException {
        for (int i = this.dataNodes.size() - 1; i >= 0; --i) {
            if (!this.restartDataNode(i, keepPort)) {
                return false;
            }
            LOG.info((Object)("Restarted DataNode " + i));
        }
        return true;
    }

    public boolean restartDataNodes() throws IOException {
        return this.restartDataNodes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNameNodeUp(int nnIndex) {
        NameNode nameNode = this.getNN((int)nnIndex).nameNode;
        if (nameNode == null) {
            return false;
        }
        long[] sizes = NameNodeAdapter.getStats(nameNode.getNamesystem());
        boolean isUp = false;
        MiniDFSCluster miniDFSCluster = this;
        synchronized (miniDFSCluster) {
            isUp = (!nameNode.isInSafeMode() || !this.waitSafeMode) && sizes[0] != 0L;
        }
        return isUp;
    }

    public boolean isClusterUp() {
        for (int index = 0; index < this.namenodes.size(); ++index) {
            if (this.isNameNodeUp(index)) continue;
            return false;
        }
        return true;
    }

    public boolean isDataNodeUp() {
        if (this.dataNodes == null || this.dataNodes.size() == 0) {
            return false;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (!dn.datanode.isDatanodeUp()) continue;
            return true;
        }
        return false;
    }

    public DistributedFileSystem getFileSystem() throws IOException {
        this.checkSingleNameNode();
        return this.getFileSystem(0);
    }

    public DistributedFileSystem getFileSystemFromAuxiliaryPort() throws IOException {
        this.checkSingleNameNode();
        return this.getFileSystemFromAuxiliaryPort(0);
    }

    public DistributedFileSystem getFileSystem(int nnIndex) throws IOException {
        return (DistributedFileSystem)this.addFileSystem(FileSystem.get((URI)this.getURI(nnIndex), (Configuration)this.getNN((int)nnIndex).conf));
    }

    public DistributedFileSystem getFileSystemFromAuxiliaryPort(int nnIndex) throws IOException {
        return (DistributedFileSystem)this.addFileSystem(FileSystem.get((URI)this.getURIForAuxiliaryPort(nnIndex), (Configuration)this.getNN((int)nnIndex).conf));
    }

    public FileSystem getNewFileSystemInstance(int nnIndex) throws IOException {
        return this.addFileSystem(FileSystem.newInstance((URI)this.getURI(nnIndex), (Configuration)this.getNN((int)nnIndex).conf));
    }

    private <T extends FileSystem> T addFileSystem(T fs) {
        this.fileSystems.add(fs);
        return fs;
    }

    public String getHttpUri(int nnIndex) {
        return "http://" + this.getNN((int)nnIndex).conf.get("dfs.namenode.http-address");
    }

    public Collection<URI> getNameDirs(int nnIndex) {
        return FSNamesystem.getNamespaceDirs(this.getNN((int)nnIndex).conf);
    }

    public Collection<URI> getNameEditsDirs(int nnIndex) throws IOException {
        return FSNamesystem.getNamespaceEditsDirs(this.getNN((int)nnIndex).conf);
    }

    public void transitionToActive(int nnIndex) throws IOException, ServiceFailedException {
        this.getNameNode(nnIndex).getRpcServer().transitionToActive(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
    }

    public void transitionToStandby(int nnIndex) throws IOException, ServiceFailedException {
        this.getNameNode(nnIndex).getRpcServer().transitionToStandby(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
    }

    public void transitionToObserver(int nnIndex) throws IOException, ServiceFailedException {
        this.getNameNode(nnIndex).getRpcServer().transitionToObserver(new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER_FORCED));
    }

    public void rollEditLogAndTail(int nnIndex) throws Exception {
        this.getNameNode(nnIndex).getRpcServer().rollEditLog();
        for (int i = 2; i < this.getNumNameNodes(); ++i) {
            this.getNameNode(i).getNamesystem().getEditLogTailer().doTailEdits();
        }
    }

    public void triggerBlockReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerBlockReport(dn);
        }
    }

    public void triggerDeletionReports() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerDeletionReport(dn);
        }
    }

    public void triggerHeartbeats() throws IOException {
        for (DataNode dn : this.getDataNodes()) {
            DataNodeTestUtils.triggerHeartbeat(dn);
        }
    }

    public void waitActive(int nnIndex) throws IOException {
        if (this.namenodes.size() == 0 || this.getNN(nnIndex) == null || this.getNN((int)nnIndex).nameNode == null) {
            return;
        }
        NameNodeInfo info = this.getNN(nnIndex);
        InetSocketAddress addr = info.nameNode.getServiceRpcAddress();
        assert (addr.getPort() != 0);
        DFSClient client = new DFSClient(addr, this.conf);
        while (this.shouldWait(client.datanodeReport(HdfsConstants.DatanodeReportType.LIVE), addr)) {
            try {
                LOG.info((Object)"Waiting for cluster to become active");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        client.close();
    }

    public void waitFirstBRCompleted(int nnIndex, int timeout) throws IOException, TimeoutException, InterruptedException {
        if (this.namenodes.size() == 0 || this.getNN(nnIndex) == null || this.getNN((int)nnIndex).nameNode == null) {
            return;
        }
        FSNamesystem ns = this.getNamesystem(nnIndex);
        final DatanodeManager dm = ns.getBlockManager().getDatanodeManager();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            public Boolean get() {
                List<DatanodeDescriptor> nodes = dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE);
                for (DatanodeDescriptor node : nodes) {
                    if (node.checkBlockReportReceived()) continue;
                    return false;
                }
                return true;
            }
        }, 100, timeout);
    }

    public void waitActive() throws IOException {
        block2: for (int index = 0; index < this.namenodes.size(); ++index) {
            int failedCount = 0;
            while (true) {
                try {
                    this.waitActive(index);
                    continue block2;
                }
                catch (IOException e) {
                    if (++failedCount <= 1) continue;
                    LOG.warn((Object)("Tried waitActive() " + failedCount + " time(s) and failed, giving up.  " + StringUtils.stringifyException((Throwable)e)));
                    throw e;
                }
                break;
            }
        }
        LOG.info((Object)"Cluster is active");
    }

    public void printNNs() {
        for (int i = 0; i < this.namenodes.size(); ++i) {
            LOG.info((Object)("Have namenode " + i + ", info:" + this.getNN(i)));
            LOG.info((Object)(" has namenode: " + this.getNN((int)i).nameNode));
        }
    }

    private synchronized boolean shouldWait(DatanodeInfo[] dnInfo, InetSocketAddress addr) {
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isConnectedToNN(addr)) continue;
            LOG.warn((Object)("BPOfferService in datanode " + dn.datanode + " failed to connect to namenode at " + addr));
            return false;
        }
        if (dnInfo.length != this.numDataNodes) {
            LOG.info((Object)"dnInfo.length != numDataNodes");
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (dn.datanode.isDatanodeFullyStarted()) continue;
            LOG.info((Object)"!dn.datanode.isDatanodeFullyStarted()");
            return true;
        }
        for (DatanodeInfo dn : dnInfo) {
            if (dn.getCapacity() != 0L && dn.getLastUpdate() > 0L) continue;
            LOG.info((Object)("No heartbeat from DataNode: " + dn.toString()));
            return true;
        }
        for (DataNodeProperties dn : this.dataNodes) {
            if (DataNodeTestUtils.getFSDataset(dn.datanode) != null) continue;
            LOG.info((Object)"DataNodeTestUtils.getFSDataset(dn.datanode) == null");
            return true;
        }
        return false;
    }

    public void formatDataNodeDirs() throws IOException {
        this.base_dir = new File(this.determineDfsBaseDir());
        this.data_dir = new File(this.base_dir, "data");
        if (this.data_dir.exists() && !FileUtil.fullyDelete((File)this.data_dir)) {
            throw new IOException("Cannot remove data directory: " + this.data_dir);
        }
    }

    public Map<DatanodeStorage, BlockListAsLongs> getBlockReport(String bpid, int dataNodeIndex) {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        return DataNodeTestUtils.getFSDataset(dn).getBlockReports(bpid);
    }

    public List<Map<DatanodeStorage, BlockListAsLongs>> getAllBlockReports(String bpid) {
        int numDataNodes = this.dataNodes.size();
        ArrayList<Map<DatanodeStorage, BlockListAsLongs>> result = new ArrayList<Map<DatanodeStorage, BlockListAsLongs>>(numDataNodes);
        for (int i = 0; i < numDataNodes; ++i) {
            result.add(this.getBlockReport(bpid, i));
        }
        return result;
    }

    public void injectBlocks(int dataNodeIndex, Iterable<Block> blocksToInject, String bpid) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimulatedFSDataset");
        }
        if (bpid == null) {
            bpid = this.getNamesystem().getBlockPoolId();
        }
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void injectBlocks(int nameNodeIndex, int dataNodeIndex, Iterable<Block> blocksToInject) throws IOException {
        if (dataNodeIndex < 0 || dataNodeIndex > this.dataNodes.size()) {
            throw new IndexOutOfBoundsException();
        }
        DataNode dn = this.dataNodes.get((int)dataNodeIndex).datanode;
        FsDatasetSpi<?> dataSet = DataNodeTestUtils.getFSDataset(dn);
        if (!(dataSet instanceof SimulatedFSDataset)) {
            throw new IOException("injectBlocks is valid only for SimulatedFSDataset");
        }
        String bpid = this.getNamesystem(nameNodeIndex).getBlockPoolId();
        SimulatedFSDataset sdataset = (SimulatedFSDataset)dataSet;
        sdataset.injectBlocks(bpid, blocksToInject);
        this.dataNodes.get((int)dataNodeIndex).datanode.scheduleAllBlockReport(0L);
    }

    public void setLeasePeriod(long soft, long hard) {
        NameNodeAdapter.setLeasePeriod(this.getNamesystem(), soft, hard);
    }

    public void setLeasePeriod(long soft, long hard, int nnIndex) {
        NameNodeAdapter.setLeasePeriod(this.getNamesystem(nnIndex), soft, hard);
    }

    public void setWaitSafeMode(boolean wait) {
        this.waitSafeMode = wait;
    }

    DataNode[] listDataNodes() {
        DataNode[] list = new DataNode[this.dataNodes.size()];
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            list[i] = this.dataNodes.get((int)i).datanode;
        }
        return list;
    }

    public String getDataDirectory() {
        return this.data_dir.getAbsolutePath();
    }

    protected String determineDfsBaseDir() {
        String dfsdir;
        if (this.conf != null && (dfsdir = this.conf.get(HDFS_MINIDFS_BASEDIR, null)) != null) {
            return dfsdir;
        }
        return MiniDFSCluster.getBaseDirectory();
    }

    public static String getBaseDirectory() {
        return GenericTestUtils.getTestDir("dfs").getAbsolutePath() + File.separator;
    }

    public File getInstanceStorageDir(int dnIndex, int dirIndex) {
        return new File(this.base_dir, this.getStorageDirPath(dnIndex, dirIndex));
    }

    public File getProvidedStorageDir(int dnIndex, int dirIndex) {
        String base = this.conf.get(HDFS_MINIDFS_BASEDIR_PROVIDED, null);
        if (base == null) {
            return this.getInstanceStorageDir(dnIndex, dirIndex);
        }
        return new File(base);
    }

    public File getStorageDir(int dnIndex, int dirIndex) {
        return new File(this.determineDfsBaseDir(), this.getStorageDirPath(dnIndex, dirIndex));
    }

    private String getStorageDirPath(int dnIndex, int dirIndex) {
        return "data/data" + (this.storagesPerDatanode * dnIndex + 1 + dirIndex);
    }

    public static String getDNCurrentDir(File storageDir) {
        return storageDir + "/" + "current" + "/";
    }

    public static String getBPDir(File storageDir, String bpid) {
        return MiniDFSCluster.getDNCurrentDir(storageDir) + bpid + "/";
    }

    public static String getBPDir(File storageDir, String bpid, String dirName) {
        return MiniDFSCluster.getBPDir(storageDir, bpid) + dirName + "/";
    }

    public static File getRbwDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "rbw");
    }

    public static File getFinalizedDir(File storageDir, String bpid) {
        return new File(MiniDFSCluster.getBPDir(storageDir, bpid, "current") + "finalized");
    }

    public FsDatasetTestUtils.MaterializedReplica getMaterializedReplica(int i, ExtendedBlock blk) throws ReplicaNotFoundException {
        return this.getFsDatasetTestUtils(i).getMaterializedReplica(blk);
    }

    public FsDatasetTestUtils.MaterializedReplica getMaterializedReplica(DataNode dn, ExtendedBlock blk) throws ReplicaNotFoundException {
        return this.getFsDatasetTestUtils(dn).getMaterializedReplica(blk);
    }

    public static File getBlockFile(File storageDir, ExtendedBlock blk) {
        return new File(DatanodeUtil.idToBlockDir(MiniDFSCluster.getFinalizedDir(storageDir, blk.getBlockPoolId()), blk.getBlockId()), blk.getBlockName());
    }

    public static List<File> getAllBlockFiles(File storageDir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = storageDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            List<File> subdirResults;
            if (f.getName().startsWith("blk_") && !f.getName().endsWith(".meta")) {
                results.add(f);
                continue;
            }
            if (!f.isDirectory() || (subdirResults = MiniDFSCluster.getAllBlockFiles(f)) == null) continue;
            results.addAll(subdirResults);
        }
        return results;
    }

    public static File getBlockMetadataFile(File storageDir, ExtendedBlock blk) {
        return new File(DatanodeUtil.idToBlockDir(MiniDFSCluster.getFinalizedDir(storageDir, blk.getBlockPoolId()), blk.getBlockId()), blk.getBlockName() + "_" + blk.getGenerationStamp() + ".meta");
    }

    public static List<File> getAllBlockMetadataFiles(File storageDir) {
        ArrayList<File> results = new ArrayList<File>();
        File[] files = storageDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File f : files) {
            List<File> subdirResults;
            if (f.getName().startsWith("blk_") && f.getName().endsWith(".meta")) {
                results.add(f);
                continue;
            }
            if (!f.isDirectory() || (subdirResults = MiniDFSCluster.getAllBlockMetadataFiles(f)) == null) continue;
            results.addAll(subdirResults);
        }
        return results;
    }

    public static void shutdownCluster(MiniDFSCluster cluster) {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public File[] getAllBlockFiles(ExtendedBlock block) {
        if (this.dataNodes.size() == 0) {
            return new File[0];
        }
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this.dataNodes.size(); ++i) {
            File blockFile = this.getBlockFile(i, block);
            if (blockFile == null) continue;
            list.add(blockFile);
        }
        return list.toArray(new File[list.size()]);
    }

    public File getBlockFile(int dnIndex, ExtendedBlock block) {
        for (int i = 0; i <= 1; ++i) {
            File storageDir = this.getStorageDir(dnIndex, i);
            File blockFile = MiniDFSCluster.getBlockFile(storageDir, block);
            if (!blockFile.exists()) continue;
            return blockFile;
        }
        return null;
    }

    public File getBlockMetadataFile(int dnIndex, ExtendedBlock block) {
        for (int i = 0; i <= 1; ++i) {
            File storageDir = this.getStorageDir(dnIndex, i);
            File blockMetaFile = MiniDFSCluster.getBlockMetadataFile(storageDir, block);
            if (!blockMetaFile.exists()) continue;
            return blockMetaFile;
        }
        return null;
    }

    private void checkSingleNameNode() {
        if (this.namenodes.size() != 1) {
            throw new IllegalArgumentException("Namenode index is needed");
        }
    }

    public void addNameNode(Configuration conf, int namenodePort) throws IOException {
        if (!this.federation) {
            throw new IOException("cannot add namenode to non-federated cluster");
        }
        int nameServiceIndex = this.namenodes.keys().size();
        String nameserviceId = NAMESERVICE_ID_PREFIX + (this.namenodes.keys().size() + 1);
        String nameserviceIds = conf.get("dfs.nameservices");
        nameserviceIds = nameserviceIds + "," + nameserviceId;
        conf.set("dfs.nameservices", nameserviceIds);
        String nnId = null;
        MiniDFSCluster.initNameNodeAddress(conf, nameserviceId, new MiniDFSNNTopology.NNConf(nnId).setIpcPort(namenodePort));
        NameNodeInfo[] infos = this.getNameNodeInfos(nameserviceId);
        int nnIndex = infos == null ? 0 : infos.length;
        this.initNameNodeConf(conf, nameserviceId, nameServiceIndex, nnId, true, true, nnIndex);
        this.createNameNode(conf, true, null, null, nameserviceId, nnId);
        for (DataNodeProperties dn : this.dataNodes) {
            DataNode datanode = dn.datanode;
            datanode.refreshNamenodes(conf);
        }
        this.waitActive(nnIndex);
    }

    public void setBlockRecoveryTimeout(long timeout) {
        for (int nnIndex = 0; nnIndex < this.getNumNameNodes(); ++nnIndex) {
            this.getNamesystem(nnIndex).getBlockManager().setBlockRecoveryTimeout(timeout);
        }
    }

    protected void setupDatanodeAddress(Configuration conf, boolean setupHostsFile, boolean checkDataNodeAddrConfig) throws IOException {
        if (setupHostsFile) {
            String hostsFile = conf.get("dfs.hosts", "").trim();
            if (hostsFile.length() == 0) {
                throw new IOException("Parameter dfs.hosts is not setup in conf");
            }
            String address = "127.0.0.1:" + NetUtils.getFreeSocketPort();
            if (checkDataNodeAddrConfig) {
                conf.setIfUnset("dfs.datanode.address", address);
            } else {
                conf.set("dfs.datanode.address", address);
            }
            this.addToFile(hostsFile, address);
            LOG.info((Object)("Adding datanode " + address + " to hosts file " + hostsFile));
        } else if (checkDataNodeAddrConfig) {
            conf.setIfUnset("dfs.datanode.address", "127.0.0.1:0");
        } else {
            conf.set("dfs.datanode.address", "127.0.0.1:0");
        }
        if (checkDataNodeAddrConfig) {
            conf.setIfUnset("dfs.datanode.http.address", "127.0.0.1:0");
            conf.setIfUnset("dfs.datanode.ipc.address", "127.0.0.1:0");
        } else {
            conf.set("dfs.datanode.http.address", "127.0.0.1:0");
            conf.set("dfs.datanode.ipc.address", "127.0.0.1:0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFile(String p, String address) throws IOException {
        File f = new File(p);
        f.createNewFile();
        try (PrintWriter writer = new PrintWriter(new FileWriter(f, true));){
            writer.println(address);
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        instanceCount = 0;
    }

    public static class NameNodeInfo {
        public NameNode nameNode;
        Configuration conf;
        String nameserviceId;
        String nnId;
        HdfsServerConstants.StartupOption startOpt;

        NameNodeInfo(NameNode nn, String nameserviceId, String nnId, HdfsServerConstants.StartupOption startOpt, Configuration conf) {
            this.nameNode = nn;
            this.nameserviceId = nameserviceId;
            this.nnId = nnId;
            this.startOpt = startOpt;
            this.conf = conf;
        }

        public void setStartOpt(HdfsServerConstants.StartupOption startOpt) {
            this.startOpt = startOpt;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.nnId;
        }
    }

    public class DataNodeProperties {
        final DataNode datanode;
        final Configuration conf;
        String[] dnArgs;
        final SecureDataNodeStarter.SecureResources secureResources;
        final int ipcPort;

        DataNodeProperties(DataNode node, Configuration conf, String[] args, SecureDataNodeStarter.SecureResources secureResources, int ipcPort) {
            this.datanode = node;
            this.conf = conf;
            this.dnArgs = args;
            this.secureResources = secureResources;
            this.ipcPort = ipcPort;
        }

        public void setDnArgs(String ... args) {
            this.dnArgs = args;
        }

        public DataNode getDatanode() {
            return this.datanode;
        }
    }

    public static class Builder {
        private int nameNodePort = 0;
        private int nameNodeHttpPort = 0;
        private final Configuration conf;
        private int numDataNodes = 1;
        private StorageType[][] storageTypes = null;
        private StorageType[] storageTypes1D = null;
        private int storagesPerDatanode = 2;
        private boolean format = true;
        private boolean manageNameDfsDirs = true;
        private boolean manageNameDfsSharedDirs = true;
        private boolean enableManagedDfsDirsRedundancy = true;
        private boolean manageDataDfsDirs = true;
        private HdfsServerConstants.StartupOption option = null;
        private HdfsServerConstants.StartupOption dnOption = null;
        private String[] racks = null;
        private String[] hosts = null;
        private long[] simulatedCapacities = null;
        private long[][] storageCapacities = null;
        private long[] storageCapacities1D = null;
        private String clusterId = null;
        private boolean waitSafeMode = true;
        private boolean setupHostsFile = false;
        private MiniDFSNNTopology nnTopology = null;
        private boolean checkExitOnShutdown = true;
        private boolean checkDataNodeAddrConfig = false;
        private boolean checkDataNodeHostConfig = false;
        private Configuration[] dnConfOverlays;
        private boolean skipFsyncForTesting = true;
        private boolean useConfiguredTopologyMappingClass = false;

        public Builder(Configuration conf) {
            this.conf = conf;
            this.storagesPerDatanode = FsDatasetTestUtils.Factory.getFactory(conf).getDefaultNumOfDataDirs();
            if (null == conf.get(MiniDFSCluster.HDFS_MINIDFS_BASEDIR)) {
                conf.set(MiniDFSCluster.HDFS_MINIDFS_BASEDIR, new File(MiniDFSCluster.getBaseDirectory()).getAbsolutePath());
            }
        }

        public Builder(Configuration conf, File basedir) {
            this.conf = conf;
            this.storagesPerDatanode = FsDatasetTestUtils.Factory.getFactory(conf).getDefaultNumOfDataDirs();
            if (null == basedir) {
                throw new IllegalArgumentException("MiniDFSCluster base directory cannot be null");
            }
            String cdir = conf.get(MiniDFSCluster.HDFS_MINIDFS_BASEDIR);
            if (cdir != null) {
                throw new IllegalArgumentException("MiniDFSCluster base directory already defined (" + cdir + ")");
            }
            conf.set(MiniDFSCluster.HDFS_MINIDFS_BASEDIR, basedir.getAbsolutePath());
        }

        public Builder nameNodePort(int val) {
            this.nameNodePort = val;
            return this;
        }

        public Builder nameNodeHttpPort(int val) {
            this.nameNodeHttpPort = val;
            return this;
        }

        public Builder numDataNodes(int val) {
            this.numDataNodes = val;
            return this;
        }

        public Builder storagesPerDatanode(int numStorages) {
            this.storagesPerDatanode = numStorages;
            return this;
        }

        public Builder storageTypes(StorageType[] types) {
            this.storageTypes1D = types;
            return this;
        }

        public Builder storageTypes(StorageType[][] types) {
            this.storageTypes = types;
            return this;
        }

        public Builder storageCapacities(long[] capacities) {
            this.storageCapacities1D = capacities;
            return this;
        }

        public Builder storageCapacities(long[][] capacities) {
            this.storageCapacities = capacities;
            return this;
        }

        public Builder format(boolean val) {
            this.format = val;
            return this;
        }

        public Builder manageNameDfsDirs(boolean val) {
            this.manageNameDfsDirs = val;
            return this;
        }

        public Builder manageNameDfsSharedDirs(boolean val) {
            this.manageNameDfsSharedDirs = val;
            return this;
        }

        public Builder enableManagedDfsDirsRedundancy(boolean val) {
            this.enableManagedDfsDirsRedundancy = val;
            return this;
        }

        public Builder manageDataDfsDirs(boolean val) {
            this.manageDataDfsDirs = val;
            return this;
        }

        public Builder startupOption(HdfsServerConstants.StartupOption val) {
            this.option = val;
            return this;
        }

        public Builder dnStartupOption(HdfsServerConstants.StartupOption val) {
            this.dnOption = val;
            return this;
        }

        public Builder racks(String[] val) {
            this.racks = val;
            return this;
        }

        public Builder hosts(String[] val) {
            this.hosts = val;
            return this;
        }

        public Builder simulatedCapacities(long[] val) {
            this.simulatedCapacities = val;
            return this;
        }

        public Builder waitSafeMode(boolean val) {
            this.waitSafeMode = val;
            return this;
        }

        public Builder checkExitOnShutdown(boolean val) {
            this.checkExitOnShutdown = val;
            return this;
        }

        public Builder checkDataNodeAddrConfig(boolean val) {
            this.checkDataNodeAddrConfig = val;
            return this;
        }

        public Builder checkDataNodeHostConfig(boolean val) {
            this.checkDataNodeHostConfig = val;
            return this;
        }

        public Builder clusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setupHostsFile(boolean val) {
            this.setupHostsFile = val;
            return this;
        }

        public Builder nnTopology(MiniDFSNNTopology topology) {
            this.nnTopology = topology;
            return this;
        }

        public Builder dataNodeConfOverlays(Configuration[] dnConfOverlays) {
            this.dnConfOverlays = dnConfOverlays;
            return this;
        }

        public Builder skipFsyncForTesting(boolean val) {
            this.skipFsyncForTesting = val;
            return this;
        }

        public Builder useConfiguredTopologyMappingClass(boolean useConfiguredTopologyMappingClass) {
            this.useConfiguredTopologyMappingClass = useConfiguredTopologyMappingClass;
            return this;
        }

        public MiniDFSCluster build() throws IOException {
            return new MiniDFSCluster(this);
        }

        static /* synthetic */ StorageType[][] access$302(Builder x0, StorageType[][] x1) {
            x0.storageTypes = x1;
            return x1;
        }

        static /* synthetic */ long[][] access$702(Builder x0, long[][] x1) {
            x0.storageCapacities = x1;
            return x1;
        }
    }
}

