/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServiceProtocol;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppActivitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppTimeoutsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationStatisticsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterUserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.RMQueueAclInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationDeleteRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationSubmissionRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ReservationUpdateRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.RESTRequestInterceptor;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/cluster")
public class RouterWebServices
implements RMWebServiceProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterWebServices.class);
    private final Router router;
    private final Configuration conf;
    @Context
    private HttpServletResponse response;
    private Map<String, RequestInterceptorChainWrapper> userPipelineMap;
    public static final String DEFAULT_QUEUE = "default";
    public static final String DEFAULT_RESERVATION_ID = "";
    public static final String DEFAULT_START_TIME = "0";
    public static final String DEFAULT_END_TIME = "-1";
    public static final String DEFAULT_INCLUDE_RESOURCE = "false";

    @Inject
    public RouterWebServices(Router router, Configuration conf) {
        this.router = router;
        this.conf = conf;
        int maxCacheSize = conf.getInt("yarn.router.pipeline.cache-max-size", 25);
        this.userPipelineMap = Collections.synchronizedMap(new LRUCacheHashMap(maxCacheSize, true));
    }

    private List<String> getInterceptorClassNames(Configuration config) {
        String configuredInterceptorClassNames = config.get("yarn.router.webapp.interceptor-class.pipeline", "org.apache.hadoop.yarn.server.router.webapp.DefaultRequestInterceptorREST");
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        Collection tempList = StringUtils.getStringCollection((String)configuredInterceptorClassNames);
        for (String item : tempList) {
            interceptorClassNames.add(item.trim());
        }
        return interceptorClassNames;
    }

    private void init() {
        this.response.setContentType(null);
    }

    @VisibleForTesting
    protected RequestInterceptorChainWrapper getInterceptorChain(HttpServletRequest hsr) {
        String user = DEFAULT_RESERVATION_ID;
        if (hsr != null) {
            user = hsr.getRemoteUser();
        }
        try {
            if (user == null || user.equals(DEFAULT_RESERVATION_ID)) {
                user = UserGroupInformation.getCurrentUser().getUserName();
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get user: {}", (Object)e.getMessage());
        }
        if (!this.userPipelineMap.containsKey(user)) {
            this.initializePipeline(user);
        }
        return this.userPipelineMap.get(user);
    }

    @VisibleForTesting
    protected Map<String, RequestInterceptorChainWrapper> getPipelines() {
        return this.userPipelineMap;
    }

    @VisibleForTesting
    protected RESTRequestInterceptor createRequestInterceptorChain() {
        List<String> interceptorClassNames = this.getInterceptorClassNames(this.conf);
        RESTRequestInterceptor pipeline = null;
        RESTRequestInterceptor current = null;
        for (String interceptorClassName : interceptorClassNames) {
            try {
                Class interceptorClass = this.conf.getClassByName(interceptorClassName);
                if (RESTRequestInterceptor.class.isAssignableFrom(interceptorClass)) {
                    RESTRequestInterceptor interceptorInstance = (RESTRequestInterceptor)ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)this.conf);
                    if (pipeline == null) {
                        pipeline = interceptorInstance;
                        current = interceptorInstance;
                        continue;
                    }
                    current.setNextInterceptor(interceptorInstance);
                    current = interceptorInstance;
                    continue;
                }
                throw new YarnRuntimeException("Class: " + interceptorClassName + " not instance of " + RESTRequestInterceptor.class.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Could not instantiate RESTRequestInterceptor: " + interceptorClassName, (Throwable)e);
            }
        }
        if (pipeline == null) {
            throw new YarnRuntimeException("RequestInterceptor pipeline is not configured in the system");
        }
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePipeline(String user) {
        RequestInterceptorChainWrapper chainWrapper = null;
        Map<String, RequestInterceptorChainWrapper> map = this.userPipelineMap;
        synchronized (map) {
            if (this.userPipelineMap.containsKey(user)) {
                LOG.info("Request to start an already existing user: {} was received, so ignoring.", (Object)user);
                return;
            }
            chainWrapper = new RequestInterceptorChainWrapper();
            this.userPipelineMap.put(user, chainWrapper);
        }
        LOG.info("Initializing request processing pipeline for the user: {}", (Object)user);
        try {
            RESTRequestInterceptor interceptorChain = this.createRequestInterceptorChain();
            interceptorChain.init(user);
            chainWrapper.init(interceptorChain);
        }
        catch (Exception e) {
            Map<String, RequestInterceptorChainWrapper> map2 = this.userPipelineMap;
            synchronized (map2) {
                this.userPipelineMap.remove(user);
            }
            throw e;
        }
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterInfo get() {
        return this.getClusterInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterInfo getClusterInfo() {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getClusterInfo();
    }

    @GET
    @Path(value="/userinfo")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterUserInfo getClusterUserInfo(@Context HttpServletRequest hsr) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getClusterUserInfo(hsr);
    }

    @GET
    @Path(value="/metrics")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ClusterMetricsInfo getClusterMetricsInfo() {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getClusterMetricsInfo();
    }

    @GET
    @Path(value="/scheduler")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public SchedulerTypeInfo getSchedulerInfo() {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getSchedulerInfo();
    }

    @POST
    @Path(value="/scheduler/logs")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public String dumpSchedulerLogs(@FormParam(value="time") String time, @Context HttpServletRequest hsr) throws IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().dumpSchedulerLogs(time, hsr);
    }

    @GET
    @Path(value="/nodes")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodesInfo getNodes(@QueryParam(value="states") String states) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getNodes(states);
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeInfo getNode(@PathParam(value="nodeId") String nodeId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getNode(nodeId);
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest hsr, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes, @QueryParam(value="applicationTags") Set<String> applicationTags, @QueryParam(value="deSelects") Set<String> unselectedFields) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getApps(hsr, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes, applicationTags, unselectedFields);
    }

    @GET
    @Path(value="/scheduler/activities")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ActivitiesInfo getActivities(@Context HttpServletRequest hsr, @QueryParam(value="nodeId") String nodeId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getActivities(hsr, nodeId);
    }

    @GET
    @Path(value="/scheduler/app-activities")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppActivitiesInfo getAppActivities(@Context HttpServletRequest hsr, @QueryParam(value="appId") String appId, @QueryParam(value="maxTime") String time) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppActivities(hsr, appId, time);
    }

    @GET
    @Path(value="/appstatistics")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ApplicationStatisticsInfo getAppStatistics(@Context HttpServletRequest hsr, @QueryParam(value="states") Set<String> stateQueries, @QueryParam(value="applicationTypes") Set<String> typeQueries) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppStatistics(hsr, stateQueries, typeQueries);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId, @QueryParam(value="deSelects") Set<String> unselectedFields) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getApp(hsr, appId, unselectedFields);
    }

    @GET
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppState getAppState(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppState(hsr, appId);
    }

    @PUT
    @Path(value="/apps/{appid}/state")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response updateAppState(AppState targetState, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().updateAppState(targetState, hsr, appId);
    }

    @GET
    @Path(value="/get-node-to-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeToLabelsInfo getNodeToLabels(@Context HttpServletRequest hsr) throws IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getNodeToLabels(hsr);
    }

    @GET
    @Path(value="/label-mappings")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public LabelsToNodesInfo getLabelsToNodes(@QueryParam(value="labels") Set<String> labels) throws IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(null);
        return pipeline.getRootInterceptor().getLabelsToNodes(labels);
    }

    @POST
    @Path(value="/replace-node-to-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response replaceLabelsOnNodes(NodeToLabelsEntryList newNodeToLabels, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().replaceLabelsOnNodes(newNodeToLabels, hsr);
    }

    @POST
    @Path(value="/nodes/{nodeId}/replace-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response replaceLabelsOnNode(@QueryParam(value="labels") Set<String> newNodeLabelsName, @Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().replaceLabelsOnNode(newNodeLabelsName, hsr, nodeId);
    }

    @GET
    @Path(value="/get-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeLabelsInfo getClusterNodeLabels(@Context HttpServletRequest hsr) throws IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getClusterNodeLabels(hsr);
    }

    @POST
    @Path(value="/add-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response addToClusterNodeLabels(NodeLabelsInfo newNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().addToClusterNodeLabels(newNodeLabels, hsr);
    }

    @POST
    @Path(value="/remove-node-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response removeFromCluserNodeLabels(@QueryParam(value="labels") Set<String> oldNodeLabels, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().removeFromCluserNodeLabels(oldNodeLabels, hsr);
    }

    @GET
    @Path(value="/nodes/{nodeId}/get-labels")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public NodeLabelsInfo getLabelsOnNode(@Context HttpServletRequest hsr, @PathParam(value="nodeId") String nodeId) throws IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getLabelsOnNode(hsr, nodeId);
    }

    @GET
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppPriority getAppPriority(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppPriority(hsr, appId);
    }

    @PUT
    @Path(value="/apps/{appid}/priority")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response updateApplicationPriority(AppPriority targetPriority, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().updateApplicationPriority(targetPriority, hsr, appId);
    }

    @GET
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppQueue getAppQueue(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppQueue(hsr, appId);
    }

    @PUT
    @Path(value="/apps/{appid}/queue")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response updateAppQueue(AppQueue targetQueue, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().updateAppQueue(targetQueue, hsr, appId);
    }

    @POST
    @Path(value="/apps/new-application")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response createNewApplication(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().createNewApplication(hsr);
    }

    @POST
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response submitApplication(ApplicationSubmissionContextInfo newApp, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().submitApplication(newApp, hsr);
    }

    @POST
    @Path(value="/delegation-token")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response postDelegationToken(DelegationToken tokenData, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().postDelegationToken(tokenData, hsr);
    }

    @POST
    @Path(value="/delegation-token/expiration")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response postDelegationTokenExpiration(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().postDelegationTokenExpiration(hsr);
    }

    @DELETE
    @Path(value="/delegation-token")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response cancelDelegationToken(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException, Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().cancelDelegationToken(hsr);
    }

    @POST
    @Path(value="/reservation/new-reservation")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response createNewReservation(@Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().createNewReservation(hsr);
    }

    @POST
    @Path(value="/reservation/submit")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response submitReservation(ReservationSubmissionRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().submitReservation(resContext, hsr);
    }

    @POST
    @Path(value="/reservation/update")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response updateReservation(ReservationUpdateRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().updateReservation(resContext, hsr);
    }

    @POST
    @Path(value="/reservation/delete")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response deleteReservation(ReservationDeleteRequestInfo resContext, @Context HttpServletRequest hsr) throws AuthorizationException, IOException, InterruptedException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().deleteReservation(resContext, hsr);
    }

    @GET
    @Path(value="/reservation/list")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response listReservation(@QueryParam(value="queue") @DefaultValue(value="default") String queue, @QueryParam(value="reservation-id") @DefaultValue(value="") String reservationId, @QueryParam(value="start-time") @DefaultValue(value="0") long startTime, @QueryParam(value="end-time") @DefaultValue(value="-1") long endTime, @QueryParam(value="include-resource-allocations") @DefaultValue(value="false") boolean includeResourceAllocations, @Context HttpServletRequest hsr) throws Exception {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().listReservation(queue, reservationId, startTime, endTime, includeResourceAllocations, hsr);
    }

    @GET
    @Path(value="/apps/{appid}/timeouts/{type}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppTimeoutInfo getAppTimeout(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId, @PathParam(value="type") String type) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppTimeout(hsr, appId, type);
    }

    @GET
    @Path(value="/apps/{appid}/timeouts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppTimeoutsInfo getAppTimeouts(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppTimeouts(hsr, appId);
    }

    @PUT
    @Path(value="/apps/{appid}/timeout")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public Response updateApplicationTimeout(AppTimeoutInfo appTimeout, @Context HttpServletRequest hsr, @PathParam(value="appid") String appId) throws AuthorizationException, YarnException, InterruptedException, IOException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().updateApplicationTimeout(appTimeout, hsr, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest hsr, @PathParam(value="appid") String appId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().getAppAttempts(hsr, appId);
    }

    @GET
    @Path(value="/queues/{queue}/access")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public RMQueueAclInfo checkUserAccessToQueue(@PathParam(value="queue") String queue, @QueryParam(value="user") String username, @QueryParam(value="queue-acl-type") @DefaultValue(value="SUBMIT_APPLICATIONS") String queueAclType, @Context HttpServletRequest hsr) throws AuthorizationException {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(hsr);
        return pipeline.getRootInterceptor().checkUserAccessToQueue(queue, username, queueAclType, hsr);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(req);
        return pipeline.getRootInterceptor().getAppAttempt(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(req);
        return pipeline.getRootInterceptor().getContainers(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.init();
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain(req);
        return pipeline.getRootInterceptor().getContainer(req, res, appId, appAttemptId, containerId);
    }

    @VisibleForTesting
    protected void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @InterfaceAudience.Private
    public static class RequestInterceptorChainWrapper {
        private RESTRequestInterceptor rootInterceptor;

        public synchronized void init(RESTRequestInterceptor interceptor) {
            this.rootInterceptor = interceptor;
        }

        public synchronized RESTRequestInterceptor getRootInterceptor() {
            return this.rootInterceptor;
        }

        protected void finalize() {
            this.rootInterceptor.shutdown();
        }
    }
}

