/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterClientRMService
extends AbstractService
implements ApplicationClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterClientRMService.class);
    private Server server;
    private InetSocketAddress listenerEndpoint;
    private Map<String, RequestInterceptorChainWrapper> userPipelineMap;

    public RouterClientRMService() {
        super(RouterClientRMService.class.getName());
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting Router ClientRMService");
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.listenerEndpoint = conf.getSocketAddr("yarn.router.bind-host", "yarn.router.clientrm.address", "0.0.0.0:8050", 8050);
        int maxCacheSize = conf.getInt("yarn.router.pipeline.cache-max-size", 25);
        this.userPipelineMap = Collections.synchronizedMap(new LRUCacheHashMap(maxCacheSize, true));
        Configuration serverConf = new Configuration(conf);
        int numWorkerThreads = serverConf.getInt("yarn.resourcemanager.client.thread-count", 50);
        this.server = rpc.getServer(ApplicationClientProtocol.class, (Object)this, this.listenerEndpoint, serverConf, null, numWorkerThreads);
        this.server.start();
        LOG.info("Router ClientRMService listening on address: " + this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping Router ClientRMService");
        if (this.server != null) {
            this.server.stop();
        }
        this.userPipelineMap.clear();
        super.serviceStop();
    }

    private List<String> getInterceptorClassNames(Configuration conf) {
        String configuredInterceptorClassNames = conf.get("yarn.router.clientrm.interceptor-class.pipeline", "org.apache.hadoop.yarn.server.router.clientrm.DefaultClientRequestInterceptor");
        ArrayList<String> interceptorClassNames = new ArrayList<String>();
        Collection tempList = StringUtils.getStringCollection((String)configuredInterceptorClassNames);
        for (String item : tempList) {
            interceptorClassNames.add(item.trim());
        }
        return interceptorClassNames;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNewApplication(request);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().submitApplication(request);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().forceKillApplication(request);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterMetrics(request);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterNodes(request);
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getQueueInfo(request);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getQueueUserAcls(request);
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().moveApplicationAcrossQueues(request);
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNewReservation(request);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().submitReservation(request);
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().listReservations(request);
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateReservation(request);
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().deleteReservation(request);
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getNodeToLabels(request);
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getLabelsToNodes(request);
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getClusterNodeLabels(request);
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplicationReport(request);
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplications(request);
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplicationAttemptReport(request);
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getApplicationAttempts(request);
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getContainerReport(request);
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getContainers(request);
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getDelegationToken(request);
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().renewDelegationToken(request);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().cancelDelegationToken(request);
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().failApplicationAttempt(request);
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateApplicationPriority(request);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().signalToContainer(request);
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateApplicationTimeouts(request);
    }

    public GetAllResourceProfilesResponse getResourceProfiles(GetAllResourceProfilesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceProfiles(request);
    }

    public GetResourceProfileResponse getResourceProfile(GetResourceProfileRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceProfile(request);
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getResourceTypeInfo(request);
    }

    private RequestInterceptorChainWrapper getInterceptorChain() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        if (!this.userPipelineMap.containsKey(user)) {
            this.initializePipeline(user);
        }
        return this.userPipelineMap.get(user);
    }

    @VisibleForTesting
    protected Map<String, RequestInterceptorChainWrapper> getPipelines() {
        return this.userPipelineMap;
    }

    @VisibleForTesting
    protected ClientRequestInterceptor createRequestInterceptorChain() {
        Configuration conf = this.getConfig();
        List<String> interceptorClassNames = this.getInterceptorClassNames(conf);
        ClientRequestInterceptor pipeline = null;
        ClientRequestInterceptor current = null;
        for (String interceptorClassName : interceptorClassNames) {
            try {
                Class interceptorClass = conf.getClassByName(interceptorClassName);
                if (ClientRequestInterceptor.class.isAssignableFrom(interceptorClass)) {
                    ClientRequestInterceptor interceptorInstance = (ClientRequestInterceptor)ReflectionUtils.newInstance((Class)interceptorClass, (Configuration)conf);
                    if (pipeline == null) {
                        pipeline = interceptorInstance;
                        current = interceptorInstance;
                        continue;
                    }
                    current.setNextInterceptor(interceptorInstance);
                    current = interceptorInstance;
                    continue;
                }
                throw new YarnRuntimeException("Class: " + interceptorClassName + " not instance of " + ClientRequestInterceptor.class.getCanonicalName());
            }
            catch (ClassNotFoundException e) {
                throw new YarnRuntimeException("Could not instantiate ApplicationClientRequestInterceptor: " + interceptorClassName, (Throwable)e);
            }
        }
        if (pipeline == null) {
            throw new YarnRuntimeException("RequestInterceptor pipeline is not configured in the system");
        }
        return pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePipeline(String user) {
        RequestInterceptorChainWrapper chainWrapper = null;
        Map<String, RequestInterceptorChainWrapper> map = this.userPipelineMap;
        synchronized (map) {
            if (this.userPipelineMap.containsKey(user)) {
                LOG.info("Request to start an already existing user: {} was received, so ignoring.", (Object)user);
                return;
            }
            chainWrapper = new RequestInterceptorChainWrapper();
            this.userPipelineMap.put(user, chainWrapper);
        }
        LOG.info("Initializing request processing pipeline for application for the user: {}", (Object)user);
        try {
            ClientRequestInterceptor interceptorChain = this.createRequestInterceptorChain();
            interceptorChain.init(user);
            chainWrapper.init(interceptorChain);
        }
        catch (Exception e) {
            Map<String, RequestInterceptorChainWrapper> map2 = this.userPipelineMap;
            synchronized (map2) {
                this.userPipelineMap.remove(user);
            }
            throw e;
        }
    }

    @InterfaceAudience.Private
    public static class RequestInterceptorChainWrapper {
        private ClientRequestInterceptor rootInterceptor;

        public synchronized void init(ClientRequestInterceptor interceptor) {
            this.rootInterceptor = interceptor;
        }

        public synchronized ClientRequestInterceptor getRootInterceptor() {
            return this.rootInterceptor;
        }

        protected void finalize() {
            this.rootInterceptor.shutdown();
        }
    }
}

