/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.PlacementConstraint;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.exceptions.SliderException;
import org.apache.hadoop.yarn.service.monitor.probe.MonitorUtils;
import org.apache.hadoop.yarn.service.provider.AbstractClientProvider;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.utils.JsonSerDeser;
import org.apache.hadoop.yarn.service.utils.PatternValidator;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceApiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceApiUtil.class);
    public static JsonSerDeser<Service> jsonSerDeser = new JsonSerDeser<Service>(Service.class, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    public static final JsonSerDeser<Container[]> CONTAINER_JSON_SERDE = new JsonSerDeser<Container[]>(Container[].class, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    public static final JsonSerDeser<Component[]> COMP_JSON_SERDE = new JsonSerDeser<Component[]>(Component[].class, PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    private static final PatternValidator namePattern = new PatternValidator("[a-z][a-z0-9-]*");
    private static final PatternValidator userNamePattern = new PatternValidator("[a-z][a-z0-9-.]*");

    @VisibleForTesting
    public static void setJsonSerDeser(JsonSerDeser jsd) {
        jsonSerDeser = jsd;
    }

    @VisibleForTesting
    public static void validateAndResolveService(Service service, SliderFileSystem fs, org.apache.hadoop.conf.Configuration conf) throws IOException {
        boolean dnsEnabled = conf.getBoolean("hadoop.registry.dns.enabled", false);
        if (dnsEnabled) {
            if (RegistryUtils.currentUser().length() > 63) {
                throw new IllegalArgumentException("User name must be no more than 63 characters");
            }
            userNamePattern.validate(RegistryUtils.currentUser());
        }
        if (StringUtils.isEmpty((String)service.getName())) {
            throw new IllegalArgumentException("Service name is either empty or not provided");
        }
        if (StringUtils.isEmpty((String)service.getVersion())) {
            throw new IllegalArgumentException(String.format("Version of service %s is either empty or not provided", service.getName()));
        }
        ServiceApiUtil.validateNameFormat(service.getName(), conf);
        if (!ServiceApiUtil.hasComponent(service)) {
            throw new IllegalArgumentException("No component specified for " + service.getName());
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            ServiceApiUtil.validateKerberosPrincipal(service.getKerberosPrincipal());
        }
        try {
            ServiceApiUtil.validateDockerClientConfiguration(service, conf);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Configuration globalConf = service.getConfiguration();
        HashSet<String> componentNames = new HashSet<String>();
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        ArrayList<Component> componentsToAdd = new ArrayList<Component>();
        for (Component comp : service.getComponents()) {
            int maxCompLength = 63;
            if (dnsEnabled && comp.getName().length() > (maxCompLength -= Long.toString(Long.MAX_VALUE).length())) {
                throw new IllegalArgumentException(String.format("Component name must be no more than %s characters: %s", maxCompLength, comp.getName()));
            }
            if (service.getName().equals(comp.getName())) {
                throw new IllegalArgumentException(String.format("Component name %s must not be same as service name %s", comp.getName(), service.getName()));
            }
            if (componentNames.contains(comp.getName())) {
                throw new IllegalArgumentException("Component name collision: " + comp.getName());
            }
            if (comp.getArtifact() != null && comp.getArtifact().getType() == Artifact.TypeEnum.SERVICE) {
                if (StringUtils.isEmpty((String)comp.getArtifact().getId())) {
                    throw new IllegalArgumentException("Artifact id (like docker image name) is either empty or not provided");
                }
                LOG.info("Marking {} for removal", (Object)comp.getName());
                componentsToRemove.add(comp);
                List<Component> externalComponents = ServiceApiUtil.getComponents(fs, comp.getArtifact().getId());
                for (Component c : externalComponents) {
                    Component override = service.getComponent(c.getName());
                    if (override != null && override.getArtifact() == null) {
                        override.mergeFrom(c);
                        LOG.info("Merging external component {} from external {}", (Object)c.getName(), (Object)comp.getName());
                        continue;
                    }
                    if (componentNames.contains(c.getName())) {
                        throw new IllegalArgumentException("Component name collision: " + c.getName());
                    }
                    componentNames.add(c.getName());
                    componentsToAdd.add(c);
                    LOG.info("Adding component {} from external {}", (Object)c.getName(), (Object)comp.getName());
                }
                continue;
            }
            componentNames.add(comp.getName());
            comp.getConfiguration().mergeFrom(globalConf);
        }
        service.getComponents().removeAll(componentsToRemove);
        service.getComponents().addAll(componentsToAdd);
        Artifact globalArtifact = service.getArtifact();
        Resource globalResource = service.getResource();
        for (Component comp : service.getComponents()) {
            if (comp.getArtifact() == null && service.getArtifact() != null && service.getArtifact().getType() != Artifact.TypeEnum.SERVICE) {
                comp.setArtifact(globalArtifact);
            }
            if (comp.getResource() == null) {
                comp.setResource(globalResource);
            }
            if (comp.getDependencies() != null) {
                for (String dependency : comp.getDependencies()) {
                    if (componentNames.contains(dependency)) continue;
                    throw new IllegalArgumentException(String.format("Dependency %s for component %s is invalid, does not exist as a component", dependency, comp.getName()));
                }
            }
            ServiceApiUtil.validateComponent(comp, fs.getFileSystem(), conf);
        }
        ServiceApiUtil.validatePlacementPolicy(service.getComponents(), componentNames);
        ServiceApiUtil.sortByDependencies(service.getComponents());
        if (service.getLifetime() == null) {
            service.setLifetime(RestApiConstants.DEFAULT_UNLIMITED_LIFETIME);
        }
    }

    public static void validateKerberosPrincipal(KerberosPrincipal kerberosPrincipal) throws IOException {
        try {
            if (!kerberosPrincipal.getPrincipalName().contains("/")) {
                throw new IllegalArgumentException(String.format("Kerberos principal (%s) does  not contain a hostname.", kerberosPrincipal.getPrincipalName()));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Kerberos principal or keytab is missing.");
        }
    }

    private static void validateDockerClientConfiguration(Service service, org.apache.hadoop.conf.Configuration conf) throws IOException {
        String dockerClientConfig = service.getDockerClientConfig();
        if (!StringUtils.isEmpty((String)dockerClientConfig)) {
            Path dockerClientConfigPath = new Path(dockerClientConfig);
            FileSystem fs = dockerClientConfigPath.getFileSystem(conf);
            LOG.info("The supplied Docker client config is " + dockerClientConfig);
            if (!fs.exists(dockerClientConfigPath)) {
                throw new IOException("The supplied Docker client config does not exist: " + dockerClientConfig);
            }
        }
    }

    private static void validateComponent(Component comp, FileSystem fs, org.apache.hadoop.conf.Configuration conf) throws IOException {
        ServiceApiUtil.validateNameFormat(comp.getName(), conf);
        AbstractClientProvider compClientProvider = ProviderFactory.getClientProvider(comp.getArtifact());
        compClientProvider.validateArtifact(comp.getArtifact(), comp.getName(), fs);
        if (comp.getLaunchCommand() == null && (comp.getArtifact() == null || comp.getArtifact().getType() != Artifact.TypeEnum.DOCKER)) {
            throw new IllegalArgumentException("launch_command is required when type is not DOCKER");
        }
        ServiceApiUtil.validateServiceResource(comp.getResource(), comp);
        if (comp.getNumberOfContainers() == null || comp.getNumberOfContainers() < 0L) {
            throw new IllegalArgumentException(String.format("Invalid no of containers specified for component %s (nor at the global level): " + comp.getNumberOfContainers(), comp.getName()));
        }
        compClientProvider.validateConfigFiles(comp.getConfiguration().getFiles(), comp.getName(), fs);
        MonitorUtils.getProbe(comp.getReadinessCheck());
    }

    public static void validateNameFormat(String name, org.apache.hadoop.conf.Configuration conf) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Name can not be empty!");
        }
        if (name.contains("_")) {
            throw new IllegalArgumentException("Invalid format: " + name + ", can not use '_', as DNS hostname does not allow '_'. Use '-' Instead. ");
        }
        boolean dnsEnabled = conf.getBoolean("hadoop.registry.dns.enabled", false);
        if (dnsEnabled && name.length() > 63) {
            throw new IllegalArgumentException(String.format("Invalid format %s, must be no more than 63 characters ", name));
        }
        namePattern.validate(name);
    }

    private static void validatePlacementPolicy(List<Component> components, Set<String> componentNames) {
        for (Component comp : components) {
            PlacementPolicy placementPolicy = comp.getPlacementPolicy();
            if (placementPolicy == null) continue;
            for (PlacementConstraint constraint : placementPolicy.getConstraints()) {
                if (constraint.getType() == null) {
                    throw new IllegalArgumentException(String.format("Type not specified for constraint %sin placement policy of component %s.", constraint.getName() == null ? "" : constraint.getName() + " ", comp.getName()));
                }
                if (constraint.getScope() == null) {
                    throw new IllegalArgumentException(String.format("Scope not specified for constraint %sin placement policy of component %s.", constraint.getName() == null ? "" : constraint.getName() + " ", comp.getName()));
                }
                if (constraint.getTargetTags().isEmpty()) {
                    throw new IllegalArgumentException(String.format("Tag(s) not specified for constraint %sin placement policy of component %s.", constraint.getName() == null ? "" : constraint.getName() + " ", comp.getName()));
                }
                for (String targetTag : constraint.getTargetTags()) {
                    if (comp.getName().equals(targetTag)) continue;
                    throw new IllegalArgumentException(String.format("Invalid target tag %s specified in placement policy of component %s. For now, target tags support self reference only. Specifying anything other than its component name is not supported. Set target tag of component %s to %s.", targetTag, comp.getName(), comp.getName(), comp.getName()));
                }
            }
        }
    }

    @VisibleForTesting
    public static List<Component> getComponents(SliderFileSystem fs, String serviceName) throws IOException {
        return ServiceApiUtil.loadService(fs, serviceName).getComponents();
    }

    public static Service loadService(SliderFileSystem fs, String serviceName) throws IOException {
        Path serviceJson = ServiceApiUtil.getServiceJsonPath(fs, serviceName);
        LOG.info("Loading service definition from " + serviceJson);
        return jsonSerDeser.load(fs.getFileSystem(), serviceJson);
    }

    public static Service loadServiceUpgrade(SliderFileSystem fs, String serviceName, String version) throws IOException {
        Path versionPath = fs.buildClusterUpgradeDirPath(serviceName, version);
        Path versionedDef = new Path(versionPath, serviceName + ".json");
        LOG.info("Loading service definition from {}", (Object)versionedDef);
        return jsonSerDeser.load(fs.getFileSystem(), versionedDef);
    }

    public static Service loadServiceFrom(SliderFileSystem fs, Path appDefPath) throws IOException {
        LOG.info("Loading service definition from " + appDefPath);
        return jsonSerDeser.load(fs.getFileSystem(), appDefPath);
    }

    public static Path getServiceJsonPath(SliderFileSystem fs, String serviceName) {
        Path serviceDir = fs.buildClusterDirPath(serviceName);
        return new Path(serviceDir, serviceName + ".json");
    }

    private static void validateServiceResource(Resource resource, Component comp) {
        if (resource == null) {
            throw new IllegalArgumentException(comp == null ? "Resource is not provided" : String.format("Resource is not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (StringUtils.isNotEmpty((String)resource.getProfile()) && (resource.getCpus() != null || StringUtils.isNotEmpty((String)resource.getMemory()))) {
            throw new IllegalArgumentException(comp == null ? "Cannot specify cpus/memory along with profile" : String.format("Cannot specify cpus/memory along with profile for component %s", comp.getName()));
        }
        if (StringUtils.isNotEmpty((String)resource.getProfile())) {
            throw new IllegalArgumentException("Resource profile is not supported yet. Please specify cpus/memory.");
        }
        String memory = resource.getMemory();
        Integer cpus = resource.getCpus();
        if (StringUtils.isEmpty((String)memory)) {
            throw new IllegalArgumentException(comp == null ? "Service resource or memory not provided" : String.format("Service resource or memory not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (cpus == null) {
            throw new IllegalArgumentException(comp == null ? "Service resource or cpus not provided" : String.format("Service resource or cpus not provided for component %s (nor at the global level)", comp.getName()));
        }
        if (cpus <= 0) {
            throw new IllegalArgumentException(comp == null ? "Unacceptable no of cpus specified, either zero or negative" : String.format("Unacceptable no of cpus specified, either zero or negative for component %s (or at the global level)", comp.getName()));
        }
    }

    public static void validateCompResourceSize(org.apache.hadoop.yarn.api.records.Resource maxResource, Service service) throws YarnException {
        for (Component component : service.getComponents()) {
            long mem = Long.parseLong(component.getResource().getMemory());
            if (mem > maxResource.getMemorySize()) {
                throw new YarnException("Component " + component.getName() + ": specified memory size (" + mem + ") is larger than configured max container memory size (" + maxResource.getMemorySize() + ")");
            }
            int cpu = component.getResource().getCpus();
            if (cpu <= maxResource.getVirtualCores()) continue;
            throw new YarnException("Component " + component.getName() + ": specified number of virtual core (" + cpu + ") is larger than configured max virtual core size (" + maxResource.getVirtualCores() + ")");
        }
    }

    private static boolean hasComponent(Service service) {
        return service.getComponents() != null && !service.getComponents().isEmpty();
    }

    public static Collection<Component> sortByDependencies(List<Component> components) {
        Map<String, Component> sortedComponents = ServiceApiUtil.sortByDependencies(components, null);
        return sortedComponents.values();
    }

    private static Map<String, Component> sortByDependencies(List<Component> components, Map<String, Component> sortedComponents) {
        if (sortedComponents == null) {
            sortedComponents = new LinkedHashMap<String, Component>();
        }
        LinkedHashMap<String, Component> componentsToAdd = new LinkedHashMap<String, Component>();
        ArrayList<Component> componentsSkipped = new ArrayList<Component>();
        for (Component component : components) {
            String name = component.getName();
            if (sortedComponents.containsKey(name)) continue;
            boolean dependenciesAlreadySorted = true;
            if (!ServiceUtils.isEmpty(component.getDependencies())) {
                for (String dependency : component.getDependencies()) {
                    if (sortedComponents.containsKey(dependency)) continue;
                    dependenciesAlreadySorted = false;
                    break;
                }
            }
            if (dependenciesAlreadySorted) {
                componentsToAdd.put(name, component);
                continue;
            }
            componentsSkipped.add(component);
        }
        if (componentsToAdd.size() == 0) {
            throw new IllegalArgumentException(String.format("Invalid dependencies, a cycle may exist: %s", componentsSkipped));
        }
        sortedComponents.putAll(componentsToAdd);
        if (sortedComponents.size() == components.size()) {
            return sortedComponents;
        }
        return ServiceApiUtil.sortByDependencies(components, sortedComponents);
    }

    public static void createDirAndPersistApp(SliderFileSystem fs, Path appDir, Service service) throws IOException, SliderException {
        FsPermission appDirPermission = new FsPermission("750");
        fs.createWithPermissions(appDir, appDirPermission);
        Path appJson = ServiceApiUtil.writeAppDefinition(fs, appDir, service);
        LOG.info("Persisted service {} version {} at {}", new Object[]{service.getName(), service.getVersion(), appJson});
    }

    public static Path writeAppDefinition(SliderFileSystem fs, Path appDir, Service service) throws IOException {
        Path appJson = new Path(appDir, service.getName() + ".json");
        jsonSerDeser.save(fs.getFileSystem(), appJson, service, true);
        return appJson;
    }

    public static Path writeAppDefinition(SliderFileSystem fs, Service service) throws IOException {
        Path appJson = ServiceApiUtil.getServiceJsonPath(fs, service.getName());
        jsonSerDeser.save(fs.getFileSystem(), appJson, service, true);
        return appJson;
    }

    public static List<Container> getLiveContainers(Service service, List<String> componentInstances) throws YarnException {
        ArrayList<Container> result = new ArrayList<Container>();
        ArrayListMultimap affectedComps = ArrayListMultimap.create();
        for (String instanceName : componentInstances) {
            affectedComps.put((Object)ServiceApiUtil.parseComponentName(instanceName), (Object)instanceName);
        }
        service.getComponents().forEach(arg_0 -> ServiceApiUtil.lambda$getLiveContainers$1((Multimap)affectedComps, result, arg_0));
        return result;
    }

    public static void validateInstancesUpgrade(List<Container> liveContainers) throws YarnException {
        for (Container liveContainer : liveContainers) {
            if (ServiceApiUtil.isUpgradable(liveContainer)) continue;
            throw new YarnException(String.format("The component instance (%s) does not need an upgrade.", liveContainer.getComponentInstanceName()));
        }
    }

    public static boolean isUpgradable(Container container) {
        return container.getState() != null && (container.getState().equals((Object)ContainerState.NEEDS_UPGRADE) || container.getState().equals((Object)ContainerState.FAILED_UPGRADE));
    }

    public static List<Container> validateAndResolveCompsUpgrade(Service liveService, Collection<String> compNames) throws YarnException {
        Preconditions.checkNotNull(compNames);
        HashSet requestedComps = Sets.newHashSet(compNames);
        ArrayList<Container> containerNeedUpgrade = new ArrayList<Container>();
        for (Component liveComp : liveService.getComponents()) {
            if (!requestedComps.contains(liveComp.getName())) continue;
            if (!liveComp.getState().equals((Object)ComponentState.NEEDS_UPGRADE)) {
                throw new YarnException(String.format("The component (%s) does not need an upgrade.", liveComp.getName()));
            }
            liveComp.getContainers().forEach(liveContainer -> {
                if (ServiceApiUtil.isUpgradable(liveContainer)) {
                    containerNeedUpgrade.add((Container)liveContainer);
                }
            });
        }
        return containerNeedUpgrade;
    }

    public static List<Container> validateAndResolveCompsStable(Service liveService, Collection<String> compNames) throws YarnException {
        Preconditions.checkNotNull(compNames);
        HashSet requestedComps = Sets.newHashSet(compNames);
        ArrayList<Container> containerNeedUpgrade = new ArrayList<Container>();
        for (Component liveComp : liveService.getComponents()) {
            if (!requestedComps.contains(liveComp.getName())) continue;
            if (!liveComp.getState().equals((Object)ComponentState.STABLE)) {
                throw new YarnException(String.format("The component (%s) does not need an upgrade.", liveComp.getName()));
            }
            liveComp.getContainers().forEach(liveContainer -> {
                if (liveContainer.getState().equals((Object)ContainerState.READY)) {
                    containerNeedUpgrade.add((Container)liveContainer);
                }
            });
        }
        return containerNeedUpgrade;
    }

    public static String getHostnameSuffix(String serviceName, org.apache.hadoop.conf.Configuration conf) {
        String domain = conf.get("hadoop.registry.dns.domain-name");
        String hostnameSuffix = domain == null || domain.isEmpty() ? MessageFormat.format(".{0}.{1}", serviceName, RegistryUtils.currentUser()) : MessageFormat.format(".{0}.{1}.{2}", serviceName, RegistryUtils.currentUser(), domain);
        return hostnameSuffix;
    }

    public static String parseAndValidateComponentInstanceName(String instanceOrHostname, String serviceName, org.apache.hadoop.conf.Configuration conf) throws IllegalArgumentException {
        int idx = instanceOrHostname.indexOf(46);
        String hostnameSuffix = ServiceApiUtil.getHostnameSuffix(serviceName, conf);
        if (idx != -1) {
            if (!instanceOrHostname.endsWith(hostnameSuffix)) {
                throw new IllegalArgumentException("Specified hostname " + instanceOrHostname + " does not have the expected format componentInstanceName" + hostnameSuffix);
            }
            instanceOrHostname = instanceOrHostname.substring(0, instanceOrHostname.length() - hostnameSuffix.length());
        }
        if ((idx = instanceOrHostname.indexOf(46)) != -1) {
            throw new IllegalArgumentException("Specified hostname " + instanceOrHostname + " does not have the expected format componentInstanceName" + hostnameSuffix);
        }
        return instanceOrHostname;
    }

    public static String parseComponentName(String componentInstanceName) throws YarnException {
        int idx = componentInstanceName.indexOf(46);
        if (idx != -1) {
            componentInstanceName = componentInstanceName.substring(0, idx);
        }
        if ((idx = componentInstanceName.lastIndexOf(45)) == -1) {
            throw new YarnException("Invalid component instance (" + componentInstanceName + ") name.");
        }
        return componentInstanceName.substring(0, idx);
    }

    public static String $(String s) {
        return "${" + s + "}";
    }

    public static List<String> resolveCompsDependency(Service service) {
        ArrayList<String> components = new ArrayList<String>();
        for (Component component : service.getComponents()) {
            int depSize = component.getDependencies().size();
            if (!components.contains(component.getName())) {
                components.add(component.getName());
            }
            if (depSize == 0) continue;
            for (String depComp : component.getDependencies()) {
                if (components.contains(depComp)) continue;
                components.add(0, depComp);
            }
        }
        return components;
    }

    private static /* synthetic */ void lambda$getLiveContainers$1(Multimap affectedComps, List result, Component comp) {
        if (affectedComps.get((Object)comp.getName()) != null) {
            Collection instanceNames = affectedComps.get((Object)comp.getName());
            comp.getContainers().forEach(container -> {
                if (instanceNames.contains(container.getComponentInstanceName())) {
                    result.add(container);
                }
            });
        }
    }
}

