/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.ConfigFormat;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;

public class ConfigUtils {
    public static final String TEMPLATE_FILE = "template.file";

    public static String replaceProps(Map<String, String> config, String content) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            tokens.put("${" + entry.getKey() + "}", entry.getValue());
            tokens.put("{{" + entry.getKey() + "}}", entry.getValue());
        }
        String value = content;
        for (Map.Entry token : tokens.entrySet()) {
            value = value.replaceAll(Pattern.quote((String)token.getKey()), Matcher.quoteReplacement((String)token.getValue()));
        }
        return value;
    }

    public static Map<String, String> replacePropsInConfig(Map<String, String> config, Map<String, String> env) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            tokens.put("${" + entry.getKey() + "}", entry.getValue());
        }
        HashMap<String, String> newConfig = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String value = entry.getValue();
            for (Map.Entry token : tokens.entrySet()) {
                value = value.replaceAll(Pattern.quote((String)token.getKey()), Matcher.quoteReplacement((String)token.getValue()));
            }
            newConfig.put(entry.getKey(), entry.getValue());
        }
        return newConfig;
    }

    public static void prepConfigForTemplateOutputter(ConfigFormat configFormat, Map<String, String> config, SliderFileSystem fileSystem, String clusterName, String fileName) throws IOException {
        if (!configFormat.equals((Object)ConfigFormat.TEMPLATE)) {
            return;
        }
        Path templateFile = null;
        if (config.containsKey(TEMPLATE_FILE)) {
            templateFile = fileSystem.buildResourcePath(config.get(TEMPLATE_FILE));
            if (!fileSystem.isFile(templateFile)) {
                templateFile = fileSystem.buildResourcePath(clusterName, config.get(TEMPLATE_FILE));
            }
            if (!fileSystem.isFile(templateFile)) {
                throw new IOException("config specified template file " + config.get(TEMPLATE_FILE) + " but " + templateFile + " doesn't exist");
            }
        }
        if (templateFile == null && fileName != null && !fileSystem.isFile(templateFile = fileSystem.buildResourcePath(fileName))) {
            templateFile = fileSystem.buildResourcePath(clusterName, fileName);
        }
        if (fileSystem.isFile(templateFile)) {
            config.put("content", fileSystem.cat(templateFile));
        } else {
            config.put("content", "");
        }
    }
}

