/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.timelineservice;

import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelineEntityType;
import org.apache.hadoop.yarn.service.timelineservice.ServiceTimelinePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMetricsSink
implements MetricsSink {
    private static final Logger log = LoggerFactory.getLogger(ServiceMetricsSink.class);
    private ServiceTimelinePublisher serviceTimelinePublisher;

    public ServiceMetricsSink() {
    }

    public ServiceMetricsSink(ServiceTimelinePublisher publisher) {
        this.serviceTimelinePublisher = publisher;
    }

    public void putMetrics(MetricsRecord record) {
        if (this.serviceTimelinePublisher.isStopped()) {
            log.warn("ServiceTimelinePublisher has stopped. Not publishing any more metrics to ATS.");
            return;
        }
        boolean isServiceMetrics = false;
        boolean isComponentMetrics = false;
        String appId = null;
        for (MetricsTag tag : record.tags()) {
            if (tag.name().equals("type") && tag.value().equals("service")) {
                isServiceMetrics = true;
                continue;
            }
            if (tag.name().equals("type") && tag.value().equals("component")) {
                isComponentMetrics = true;
                break;
            }
            if (!tag.name().equals("appId")) continue;
            appId = tag.value();
        }
        if (isServiceMetrics && appId != null) {
            if (log.isDebugEnabled()) {
                log.debug("Publishing service metrics. " + record);
            }
            this.serviceTimelinePublisher.publishMetrics(record.metrics(), appId, ServiceTimelineEntityType.SERVICE_ATTEMPT.toString(), record.timestamp());
        } else if (isComponentMetrics) {
            if (log.isDebugEnabled()) {
                log.debug("Publishing Component metrics. " + record);
            }
            this.serviceTimelinePublisher.publishMetrics(record.metrics(), record.name(), ServiceTimelineEntityType.COMPONENT.toString(), record.timestamp());
        }
    }

    public void init(SubsetConfiguration conf) {
    }

    public void flush() {
    }
}

