/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.Artifact;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="A custom command or a pluggable helper container to determine the readiness of a container of a component. Readiness for every service is different. Hence the need for a simple interface, with scope to support advanced usecases.")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReadinessCheck
implements Serializable {
    private static final long serialVersionUID = -3836839816887186801L;
    @JsonProperty(value="type")
    @XmlElement(name="type")
    private TypeEnum type = null;
    @JsonProperty(value="properties")
    @XmlElement(name="properties")
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonProperty(value="artifact")
    @XmlElement(name="artifact")
    private Artifact artifact = null;

    public ReadinessCheck type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="E.g. HTTP (YARN will perform a simple REST call at a regular interval and expect a 204 No content).")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ReadinessCheck properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ReadinessCheck putPropsItem(String key, String propsItem) {
        this.properties.put(key, propsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="A blob of key value pairs that will be used to configure the check.")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public ReadinessCheck artifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact of the pluggable readiness check helper container (optional). If specified, this helper container typically hosts the http uri and encapsulates the complex scripts required to perform actual container readiness check. At the end it is expected to respond a 204 No content just like the simplified use case. This pluggable framework benefits service owners who can run services without any packaging modifications. Note, artifacts of type docker only is supported for now.")
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadinessCheck readinessCheck = (ReadinessCheck)o;
        return Objects.equals((Object)this.type, (Object)readinessCheck.type) && Objects.equals(this.properties, readinessCheck.properties) && Objects.equals(this.artifact, readinessCheck.artifact);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.properties, this.artifact});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadinessCheck {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @XmlType(name="type")
    @XmlEnum
    public static enum TypeEnum {
        DEFAULT("DEFAULT"),
        HTTP("HTTP"),
        PORT("PORT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

