/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceEvent;
import org.apache.hadoop.yarn.service.ServiceEventType;
import org.apache.hadoop.yarn.service.ServiceMaster;
import org.apache.hadoop.yarn.service.ServiceScheduler;
import org.apache.hadoop.yarn.service.UpgradeComponentsFinder;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.ComponentEvent;
import org.apache.hadoop.yarn.service.component.ComponentEventType;
import org.apache.hadoop.yarn.service.component.ComponentRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEvent;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstanceEventType;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager
implements EventHandler<ServiceEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceManager.class);
    private final Service serviceSpec;
    private final ServiceContext context;
    private final ServiceScheduler scheduler;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final StateMachine<State, ServiceEventType, ServiceEvent> stateMachine;
    private final UpgradeComponentsFinder componentsFinder;
    private final AsyncDispatcher dispatcher;
    private final SliderFileSystem fs;
    private String upgradeVersion;
    private List<org.apache.hadoop.yarn.service.api.records.Component> componentsToUpgrade;
    private List<String> compsAffectedByUpgrade = new ArrayList<String>();
    private String cancelledVersion;
    private static final StateMachineFactory<ServiceManager, State, ServiceEventType, ServiceEvent> STATE_MACHINE_FACTORY = new StateMachineFactory((Enum)State.STABLE).addTransition((Enum)State.STABLE, EnumSet.of(State.STABLE, State.UPGRADING), (Enum)ServiceEventType.UPGRADE, (MultipleArcTransition)new StartUpgradeTransition()).addTransition((Enum)State.STABLE, EnumSet.of(State.STABLE), (Enum)ServiceEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)State.UPGRADING, EnumSet.of(State.STABLE, State.UPGRADING), (Enum)ServiceEventType.START, (MultipleArcTransition)new StartFromUpgradeTransition()).addTransition((Enum)State.UPGRADING, EnumSet.of(State.STABLE, State.UPGRADING), (Enum)ServiceEventType.CHECK_STABLE, (MultipleArcTransition)new CheckStableTransition()).addTransition((Enum)State.UPGRADING, (Enum)State.UPGRADING, (Enum)ServiceEventType.CANCEL_UPGRADE, (SingleArcTransition)new CancelUpgradeTransition()).installTopology();

    public ServiceManager(ServiceContext context) {
        Preconditions.checkNotNull((Object)context);
        this.context = context;
        this.serviceSpec = context.service;
        this.scheduler = context.scheduler;
        this.stateMachine = STATE_MACHINE_FACTORY.make((Object)this);
        this.dispatcher = this.scheduler.getDispatcher();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.fs = context.fs;
        this.componentsFinder = new UpgradeComponentsFinder.DefaultUpgradeComponentsFinder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ServiceEvent event) {
        try {
            this.writeLock.lock();
            State oldState = this.getState();
            try {
                this.stateMachine.doTransition((Enum)event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error(MessageFormat.format("[SERVICE]: Invalid event {1} at {2}.", new Object[]{event.getType(), oldState}), (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info("[SERVICE] Transitioned from {} to {} on {} event.", new Object[]{oldState, this.getState(), event.getType()});
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private State getState() {
        this.readLock.lock();
        try {
            State state = (State)this.stateMachine.getCurrentState();
            return state;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void upgradeNextCompIfAny(boolean cancelUpgrade) {
        if (!this.componentsToUpgrade.isEmpty()) {
            org.apache.hadoop.yarn.service.api.records.Component component = this.componentsToUpgrade.get(0);
            this.serviceSpec.getComponent(component.getName()).getContainers().forEach(container -> {
                ComponentInstanceEvent upgradeEvent = new ComponentInstanceEvent(ContainerId.fromString((String)container.getId()), !cancelUpgrade ? ComponentInstanceEventType.UPGRADE : ComponentInstanceEventType.CANCEL_UPGRADE);
                LOG.info("Upgrade container {} {}", (Object)container.getId(), (Object)cancelUpgrade);
                this.dispatcher.getEventHandler().handle((Event)upgradeEvent);
            });
        }
    }

    private void dispatchNeedUpgradeEvents(boolean cancelUpgrade) {
        if (this.componentsToUpgrade != null) {
            this.componentsToUpgrade.forEach(component -> {
                ComponentEvent needUpgradeEvent = new ComponentEvent(component.getName(), !cancelUpgrade ? ComponentEventType.UPGRADE : ComponentEventType.CANCEL_UPGRADE).setTargetSpec((org.apache.hadoop.yarn.service.api.records.Component)component).setUpgradeVersion(this.upgradeVersion);
                LOG.info("Upgrade component {} {}", (Object)component.getName(), (Object)cancelUpgrade);
                this.context.scheduler.getDispatcher().getEventHandler().handle((Event)needUpgradeEvent);
            });
        }
    }

    private boolean finalizeUpgrade(boolean cancelUpgrade) {
        if (!cancelUpgrade) {
            try {
                Service targetSpec = ServiceApiUtil.loadServiceUpgrade(this.fs, this.getName(), this.upgradeVersion);
                targetSpec.setId(this.serviceSpec.getId());
                targetSpec.setState(ServiceState.STABLE);
                Map<String, Component> allComps = this.scheduler.getAllComponents();
                targetSpec.getComponents().forEach(compSpec -> {
                    Component comp = (Component)allComps.get(compSpec.getName());
                    compSpec.setState(comp.getComponentSpec().getState());
                });
                ServiceApiUtil.jsonSerDeser.save(this.fs.getFileSystem(), ServiceApiUtil.getServiceJsonPath(this.fs, this.getName()), targetSpec, true);
            }
            catch (IOException e) {
                LOG.error("Upgrade did not complete because unable to re-write the service definition", (Throwable)e);
                return false;
            }
        }
        try {
            String upgradeVersionToDel = cancelUpgrade ? this.cancelledVersion : this.upgradeVersion;
            LOG.info("[SERVICE]: delete upgrade dir version {}", (Object)upgradeVersionToDel);
            this.fs.deleteClusterUpgradeDir(this.getName(), upgradeVersionToDel);
            for (String comp : this.compsAffectedByUpgrade) {
                String compDirVersionToDel = cancelUpgrade ? this.cancelledVersion : this.serviceSpec.getVersion();
                LOG.info("[SERVICE]: delete {} dir version {}", (Object)comp, (Object)compDirVersionToDel);
                this.fs.deleteComponentDir(compDirVersionToDel, comp);
            }
            if (cancelUpgrade) {
                this.fs.deleteComponentsVersionDirIfEmpty(this.cancelledVersion);
            } else {
                this.fs.deleteComponentsVersionDirIfEmpty(this.serviceSpec.getVersion());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to delete upgrade definition for service {} version {}", (Object)this.getName(), (Object)this.upgradeVersion);
        }
        this.setServiceState(ServiceState.STABLE);
        this.serviceSpec.setVersion(this.upgradeVersion);
        this.upgradeVersion = null;
        this.cancelledVersion = null;
        this.compsAffectedByUpgrade.clear();
        return true;
    }

    private static ServiceState checkIfStable(Service service) {
        for (org.apache.hadoop.yarn.service.api.records.Component comp : service.getComponents()) {
            if (comp.getState().equals((Object)ComponentState.STABLE)) continue;
            return service.getState();
        }
        return ServiceState.STABLE;
    }

    public void checkAndUpdateServiceState() {
        this.writeLock.lock();
        try {
            if (!this.getState().equals((Object)State.UPGRADING)) {
                ServiceMaster.checkAndUpdateServiceState(this.scheduler);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void processUpgradeRequest(String upgradeVersion, boolean autoFinalize, boolean expressUpgrade) throws IOException {
        Service targetSpec = ServiceApiUtil.loadServiceUpgrade(this.context.fs, this.context.service.getName(), upgradeVersion);
        List<org.apache.hadoop.yarn.service.api.records.Component> compsNeedUpgradeList = this.resolveCompsToUpgrade(this.context.service, targetSpec);
        ServiceEvent event = new ServiceEvent(ServiceEventType.UPGRADE).setVersion(upgradeVersion).setAutoFinalize(autoFinalize).setExpressUpgrade(expressUpgrade);
        if (expressUpgrade) {
            HashMap compsNeedUpgradeByName = new HashMap();
            if (compsNeedUpgradeList != null) {
                compsNeedUpgradeList.forEach(component -> compsNeedUpgradeByName.put(component.getName(), component));
            }
            List<String> resolvedComps = ServiceApiUtil.resolveCompsDependency(targetSpec);
            LinkedList<org.apache.hadoop.yarn.service.api.records.Component> orderedCompUpgrade = new LinkedList<org.apache.hadoop.yarn.service.api.records.Component>();
            resolvedComps.forEach(compName -> {
                org.apache.hadoop.yarn.service.api.records.Component component = (org.apache.hadoop.yarn.service.api.records.Component)compsNeedUpgradeByName.get(compName);
                if (component != null) {
                    orderedCompUpgrade.add(component);
                }
            });
            event.setCompsToUpgrade(orderedCompUpgrade);
        } else {
            event.setCompsToUpgrade(compsNeedUpgradeList);
        }
        this.context.scheduler.getDispatcher().getEventHandler().handle((Event)event);
        if (autoFinalize && (compsNeedUpgradeList == null || compsNeedUpgradeList.isEmpty())) {
            this.context.scheduler.getDispatcher().getEventHandler().handle((Event)new ServiceEvent(ServiceEventType.CHECK_STABLE));
        }
    }

    private List<org.apache.hadoop.yarn.service.api.records.Component> resolveCompsToUpgrade(Service sourceSpec, Service targetSpec) {
        List<org.apache.hadoop.yarn.service.api.records.Component> compsNeedUpgradeList = this.componentsFinder.findTargetComponentSpecs(sourceSpec, targetSpec);
        if (compsNeedUpgradeList != null) {
            compsNeedUpgradeList.removeIf(component -> {
                Component.RestartPolicyEnum restartPolicy = component.getRestartPolicy();
                ComponentRestartPolicy restartPolicyHandler = Component.getRestartPolicyHandler(restartPolicy);
                if (!restartPolicyHandler.allowUpgrades()) {
                    LOG.info("The component {} has a restart policy that doesnt allow upgrades {} ", (Object)component.getName(), (Object)component.getRestartPolicy().toString());
                    return true;
                }
                return false;
            });
        }
        return compsNeedUpgradeList;
    }

    private void setServiceState(ServiceState state) {
        ServiceState curState = this.serviceSpec.getState();
        if (!curState.equals((Object)state)) {
            this.serviceSpec.setState(state);
            LOG.info("[SERVICE] spec state changed from {} -> {}", (Object)curState, (Object)state);
        }
    }

    public String getName() {
        return this.serviceSpec.getName();
    }

    @VisibleForTesting
    Service getServiceSpec() {
        return this.serviceSpec;
    }

    public static enum State {
        STABLE,
        UPGRADING;

    }

    private static class CancelUpgradeTransition
    implements SingleArcTransition<ServiceManager, ServiceEvent> {
        private CancelUpgradeTransition() {
        }

        public void transition(ServiceManager serviceManager, ServiceEvent event) {
            if (!serviceManager.getState().equals((Object)State.UPGRADING)) {
                LOG.info("[SERVICE]: Cannot cancel the upgrade in {} state", (Object)serviceManager.getState());
                return;
            }
            try {
                Service targetSpec = ServiceApiUtil.loadService(((ServiceManager)serviceManager).context.fs, serviceManager.getName());
                Service sourceSpec = ServiceApiUtil.loadServiceUpgrade(((ServiceManager)serviceManager).context.fs, serviceManager.getName(), serviceManager.upgradeVersion);
                serviceManager.cancelledVersion = serviceManager.upgradeVersion;
                LOG.info("[SERVICE] cancel version {}", (Object)serviceManager.cancelledVersion);
                serviceManager.upgradeVersion = serviceManager.serviceSpec.getVersion();
                serviceManager.componentsToUpgrade = serviceManager.resolveCompsToUpgrade(sourceSpec, targetSpec);
                serviceManager.compsAffectedByUpgrade.clear();
                serviceManager.componentsToUpgrade.forEach(comp -> serviceManager.compsAffectedByUpgrade.add(comp.getName()));
                serviceManager.dispatchNeedUpgradeEvents(true);
                serviceManager.upgradeNextCompIfAny(true);
                serviceManager.setServiceState(ServiceState.CANCEL_UPGRADING);
            }
            catch (Throwable e) {
                LOG.error("[SERVICE]: Cancellation of upgrade failed", e);
            }
        }
    }

    private static class StartFromUpgradeTransition
    implements MultipleArcTransition<ServiceManager, ServiceEvent, State> {
        private StartFromUpgradeTransition() {
        }

        public State transition(ServiceManager serviceManager, ServiceEvent event) {
            ServiceState currState = serviceManager.serviceSpec.getState();
            ServiceState targetState = ServiceManager.checkIfStable(serviceManager.serviceSpec);
            if (targetState.equals((Object)ServiceState.STABLE) && serviceManager.finalizeUpgrade(currState.equals((Object)ServiceState.CANCEL_UPGRADING))) {
                return State.STABLE;
            }
            return State.UPGRADING;
        }
    }

    private static class CheckStableTransition
    implements MultipleArcTransition<ServiceManager, ServiceEvent, State> {
        private CheckStableTransition() {
        }

        public State transition(ServiceManager serviceManager, ServiceEvent event) {
            ServiceState targetState;
            ServiceState currState = serviceManager.serviceSpec.getState();
            if (currState.equals((Object)ServiceState.STABLE)) {
                return State.STABLE;
            }
            if ((currState.equals((Object)ServiceState.EXPRESS_UPGRADING) || currState.equals((Object)ServiceState.CANCEL_UPGRADING)) && !serviceManager.componentsToUpgrade.isEmpty()) {
                org.apache.hadoop.yarn.service.api.records.Component compSpec = (org.apache.hadoop.yarn.service.api.records.Component)serviceManager.componentsToUpgrade.get(0);
                Component component = serviceManager.scheduler.getAllComponents().get(compSpec.getName());
                if (!component.isUpgrading()) {
                    serviceManager.componentsToUpgrade.remove(0);
                    serviceManager.upgradeNextCompIfAny(currState.equals((Object)ServiceState.CANCEL_UPGRADING));
                }
            }
            if ((currState.equals((Object)ServiceState.UPGRADING_AUTO_FINALIZE) || (currState.equals((Object)ServiceState.EXPRESS_UPGRADING) || currState.equals((Object)ServiceState.CANCEL_UPGRADING)) && serviceManager.componentsToUpgrade.isEmpty()) && (targetState = ServiceManager.checkIfStable(serviceManager.serviceSpec)).equals((Object)ServiceState.STABLE) && serviceManager.finalizeUpgrade(currState.equals((Object)ServiceState.CANCEL_UPGRADING))) {
                return State.STABLE;
            }
            return State.UPGRADING;
        }
    }

    private static class StartUpgradeTransition
    implements MultipleArcTransition<ServiceManager, ServiceEvent, State> {
        private StartUpgradeTransition() {
        }

        public State transition(ServiceManager serviceManager, ServiceEvent event) {
            serviceManager.upgradeVersion = event.getVersion();
            serviceManager.componentsToUpgrade = event.getCompsToUpgrade();
            event.getCompsToUpgrade().forEach(comp -> serviceManager.compsAffectedByUpgrade.add(comp.getName()));
            try {
                if (event.isExpressUpgrade()) {
                    serviceManager.dispatchNeedUpgradeEvents(false);
                    serviceManager.upgradeNextCompIfAny(false);
                } else {
                    serviceManager.dispatchNeedUpgradeEvents(false);
                }
                if (event.isExpressUpgrade()) {
                    serviceManager.setServiceState(ServiceState.EXPRESS_UPGRADING);
                } else if (event.isAutoFinalize()) {
                    serviceManager.setServiceState(ServiceState.UPGRADING_AUTO_FINALIZE);
                } else {
                    serviceManager.setServiceState(ServiceState.UPGRADING);
                }
                return State.UPGRADING;
            }
            catch (Throwable e) {
                LOG.error("[SERVICE]: Upgrade to version {} failed", (Object)event.getVersion(), (Object)e);
                return State.STABLE;
            }
        }
    }
}

