/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.SubApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineAggregationTrack;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationTableRW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HBaseTimelineWriterImpl
extends AbstractService
implements TimelineWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTimelineWriterImpl.class);
    private Connection conn;
    private TypedBufferedMutator<EntityTable> entityTable;
    private TypedBufferedMutator<AppToFlowTable> appToFlowTable;
    private TypedBufferedMutator<ApplicationTable> applicationTable;
    private TypedBufferedMutator<FlowActivityTable> flowActivityTable;
    private TypedBufferedMutator<FlowRunTable> flowRunTable;
    private TypedBufferedMutator<SubApplicationTable> subApplicationTable;
    private final KeyConverter<String> stringKeyConverter = new StringKeyConverter();
    private final KeyConverter<Long> longKeyConverter = new LongKeyConverter();

    public HBaseTimelineWriterImpl() {
        super(HBaseTimelineWriterImpl.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        Configuration hbaseConf = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(conf);
        this.conn = ConnectionFactory.createConnection((Configuration)hbaseConf);
        this.entityTable = new EntityTableRW().getTableMutator(hbaseConf, this.conn);
        this.appToFlowTable = new AppToFlowTableRW().getTableMutator(hbaseConf, this.conn);
        this.applicationTable = new ApplicationTableRW().getTableMutator(hbaseConf, this.conn);
        this.flowRunTable = new FlowRunTableRW().getTableMutator(hbaseConf, this.conn);
        this.flowActivityTable = new FlowActivityTableRW().getTableMutator(hbaseConf, this.conn);
        this.subApplicationTable = new SubApplicationTableRW().getTableMutator(hbaseConf, this.conn);
        UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.getLoginUser() : UserGroupInformation.getCurrentUser();
        LOG.info("Initialized HBaseTimelineWriterImpl UGI to " + ugi);
    }

    public TimelineWriteResponse write(TimelineCollectorContext context, TimelineEntities data, UserGroupInformation callerUgi) throws IOException {
        TimelineWriteResponse putStatus = new TimelineWriteResponse();
        String clusterId = context.getClusterId();
        String userId = context.getUserId();
        String flowName = context.getFlowName();
        String flowVersion = context.getFlowVersion();
        long flowRunId = context.getFlowRunId();
        String appId = context.getAppId();
        String subApplicationUser = callerUgi.getShortUserName();
        if (flowName == null || appId == null || clusterId == null || userId == null) {
            LOG.warn("Found null for one of: flowName=" + flowName + " appId=" + appId + " userId=" + userId + " clusterId=" + clusterId + " . Not proceeding with writing to hbase");
            return putStatus;
        }
        for (TimelineEntity te : data.getEntities()) {
            byte[] rowKey;
            if (te == null) continue;
            boolean isApplication = ApplicationEntity.isApplicationEntity((TimelineEntity)te);
            if (isApplication) {
                ApplicationRowKey applicationRowKey = new ApplicationRowKey(clusterId, userId, flowName, Long.valueOf(flowRunId), appId);
                rowKey = applicationRowKey.getRowKey();
                this.store(rowKey, te, flowVersion, Tables.APPLICATION_TABLE);
            } else {
                EntityRowKey entityRowKey = new EntityRowKey(clusterId, userId, flowName, Long.valueOf(flowRunId), appId, te.getType(), Long.valueOf(te.getIdPrefix()), te.getId());
                rowKey = entityRowKey.getRowKey();
                this.store(rowKey, te, flowVersion, Tables.ENTITY_TABLE);
            }
            if (!isApplication && SubApplicationEntity.isSubApplicationEntity((TimelineEntity)te)) {
                SubApplicationRowKey subApplicationRowKey = new SubApplicationRowKey(subApplicationUser, clusterId, te.getType(), Long.valueOf(te.getIdPrefix()), te.getId(), userId);
                rowKey = subApplicationRowKey.getRowKey();
                this.store(rowKey, te, flowVersion, Tables.SUBAPPLICATION_TABLE);
            }
            if (!isApplication) continue;
            TimelineEvent event = ApplicationEntity.getApplicationEvent((TimelineEntity)te, (String)"YARN_APPLICATION_CREATED");
            FlowRunRowKey flowRunRowKey = new FlowRunRowKey(clusterId, userId, flowName, Long.valueOf(flowRunId));
            if (event != null) {
                this.onApplicationCreated(flowRunRowKey, clusterId, appId, userId, flowVersion, te, event.getTimestamp());
            }
            this.storeFlowMetricsAppRunning(flowRunRowKey, appId, te);
            event = ApplicationEntity.getApplicationEvent((TimelineEntity)te, (String)"YARN_APPLICATION_FINISHED");
            if (event == null) continue;
            this.onApplicationFinished(flowRunRowKey, flowVersion, appId, te, event.getTimestamp());
        }
        return putStatus;
    }

    private void onApplicationCreated(FlowRunRowKey flowRunRowKey, String clusterId, String appId, String userId, String flowVersion, TimelineEntity te, long appCreatedTimeStamp) throws IOException {
        String flowName = flowRunRowKey.getFlowName();
        Long flowRunId = flowRunRowKey.getFlowRunId();
        AppToFlowRowKey appToFlowRowKey = new AppToFlowRowKey(appId);
        byte[] rowKey = appToFlowRowKey.getRowKey();
        ColumnRWHelper.store(rowKey, this.appToFlowTable, AppToFlowColumnPrefix.FLOW_NAME, clusterId, null, (Object)flowName, new Attribute[0]);
        ColumnRWHelper.store(rowKey, this.appToFlowTable, AppToFlowColumnPrefix.FLOW_RUN_ID, clusterId, null, (Object)flowRunId, new Attribute[0]);
        ColumnRWHelper.store(rowKey, this.appToFlowTable, AppToFlowColumnPrefix.USER_ID, clusterId, null, (Object)userId, new Attribute[0]);
        this.storeAppCreatedInFlowRunTable(flowRunRowKey, appId, te);
        byte[] flowActivityRowKeyBytes = new FlowActivityRowKey(flowRunRowKey.getClusterId(), Long.valueOf(appCreatedTimeStamp), flowRunRowKey.getUserId(), flowName).getRowKey();
        byte[] qualifier = this.longKeyConverter.encode((Object)flowRunRowKey.getFlowRunId());
        ColumnRWHelper.store(flowActivityRowKeyBytes, this.flowActivityTable, FlowActivityColumnPrefix.RUN_ID, qualifier, null, (Object)flowVersion, new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void storeAppCreatedInFlowRunTable(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te) throws IOException {
        byte[] rowKey = flowRunRowKey.getRowKey();
        ColumnRWHelper.store(rowKey, this.flowRunTable, FlowRunColumn.MIN_START_TIME, null, (Object)te.getCreatedTime(), new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void onApplicationFinished(FlowRunRowKey flowRunRowKey, String flowVersion, String appId, TimelineEntity te, long appFinishedTimeStamp) throws IOException {
        this.storeAppFinishedInFlowRunTable(flowRunRowKey, appId, te, appFinishedTimeStamp);
        byte[] rowKey = new FlowActivityRowKey(flowRunRowKey.getClusterId(), Long.valueOf(appFinishedTimeStamp), flowRunRowKey.getUserId(), flowRunRowKey.getFlowName()).getRowKey();
        byte[] qualifier = this.longKeyConverter.encode((Object)flowRunRowKey.getFlowRunId());
        ColumnRWHelper.store(rowKey, this.flowActivityTable, FlowActivityColumnPrefix.RUN_ID, qualifier, null, (Object)flowVersion, new Attribute[]{AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId)});
    }

    private void storeAppFinishedInFlowRunTable(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te, long appFinishedTimeStamp) throws IOException {
        byte[] rowKey = flowRunRowKey.getRowKey();
        Attribute attributeAppId = AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId);
        ColumnRWHelper.store(rowKey, this.flowRunTable, FlowRunColumn.MAX_END_TIME, null, (Object)appFinishedTimeStamp, new Attribute[]{attributeAppId});
        Set metrics = te.getMetrics();
        if (metrics != null) {
            this.storeFlowMetrics(rowKey, metrics, attributeAppId, AggregationOperation.SUM_FINAL.getAttribute());
        }
    }

    private void storeFlowMetricsAppRunning(FlowRunRowKey flowRunRowKey, String appId, TimelineEntity te) throws IOException {
        Set metrics = te.getMetrics();
        if (metrics != null) {
            byte[] rowKey = flowRunRowKey.getRowKey();
            this.storeFlowMetrics(rowKey, metrics, AggregationCompactionDimension.APPLICATION_ID.getAttribute(appId), AggregationOperation.SUM.getAttribute());
        }
    }

    private void storeFlowMetrics(byte[] rowKey, Set<TimelineMetric> metrics, Attribute ... attributes) throws IOException {
        for (TimelineMetric metric : metrics) {
            byte[] metricColumnQualifier = this.stringKeyConverter.encode((Object)metric.getId());
            Map timeseries = metric.getValues();
            for (Map.Entry timeseriesEntry : timeseries.entrySet()) {
                Long timestamp = (Long)timeseriesEntry.getKey();
                ColumnRWHelper.store(rowKey, this.flowRunTable, FlowRunColumnPrefix.METRIC, metricColumnQualifier, timestamp, timeseriesEntry.getValue(), attributes);
            }
        }
    }

    private <T extends BaseTable<T>> void storeRelations(byte[] rowKey, Map<String, Set<String>> connectedEntities, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        if (connectedEntities != null) {
            for (Map.Entry<String, Set<String>> connectedEntity : connectedEntities.entrySet()) {
                String compoundValue = Separator.VALUES.joinEncoded((Iterable)connectedEntity.getValue());
                ColumnRWHelper.store(rowKey, table, columnPrefix, this.stringKeyConverter.encode((Object)connectedEntity.getKey()), null, (Object)compoundValue, new Attribute[0]);
            }
        }
    }

    private void store(byte[] rowKey, TimelineEntity te, String flowVersion, Tables table) throws IOException {
        switch (table) {
            case APPLICATION_TABLE: {
                ColumnRWHelper.store(rowKey, this.applicationTable, ApplicationColumn.ID, null, te.getId(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.applicationTable, ApplicationColumn.CREATED_TIME, null, (Object)te.getCreatedTime(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.applicationTable, ApplicationColumn.FLOW_VERSION, null, flowVersion, new Attribute[0]);
                this.storeInfo(rowKey, te.getInfo(), flowVersion, (ColumnPrefix)ApplicationColumnPrefix.INFO, this.applicationTable);
                this.storeMetrics(rowKey, te.getMetrics(), (ColumnPrefix)ApplicationColumnPrefix.METRIC, this.applicationTable);
                this.storeEvents(rowKey, te.getEvents(), (ColumnPrefix)ApplicationColumnPrefix.EVENT, this.applicationTable);
                this.storeConfig(rowKey, te.getConfigs(), (ColumnPrefix)ApplicationColumnPrefix.CONFIG, this.applicationTable);
                this.storeRelations(rowKey, te.getIsRelatedToEntities(), (ColumnPrefix)ApplicationColumnPrefix.IS_RELATED_TO, this.applicationTable);
                this.storeRelations(rowKey, te.getRelatesToEntities(), (ColumnPrefix)ApplicationColumnPrefix.RELATES_TO, this.applicationTable);
                break;
            }
            case ENTITY_TABLE: {
                ColumnRWHelper.store(rowKey, this.entityTable, EntityColumn.ID, null, te.getId(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.entityTable, EntityColumn.TYPE, null, te.getType(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.entityTable, EntityColumn.CREATED_TIME, null, (Object)te.getCreatedTime(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.entityTable, EntityColumn.FLOW_VERSION, null, flowVersion, new Attribute[0]);
                this.storeInfo(rowKey, te.getInfo(), flowVersion, (ColumnPrefix)EntityColumnPrefix.INFO, this.entityTable);
                this.storeMetrics(rowKey, te.getMetrics(), (ColumnPrefix)EntityColumnPrefix.METRIC, this.entityTable);
                this.storeEvents(rowKey, te.getEvents(), (ColumnPrefix)EntityColumnPrefix.EVENT, this.entityTable);
                this.storeConfig(rowKey, te.getConfigs(), (ColumnPrefix)EntityColumnPrefix.CONFIG, this.entityTable);
                this.storeRelations(rowKey, te.getIsRelatedToEntities(), (ColumnPrefix)EntityColumnPrefix.IS_RELATED_TO, this.entityTable);
                this.storeRelations(rowKey, te.getRelatesToEntities(), (ColumnPrefix)EntityColumnPrefix.RELATES_TO, this.entityTable);
                break;
            }
            case SUBAPPLICATION_TABLE: {
                ColumnRWHelper.store(rowKey, this.subApplicationTable, SubApplicationColumn.ID, null, te.getId(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.subApplicationTable, SubApplicationColumn.TYPE, null, te.getType(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.subApplicationTable, SubApplicationColumn.CREATED_TIME, null, (Object)te.getCreatedTime(), new Attribute[0]);
                ColumnRWHelper.store(rowKey, this.subApplicationTable, SubApplicationColumn.FLOW_VERSION, null, flowVersion, new Attribute[0]);
                this.storeInfo(rowKey, te.getInfo(), flowVersion, (ColumnPrefix)SubApplicationColumnPrefix.INFO, this.subApplicationTable);
                this.storeMetrics(rowKey, te.getMetrics(), (ColumnPrefix)SubApplicationColumnPrefix.METRIC, this.subApplicationTable);
                this.storeEvents(rowKey, te.getEvents(), (ColumnPrefix)SubApplicationColumnPrefix.EVENT, this.subApplicationTable);
                this.storeConfig(rowKey, te.getConfigs(), (ColumnPrefix)SubApplicationColumnPrefix.CONFIG, this.subApplicationTable);
                this.storeRelations(rowKey, te.getIsRelatedToEntities(), (ColumnPrefix)SubApplicationColumnPrefix.IS_RELATED_TO, this.subApplicationTable);
                this.storeRelations(rowKey, te.getRelatesToEntities(), (ColumnPrefix)SubApplicationColumnPrefix.RELATES_TO, this.subApplicationTable);
                break;
            }
            default: {
                LOG.info("Invalid table name provided.");
            }
        }
    }

    private <T extends BaseTable<T>> void storeInfo(byte[] rowKey, Map<String, Object> info, String flowVersion, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        if (info != null) {
            for (Map.Entry<String, Object> entry : info.entrySet()) {
                ColumnRWHelper.store(rowKey, table, columnPrefix, this.stringKeyConverter.encode((Object)entry.getKey()), null, entry.getValue(), new Attribute[0]);
            }
        }
    }

    private <T extends BaseTable<T>> void storeConfig(byte[] rowKey, Map<String, String> config, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        if (config != null) {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                byte[] configKey = this.stringKeyConverter.encode((Object)entry.getKey());
                ColumnRWHelper.store(rowKey, table, columnPrefix, configKey, null, (Object)entry.getValue(), new Attribute[0]);
            }
        }
    }

    private <T extends BaseTable<T>> void storeMetrics(byte[] rowKey, Set<TimelineMetric> metrics, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        if (metrics != null) {
            for (TimelineMetric metric : metrics) {
                byte[] metricColumnQualifier = this.stringKeyConverter.encode((Object)metric.getId());
                Map timeseries = metric.getValues();
                for (Map.Entry timeseriesEntry : timeseries.entrySet()) {
                    Long timestamp = (Long)timeseriesEntry.getKey();
                    ColumnRWHelper.store(rowKey, table, columnPrefix, metricColumnQualifier, timestamp, timeseriesEntry.getValue(), new Attribute[0]);
                }
            }
        }
    }

    private <T extends BaseTable<T>> void storeEvents(byte[] rowKey, Set<TimelineEvent> events, ColumnPrefix<T> columnPrefix, TypedBufferedMutator<T> table) throws IOException {
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                String eventId;
                if (event == null || (eventId = event.getId()) == null) continue;
                long eventTimestamp = event.getTimestamp();
                if (eventTimestamp == 0L) {
                    LOG.warn("timestamp is not set for event " + eventId + "! Using the current timestamp");
                    eventTimestamp = System.currentTimeMillis();
                }
                if ((eventInfo = event.getInfo()) == null || eventInfo.size() == 0) {
                    byte[] columnQualifierBytes = new EventColumnName(eventId, Long.valueOf(eventTimestamp), null).getColumnQualifier();
                    ColumnRWHelper.store(rowKey, table, columnPrefix, columnQualifierBytes, null, (Object)Separator.EMPTY_BYTES, new Attribute[0]);
                    continue;
                }
                for (Map.Entry info : eventInfo.entrySet()) {
                    byte[] columnQualifierBytes = new EventColumnName(eventId, Long.valueOf(eventTimestamp), (String)info.getKey()).getColumnQualifier();
                    ColumnRWHelper.store(rowKey, table, columnPrefix, columnQualifierBytes, null, info.getValue(), new Attribute[0]);
                }
            }
        }
    }

    public TimelineWriteResponse aggregate(TimelineEntity data, TimelineAggregationTrack track) throws IOException {
        return null;
    }

    public void flush() throws IOException {
        this.entityTable.flush();
        this.appToFlowTable.flush();
        this.applicationTable.flush();
        this.flowRunTable.flush();
        this.flowActivityTable.flush();
        this.subApplicationTable.flush();
    }

    protected void serviceStop() throws Exception {
        if (this.entityTable != null) {
            LOG.info("closing the entity table");
            this.entityTable.close();
        }
        if (this.appToFlowTable != null) {
            LOG.info("closing the app_flow table");
            this.appToFlowTable.close();
        }
        if (this.applicationTable != null) {
            LOG.info("closing the application table");
            this.applicationTable.close();
        }
        if (this.flowRunTable != null) {
            LOG.info("closing the flow run table");
            this.flowRunTable.close();
        }
        if (this.flowActivityTable != null) {
            LOG.info("closing the flowActivityTable table");
            this.flowActivityTable.close();
        }
        if (this.subApplicationTable != null) {
            this.subApplicationTable.close();
        }
        if (this.conn != null) {
            LOG.info("closing the hbase Connection");
            this.conn.close();
        }
        super.serviceStop();
    }

    private static enum Tables {
        APPLICATION_TABLE,
        ENTITY_TABLE,
        SUBAPPLICATION_TABLE;

    }
}

