/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.aliasmap;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.common.FileRegion;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface InMemoryAliasMapProtocol {
    public IterationResult list(Optional<Block> var1) throws IOException;

    @Nonnull
    public Optional<ProvidedStorageLocation> read(@Nonnull Block var1) throws IOException;

    public void write(@Nonnull Block var1, @Nonnull ProvidedStorageLocation var2) throws IOException;

    public String getBlockPoolId() throws IOException;

    public static class IterationResult {
        private final List<FileRegion> batch;
        private final Optional<Block> nextMarker;

        public IterationResult(List<FileRegion> batch, Optional<Block> nextMarker) {
            this.batch = batch;
            this.nextMarker = nextMarker;
        }

        public List<FileRegion> getFileRegions() {
            return this.batch;
        }

        public Optional<Block> getNextBlock() {
            return this.nextMarker;
        }
    }
}

