/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.net.URI;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.htrace.core.HTraceConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestTraceUtils {
    private static String TEST_PREFIX = "test.prefix.htrace.";

    @Test
    public void testWrappedHadoopConf() {
        String key = "sampler";
        String value = "ProbabilitySampler";
        Configuration conf = new Configuration();
        conf.set(TEST_PREFIX + key, value);
        HTraceConfiguration wrapped = TraceUtils.wrapHadoopConf((String)TEST_PREFIX, (Configuration)conf);
        Assert.assertEquals((Object)value, (Object)wrapped.get(key));
    }

    @Test
    public void testExtraConfig() {
        String key = "test.extra.config";
        String oldValue = "old value";
        String newValue = "new value";
        Configuration conf = new Configuration();
        conf.set(TEST_PREFIX + key, oldValue);
        LinkedList<SpanReceiverInfo.ConfigurationPair> extraConfig = new LinkedList<SpanReceiverInfo.ConfigurationPair>();
        extraConfig.add(new SpanReceiverInfo.ConfigurationPair(TEST_PREFIX + key, newValue));
        HTraceConfiguration wrapped = TraceUtils.wrapHadoopConf((String)TEST_PREFIX, (Configuration)conf, extraConfig);
        Assert.assertEquals((Object)newValue, (Object)wrapped.get(key));
    }

    @Test
    public void testTracingGlobber() throws Exception {
        LocalFileSystem fs = new LocalFileSystem();
        fs.initialize(new URI("file:///"), new Configuration());
        fs.globStatus(new Path("/"));
        fs.close();
    }
}

