/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileUtil.class);
    private static final File TEST_DIR = GenericTestUtils.getTestDir("fu");
    private static final String FILE = "x";
    private static final String LINK = "y";
    private static final String DIR = "dir";
    private final File del = new File(TEST_DIR, "del");
    private final File tmp = new File(TEST_DIR, "tmp");
    private final File dir1 = new File(this.del, "dir1");
    private final File dir2 = new File(this.del, "dir2");
    private final File partitioned = new File(TEST_DIR, "partitioned");
    private InetAddress inet1;
    private InetAddress inet2;
    private InetAddress inet3;
    private InetAddress inet4;
    private InetAddress inet5;
    private InetAddress inet6;
    private URI uri1;
    private URI uri2;
    private URI uri3;
    private URI uri4;
    private URI uri5;
    private URI uri6;
    private FileSystem fs1;
    private FileSystem fs2;
    private FileSystem fs3;
    private FileSystem fs4;
    private FileSystem fs5;
    private FileSystem fs6;
    private final File xSubDir = new File(this.del, "xSubDir");
    private final File xSubSubDir = new File(this.xSubDir, "xSubSubDir");
    private final File ySubDir = new File(this.del, "ySubDir");
    private static final String file1Name = "file1";
    private final File file2 = new File(this.xSubDir, "file2");
    private final File file22 = new File(this.xSubSubDir, "file22");
    private final File file3 = new File(this.ySubDir, "file3");
    private final File zlink = new File(this.del, "zlink");

    @Ignore
    private void setupDirs() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertFalse((boolean)this.partitioned.exists());
        this.del.mkdirs();
        this.tmp.mkdirs();
        this.partitioned.mkdirs();
        new File(this.del, FILE).createNewFile();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        this.dir1.mkdirs();
        this.dir2.mkdirs();
        new File(this.dir1, FILE).createNewFile();
        new File(this.dir2, FILE).createNewFile();
        File link = new File(this.del, LINK);
        FileUtil.symLink((String)tmpFile.toString(), (String)link.toString());
        File linkDir = new File(this.del, "tmpDir");
        FileUtil.symLink((String)this.tmp.toString(), (String)linkDir.toString());
        Assert.assertEquals((long)5L, (long)this.del.listFiles().length);
        this.createFile(this.partitioned, "part-r-00000", "foo");
        this.createFile(this.partitioned, "part-r-00001", "bar");
        FileUtil.symLink((String)this.del.toString(), (String)(this.dir1.toString() + "/cycle"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(File directory, String name, String contents) throws IOException {
        File newFile = new File(directory, name);
        try (PrintWriter pw = new PrintWriter(newFile);){
            pw.println(contents);
        }
        return newFile;
    }

    @Test(timeout=30000L)
    public void testListFiles() throws IOException {
        this.setupDirs();
        File[] files = FileUtil.listFiles((File)this.partitioned);
        Assert.assertEquals((long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.listFiles((File)newDir);
        Assert.assertEquals((long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.listFiles((File)newDir);
            Assert.fail((String)("IOException expected on listFiles() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testListAPI() throws IOException {
        this.setupDirs();
        String[] files = FileUtil.list((File)this.partitioned);
        Assert.assertEquals((String)"Unexpected number of pre-existing files", (long)2L, (long)files.length);
        File newDir = new File(this.tmp.getPath(), "test");
        newDir.mkdir();
        Assert.assertTrue((String)"Failed to create test dir", (boolean)newDir.exists());
        files = FileUtil.list((File)newDir);
        Assert.assertEquals((String)"New directory unexpectedly contains files", (long)0L, (long)files.length);
        newDir.delete();
        Assert.assertFalse((String)"Failed to delete test dir", (boolean)newDir.exists());
        try {
            files = FileUtil.list((File)newDir);
            Assert.fail((String)("IOException expected on list() for non-existent dir " + newDir.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Before
    public void before() throws IOException {
        this.cleanupImpl();
    }

    @After
    public void tearDown() throws IOException {
        this.cleanupImpl();
    }

    private void cleanupImpl() throws IOException {
        FileUtil.fullyDelete((File)this.del, (boolean)true);
        Assert.assertTrue((!this.del.exists() ? 1 : 0) != 0);
        FileUtil.fullyDelete((File)this.tmp, (boolean)true);
        Assert.assertTrue((!this.tmp.exists() ? 1 : 0) != 0);
        FileUtil.fullyDelete((File)this.partitioned, (boolean)true);
        Assert.assertTrue((!this.partitioned.exists() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testFullyDelete() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.del.exists());
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteSymlinks() throws IOException {
        this.setupDirs();
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        boolean ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)link.exists());
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        this.validateTmpDir();
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)linkDir.exists());
        Assert.assertEquals((long)3L, (long)this.del.list().length);
        this.validateTmpDir();
    }

    @Test(timeout=30000L)
    public void testFullyDeleteDanglingSymlinks() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete((File)this.tmp);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.tmp.exists());
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)3L, (long)this.del.list().length);
    }

    @Test(timeout=30000L)
    public void testFullyDeleteContents() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDeleteContents((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertTrue((boolean)this.del.exists());
        Assert.assertEquals((long)0L, (long)this.del.listFiles().length);
        this.validateTmpDir();
    }

    private void validateTmpDir() {
        Assert.assertTrue((boolean)this.tmp.exists());
        Assert.assertEquals((long)1L, (long)this.tmp.listFiles().length);
        Assert.assertTrue((boolean)new File(this.tmp, FILE).exists());
    }

    private void setupDirsAndNonWritablePermissions() throws IOException {
        Assert.assertFalse((String)"The directory del should not have existed!", (boolean)this.del.exists());
        this.del.mkdirs();
        new MyFile(this.del, file1Name).createNewFile();
        this.xSubDir.mkdirs();
        this.file2.createNewFile();
        this.xSubSubDir.mkdirs();
        this.file22.createNewFile();
        TestFileUtil.revokePermissions(this.file22);
        TestFileUtil.revokePermissions(this.xSubSubDir);
        TestFileUtil.revokePermissions(this.file2);
        TestFileUtil.revokePermissions(this.xSubDir);
        this.ySubDir.mkdirs();
        this.file3.createNewFile();
        Assert.assertFalse((String)"The directory tmp should not have existed!", (boolean)this.tmp.exists());
        this.tmp.mkdirs();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        FileUtil.symLink((String)tmpFile.toString(), (String)this.zlink.toString());
    }

    private static void grantPermissions(File f) {
        FileUtil.setReadable((File)f, (boolean)true);
        FileUtil.setWritable((File)f, (boolean)true);
        FileUtil.setExecutable((File)f, (boolean)true);
    }

    private static void revokePermissions(File f) {
        FileUtil.setWritable((File)f, (boolean)false);
        FileUtil.setExecutable((File)f, (boolean)false);
        FileUtil.setReadable((File)f, (boolean)false);
    }

    private void validateAndSetWritablePermissions(boolean expectedRevokedPermissionDirsExist, boolean ret) {
        TestFileUtil.grantPermissions(this.xSubDir);
        TestFileUtil.grantPermissions(this.xSubSubDir);
        Assert.assertFalse((String)"The return value should have been false.", (boolean)ret);
        Assert.assertTrue((String)"The file file1 should not have been deleted.", (boolean)new File(this.del, file1Name).exists());
        Assert.assertEquals((String)"The directory xSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubDir.exists());
        Assert.assertEquals((String)"The file file2 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file2.exists());
        Assert.assertEquals((String)"The directory xSubSubDir *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.xSubSubDir.exists());
        Assert.assertEquals((String)"The file file22 *should* not have been deleted.", (Object)expectedRevokedPermissionDirsExist, (Object)this.file22.exists());
        Assert.assertFalse((String)"The directory ySubDir should have been deleted.", (boolean)this.ySubDir.exists());
        Assert.assertFalse((String)"The link zlink should have been deleted.", (boolean)this.zlink.exists());
    }

    @Test(timeout=30000L)
    public void testFailFullyDelete() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        LOG.info("Running test to verify failure of fullyDelete()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del), (boolean)true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContents() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        LOG.info("Running test to verify failure of fullyDeleteContents()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(true, ret);
    }

    @Test(timeout=30000L)
    public void testFailFullyDeleteContentsGrantPermissions() throws IOException {
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del), (boolean)true);
        this.validateAndSetWritablePermissions(false, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testGetDU() throws Exception {
        this.setupDirs();
        long du = FileUtil.getDU((File)TEST_DIR);
        long expected = 2 * (3 + System.getProperty("line.separator").length());
        Assert.assertEquals((long)expected, (long)du);
        File doesNotExist = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        long duDoesNotExist = FileUtil.getDU((File)doesNotExist);
        Assert.assertEquals((long)0L, (long)duDoesNotExist);
        File notADirectory = new File(this.partitioned, "part-r-00000");
        long duNotADirectoryActual = FileUtil.getDU((File)notADirectory);
        long duNotADirectoryExpected = 3 + System.getProperty("line.separator").length();
        Assert.assertEquals((long)duNotADirectoryExpected, (long)duNotADirectoryActual);
        try {
            try {
                FileUtil.chmod((String)notADirectory.getAbsolutePath(), (String)"0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)FileUtil.canRead((File)notADirectory));
            long du3 = FileUtil.getDU((File)this.partitioned);
            Assert.assertEquals((long)expected, (long)du3);
            try {
                FileUtil.chmod((String)this.partitioned.getAbsolutePath(), (String)"0000");
            }
            catch (InterruptedException ie) {
                Assert.assertNull((Object)ie);
            }
            Assert.assertFalse((boolean)FileUtil.canRead((File)this.partitioned));
            long du4 = FileUtil.getDU((File)this.partitioned);
            Assert.assertEquals((long)0L, (long)du4);
        }
        finally {
            FileUtil.chmod((String)this.partitioned.getAbsolutePath(), (String)"0777", (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testUnTar() throws IOException {
        this.setupDirs();
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        try (TarOutputStream tos = new TarOutputStream((OutputStream)os);){
            TarEntry te = new TarEntry("/bar/foo");
            byte[] data = "some-content".getBytes("UTF-8");
            te.setSize((long)data.length);
            tos.putNextEntry(te);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        FileUtil.unTar((File)simpleTar, (File)this.tmp);
        Assert.assertTrue((boolean)new File(this.tmp, "/bar/foo").exists());
        Assert.assertEquals((long)12L, (long)new File(this.tmp, "/bar/foo").length());
        File regularFile = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        regularFile.createNewFile();
        Assert.assertTrue((boolean)regularFile.exists());
        try {
            FileUtil.unTar((File)simpleTar, (File)regularFile);
            Assert.assertTrue((String)"An IOException expected.", (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testReplaceFile() throws IOException {
        this.setupDirs();
        File srcFile = new File(this.tmp, "src");
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        File targetFile = new File(this.tmp, "target");
        Assert.assertTrue((!targetFile.exists() ? 1 : 0) != 0);
        FileUtil.replaceFile((File)srcFile, (File)targetFile);
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)targetFile.exists());
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        FileUtil.replaceFile((File)srcFile, (File)targetFile);
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)targetFile.exists());
        srcFile.createNewFile();
        Assert.assertTrue((boolean)srcFile.exists());
        targetFile.delete();
        targetFile.mkdirs();
        File obstacle = new File(targetFile, "obstacle");
        obstacle.createNewFile();
        Assert.assertTrue((boolean)obstacle.exists());
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        try {
            FileUtil.replaceFile((File)srcFile, (File)targetFile);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)srcFile.exists());
        Assert.assertTrue((targetFile.exists() && targetFile.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)obstacle.exists());
    }

    @Test(timeout=30000L)
    public void testCreateLocalTempFile() throws IOException {
        this.setupDirs();
        File baseFile = new File(this.tmp, "base");
        File tmp1 = FileUtil.createLocalTempFile((File)baseFile, (String)"foo", (boolean)false);
        File tmp2 = FileUtil.createLocalTempFile((File)baseFile, (String)"foo", (boolean)true);
        Assert.assertFalse((boolean)tmp1.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertFalse((boolean)tmp2.getAbsolutePath().equals(baseFile.getAbsolutePath()));
        Assert.assertTrue((tmp1.exists() && tmp2.exists() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canWrite() && tmp2.canWrite() ? 1 : 0) != 0);
        Assert.assertTrue((tmp1.canRead() && tmp2.canRead() ? 1 : 0) != 0);
        tmp1.delete();
        tmp2.delete();
        Assert.assertTrue((!tmp1.exists() && !tmp2.exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testUnZip() throws IOException {
        this.setupDirs();
        File simpleZip = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleZip);
        try (ZipOutputStream tos = new ZipOutputStream(os);){
            ZipEntry ze = new ZipEntry("foo");
            byte[] data = "some-content".getBytes("UTF-8");
            ze.setSize(data.length);
            tos.putNextEntry(ze);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        FileUtil.unZip((File)simpleZip, (File)this.tmp);
        Assert.assertTrue((boolean)new File(this.tmp, "foo").exists());
        Assert.assertEquals((long)12L, (long)new File(this.tmp, "foo").length());
        File regularFile = new File(this.tmp, "QuickBrownFoxJumpsOverTheLazyDog");
        regularFile.createNewFile();
        Assert.assertTrue((boolean)regularFile.exists());
        try {
            FileUtil.unZip((File)simpleZip, (File)regularFile);
            Assert.assertTrue((String)"An IOException expected.", (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testUnZip2() throws IOException {
        this.setupDirs();
        File simpleZip = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleZip);
        try (ZipOutputStream tos = new ZipOutputStream(os);){
            ZipEntry ze = new ZipEntry("../foo");
            byte[] data = "some-content".getBytes(StandardCharsets.UTF_8);
            ze.setSize(data.length);
            tos.putNextEntry(ze);
            tos.write(data);
            tos.closeEntry();
            tos.flush();
            tos.finish();
        }
        try {
            FileUtil.unZip((File)simpleZip, (File)this.tmp);
            Assert.fail((String)"unZip should throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("would create file outside of", e);
        }
    }

    @Test(timeout=30000L)
    public void testCopy5() throws IOException {
        this.setupDirs();
        URI uri = this.tmp.toURI();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.newInstance((URI)uri, (Configuration)conf);
        String content = "some-content";
        File srcFile = this.createFile(this.tmp, "src", "some-content");
        Path srcPath = new Path(srcFile.toURI());
        File dest = new File(this.del, "dest");
        boolean result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)false, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Assert.assertTrue((boolean)srcFile.exists());
        dest.delete();
        Assert.assertTrue((!dest.exists() ? 1 : 0) != 0);
        result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)true, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((boolean)dest.exists());
        Assert.assertEquals((long)("some-content".getBytes().length + System.getProperty("line.separator").getBytes().length), (long)dest.length());
        Assert.assertTrue((!srcFile.exists() ? 1 : 0) != 0);
        dest.delete();
        Assert.assertTrue((!dest.exists() ? 1 : 0) != 0);
        srcPath = new Path(this.partitioned.toURI());
        result = FileUtil.copy((FileSystem)fs, (Path)srcPath, (File)dest, (boolean)true, (Configuration)conf);
        Assert.assertTrue((boolean)result);
        Assert.assertTrue((dest.exists() && dest.isDirectory() ? 1 : 0) != 0);
        File[] files = dest.listFiles();
        Assert.assertTrue((files != null ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)files.length);
        for (File f : files) {
            Assert.assertEquals((long)(3 + System.getProperty("line.separator").getBytes().length), (long)f.length());
        }
        Assert.assertTrue((!this.partitioned.exists() ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testStat2Paths1() {
        Assert.assertNull((Object)FileUtil.stat2Paths(null));
        FileStatus[] fileStatuses = new FileStatus[]{};
        Path[] paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
        Assert.assertEquals((long)0L, (long)paths.length);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths((FileStatus[])fileStatuses);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testStat2Paths2() {
        Path defaultPath = new Path("file://default");
        Path[] paths = FileUtil.stat2Paths(null, (Path)defaultPath);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)defaultPath, (Object)paths[0]);
        paths = FileUtil.stat2Paths(null, null);
        Assert.assertTrue((paths != null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals(null, (Object)paths[0]);
        Path path1 = new Path("file://foo");
        Path path2 = new Path("file://moo");
        FileStatus[] fileStatuses = new FileStatus[]{new FileStatus(3L, false, 0, 0L, 0L, path1), new FileStatus(3L, false, 0, 0L, 0L, path2)};
        paths = FileUtil.stat2Paths((FileStatus[])fileStatuses, (Path)defaultPath);
        Assert.assertEquals((long)2L, (long)paths.length);
        Assert.assertEquals((Object)paths[0], (Object)path1);
        Assert.assertEquals((Object)paths[1], (Object)path2);
    }

    @Test(timeout=30000L)
    public void testSymlink() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        byte[] data = "testSymLink".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        FileInputStream in = new FileInputStream(link);
        long len = 0L;
        while (in.read() > 0) {
            ++len;
        }
        in.close();
        Assert.assertEquals((long)data.length, (long)len);
    }

    @Test(timeout=30000L)
    public void testSymlinkRenameTo() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link.exists());
        File link2 = new File(this.del, "_link2");
        Assert.assertTrue((boolean)link.renameTo(link2));
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link2.exists());
        Assert.assertFalse((boolean)link.exists());
    }

    @Test(timeout=30000L)
    public void testSymlinkDelete() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        file.createNewFile();
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)link.exists());
        Assert.assertTrue((boolean)link.delete());
        Assert.assertFalse((boolean)link.exists());
        Assert.assertTrue((boolean)file.exists());
    }

    @Test(timeout=30000L)
    public void testSymlinkLength() throws Exception {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        byte[] data = "testSymLinkData".getBytes();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileOutputStream os = new FileOutputStream(file);
        os.write(data);
        os.close();
        Assert.assertEquals((long)0L, (long)link.length());
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        Assert.assertEquals((long)data.length, (long)file.length());
        Assert.assertEquals((long)data.length, (long)link.length());
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((long)0L, (long)link.length());
        link.delete();
        Assert.assertFalse((boolean)link.exists());
    }

    private void doUntarAndVerify(File tarFile, File untarDir) throws IOException {
        if (untarDir.exists() && !FileUtil.fullyDelete((File)untarDir)) {
            throw new IOException("Could not delete directory '" + untarDir + "'");
        }
        FileUtil.unTar((File)tarFile, (File)untarDir);
        String parentDir = untarDir.getCanonicalPath() + "/" + "name";
        File testFile = new File(parentDir + "/" + "version");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 0L ? 1 : 0) != 0);
        String imageDir = parentDir + "/" + "image";
        testFile = new File(imageDir + "/" + "fsimage");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 157L ? 1 : 0) != 0);
        String currentDir = parentDir + "/" + "current";
        testFile = new File(currentDir + "/" + "fsimage");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 4331L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "edits");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 1033L ? 1 : 0) != 0);
        testFile = new File(currentDir + "/" + "fstime");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((testFile.length() == 8L ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testUntar() throws IOException {
        String tarGzFileName = System.getProperty("test.cache.data", "target/test/cache") + "/test-untar.tgz";
        String tarFileName = System.getProperty("test.cache.data", "build/test/cache") + "/test-untar.tar";
        File dataDir = GenericTestUtils.getTestDir();
        File untarDir = new File(dataDir, "untarDir");
        this.doUntarAndVerify(new File(tarGzFileName), untarDir);
        this.doUntarAndVerify(new File(tarFileName), untarDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCreateJarWithClassPath() throws Exception {
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertTrue((boolean)this.tmp.mkdirs());
        List<File> wildcardMatches = Arrays.asList(new File(this.tmp, "wildcard1.jar"), new File(this.tmp, "wildcard2.jar"), new File(this.tmp, "wildcard3.JAR"), new File(this.tmp, "wildcard4.JAR"));
        for (File wildcardMatch : wildcardMatches) {
            Assert.assertTrue((String)("failure creating file: " + wildcardMatch), (boolean)wildcardMatch.createNewFile());
        }
        Assert.assertTrue((boolean)new File(this.tmp, "text.txt").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "executable.exe").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "README").createNewFile());
        String wildcardPath = this.tmp.getCanonicalPath() + File.separator + "*";
        String nonExistentSubdir = this.tmp.getCanonicalPath() + "/" + "subdir" + "/";
        List<String> classPaths = Arrays.asList("", "cp1.jar", "cp2.jar", wildcardPath, "cp3.jar", nonExistentSubdir);
        String inputClassPath = StringUtils.join((CharSequence)File.pathSeparator, classPaths);
        String[] jarCp = FileUtil.createJarWithClassPath((String)(inputClassPath + File.pathSeparator + "unexpandedwildcard/*"), (Path)new Path(this.tmp.getCanonicalPath()), System.getenv());
        String classPathJar = jarCp[0];
        Assert.assertNotEquals((String)"Unexpanded wildcard was not placed in extra classpath", (long)jarCp[1].indexOf("unexpanded"), (long)-1L);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(classPathJar);
            Manifest jarManifest = jarFile.getManifest();
            Assert.assertNotNull((Object)jarManifest);
            Attributes mainAttributes = jarManifest.getMainAttributes();
            Assert.assertNotNull((Object)mainAttributes);
            Assert.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.CLASS_PATH));
            String classPathAttr = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            Assert.assertNotNull((Object)classPathAttr);
            ArrayList<String> expectedClassPaths = new ArrayList<String>();
            for (String classPath : classPaths) {
                if (classPath.length() == 0) continue;
                if (wildcardPath.equals(classPath)) {
                    for (File wildcardMatch : wildcardMatches) {
                        expectedClassPaths.add(wildcardMatch.toURI().toURL().toExternalForm());
                    }
                    continue;
                }
                File fileCp = null;
                fileCp = !new Path(classPath).isAbsolute() ? new File(this.tmp, classPath) : new File(classPath);
                if (nonExistentSubdir.equals(classPath)) {
                    expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm() + "/");
                    continue;
                }
                expectedClassPaths.add(fileCp.toURI().toURL().toExternalForm());
            }
            List<String> actualClassPaths = Arrays.asList(classPathAttr.split(" "));
            Collections.sort(expectedClassPaths);
            Collections.sort(actualClassPaths);
            Assert.assertEquals(expectedClassPaths, actualClassPaths);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOG.warn("exception closing jarFile: " + classPathJar, (Throwable)e);
                }
            }
        }
    }

    @Test
    public void testGetJarsInDirectory() throws Exception {
        List jars = FileUtil.getJarsInDirectory((String)"/foo/bar/bogus/");
        Assert.assertTrue((String)"no jars should be returned for a bogus path", (boolean)jars.isEmpty());
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertTrue((boolean)this.tmp.mkdirs());
        File jar1 = new File(this.tmp, "wildcard1.jar");
        File jar2 = new File(this.tmp, "wildcard2.JAR");
        List<File> matches = Arrays.asList(jar1, jar2);
        for (File match : matches) {
            Assert.assertTrue((String)("failure creating file: " + match), (boolean)match.createNewFile());
        }
        Assert.assertTrue((boolean)new File(this.tmp, "text.txt").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "executable.exe").createNewFile());
        Assert.assertTrue((boolean)new File(this.tmp, "README").createNewFile());
        String directory = this.tmp.getCanonicalPath();
        jars = FileUtil.getJarsInDirectory((String)directory);
        Assert.assertEquals((String)"there should be 2 jars", (long)2L, (long)jars.size());
        for (Path jar : jars) {
            URL url = jar.toUri().toURL();
            Assert.assertTrue((String)"the jar should match either of the jars", (url.equals(jar1.toURI().toURL()) || url.equals(jar2.toURI().toURL()) ? 1 : 0) != 0);
        }
    }

    @Ignore
    public void setupCompareFs() {
        String host1 = "1.2.3.4";
        String host2 = "2.3.4.5";
        int port1 = 7000;
        int port2 = 7001;
        String uris1 = "hdfs://" + host1 + ":" + Integer.toString(port1) + "/tmp/foo";
        String uris2 = "hdfs://" + host1 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris3 = "hdfs://" + host2 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris4 = "hdfs://" + host2 + ":" + Integer.toString(port2) + "/tmp/foo";
        String uris5 = "file:///" + host1 + ":" + Integer.toString(port1) + "/tmp/foo";
        String uris6 = "hdfs:///" + host1 + "/tmp/foo";
        try {
            this.uri1 = new URI(uris1);
            this.uri2 = new URI(uris2);
            this.uri3 = new URI(uris3);
            this.uri4 = new URI(uris4);
            this.uri5 = new URI(uris5);
            this.uri6 = new URI(uris6);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.inet1 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet1.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet2 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet2.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet3 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet3.getCanonicalHostName()).thenReturn((Object)host2);
        this.inet4 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet4.getCanonicalHostName()).thenReturn((Object)host2);
        this.inet5 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet5.getCanonicalHostName()).thenReturn((Object)host1);
        this.inet6 = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)this.inet6.getCanonicalHostName()).thenReturn((Object)host1);
        try {
            Mockito.when((Object)InetAddress.getByName(uris1)).thenReturn((Object)this.inet1);
            Mockito.when((Object)InetAddress.getByName(uris2)).thenReturn((Object)this.inet2);
            Mockito.when((Object)InetAddress.getByName(uris3)).thenReturn((Object)this.inet3);
            Mockito.when((Object)InetAddress.getByName(uris4)).thenReturn((Object)this.inet4);
            Mockito.when((Object)InetAddress.getByName(uris5)).thenReturn((Object)this.inet5);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.fs1 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs1.getUri()).thenReturn((Object)this.uri1);
        this.fs2 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs2.getUri()).thenReturn((Object)this.uri2);
        this.fs3 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs3.getUri()).thenReturn((Object)this.uri3);
        this.fs4 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs4.getUri()).thenReturn((Object)this.uri4);
        this.fs5 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs5.getUri()).thenReturn((Object)this.uri5);
        this.fs6 = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs6.getUri()).thenReturn((Object)this.uri6);
    }

    @Test
    public void testCompareFsNull() throws Exception {
        this.setupCompareFs();
        Assert.assertEquals((Object)FileUtil.compareFs(null, (FileSystem)this.fs1), (Object)false);
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs1, null), (Object)false);
    }

    @Test
    public void testCompareFsDirectories() throws Exception {
        this.setupCompareFs();
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs1), (Object)true);
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs2), (Object)false);
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs5), (Object)false);
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs3, (FileSystem)this.fs4), (Object)true);
        Assert.assertEquals((Object)FileUtil.compareFs((FileSystem)this.fs1, (FileSystem)this.fs6), (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=8000L)
    public void testCreateSymbolicLinkUsingJava() throws IOException {
        this.setupDirs();
        File simpleTar = new File(this.del, FILE);
        FileOutputStream os = new FileOutputStream(simpleTar);
        TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)os);
        File untarFile = null;
        try {
            String tmpDir = "tmp/test";
            File tmpDir1 = new File("tmp/test", "dir1/");
            File tmpDir2 = new File("tmp/test", "dir2/");
            tmpDir1.mkdirs();
            tmpDir2.mkdirs();
            java.nio.file.Path symLink = FileSystems.getDefault().getPath(tmpDir1.getPath() + "/sl", new String[0]);
            Files.createSymbolicLink(symLink, FileSystems.getDefault().getPath(tmpDir2.getPath(), new String[0]), new FileAttribute[0]).toString();
            Assert.assertTrue((boolean)Files.isSymbolicLink(symLink.toAbsolutePath()));
            this.putEntriesInTar(tos, tmpDir1.getParentFile());
            tos.close();
            untarFile = new File("tmp/test", "2");
            FileUtil.unTarUsingJava((File)simpleTar, (File)untarFile, (boolean)false);
            Assert.assertTrue((boolean)Files.exists(untarFile.toPath(), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.exists(FileSystems.getDefault().getPath(untarFile.getPath(), "tmp/test"), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isSymbolicLink(FileSystems.getDefault().getPath(untarFile.getPath().toString(), symLink.toString())));
        }
        finally {
            FileUtils.deleteDirectory((File)new File("tmp"));
            tos.close();
        }
    }

    private void putEntriesInTar(TarArchiveOutputStream tos, File f) throws IOException {
        if (Files.isSymbolicLink(f.toPath())) {
            TarArchiveEntry tarEntry = new TarArchiveEntry(f.getPath(), 50);
            tarEntry.setLinkName(Files.readSymbolicLink(f.toPath()).toString());
            tos.putArchiveEntry((ArchiveEntry)tarEntry);
            tos.closeArchiveEntry();
            return;
        }
        if (f.isDirectory()) {
            tos.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(f));
            tos.closeArchiveEntry();
            for (File child : f.listFiles()) {
                this.putEntriesInTar(tos, child);
            }
        }
        if (f.isFile()) {
            int count;
            tos.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(f));
            BufferedInputStream origin = new BufferedInputStream(new FileInputStream(f));
            byte[] data = new byte[2048];
            while ((count = origin.read(data)) != -1) {
                tos.write(data, 0, count);
            }
            tos.flush();
            tos.closeArchiveEntry();
            origin.close();
        }
    }

    @Test
    public void testReadSymlinkWithNullInput() {
        String result = FileUtil.readLink(null);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testReadSymlink() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        File link = new File(this.del, "_link");
        FileUtil.symLink((String)file.getAbsolutePath(), (String)link.getAbsolutePath());
        String result = FileUtil.readLink((File)link);
        Assert.assertEquals((Object)file.getAbsolutePath(), (Object)result);
        file.delete();
        link.delete();
    }

    @Test
    public void testReadSymlinkWithAFileAsInput() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        this.del.mkdirs();
        File file = new File(this.del, FILE);
        String result = FileUtil.readLink((File)file);
        Assert.assertEquals((Object)"", (Object)result);
        file.delete();
    }

    public static class MyFile
    extends File {
        private static final long serialVersionUID = 1L;

        public MyFile(File f) {
            super(f.getAbsolutePath());
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public boolean delete() {
            LOG.info("Trying to delete myFile " + this.getAbsolutePath());
            boolean bool = false;
            bool = this.getName().equals(TestFileUtil.file1Name) ? false : super.delete();
            if (bool) {
                LOG.info("Deleted " + this.getAbsolutePath() + " successfully");
            } else {
                LOG.info("Cannot delete " + this.getAbsolutePath());
            }
            return bool;
        }

        @Override
        public File[] listFiles() {
            File[] files = super.listFiles();
            if (files == null) {
                return null;
            }
            List<File> filesList = Arrays.asList(files);
            Collections.sort(filesList);
            File[] myFiles = new MyFile[files.length];
            int i = 0;
            for (File f : filesList) {
                myFiles[i++] = new MyFile(f);
            }
            return myFiles;
        }
    }
}

